/*
 * Decompiled with CFR 0.152.
 */
package cn.bluejoe.elfinder.impl;

import cn.bluejoe.elfinder.impl.FsSecurityCheckFilterMapping;
import cn.bluejoe.elfinder.impl.FsSecurityCheckForAll;
import cn.bluejoe.elfinder.service.FsItem;
import cn.bluejoe.elfinder.service.FsSecurityChecker;
import cn.bluejoe.elfinder.service.FsService;
import java.io.IOException;
import java.util.List;

public class FsSecurityCheckerChain
implements FsSecurityChecker {
    private static final FsSecurityChecker DEFAULT_SECURITY_CHECKER = new FsSecurityCheckForAll();
    List<FsSecurityCheckFilterMapping> _filterMappings;

    private FsSecurityChecker getChecker(FsService fsService, FsItem fsi) throws IOException {
        String hash = fsService.getHash(fsi);
        for (FsSecurityCheckFilterMapping mapping : this._filterMappings) {
            if (!mapping.matches(hash)) continue;
            return mapping.getChecker();
        }
        return DEFAULT_SECURITY_CHECKER;
    }

    public List<FsSecurityCheckFilterMapping> getFilterMappings() {
        return this._filterMappings;
    }

    @Override
    public boolean isLocked(FsService fsService, FsItem fsi) throws IOException {
        return this.getChecker(fsService, fsi).isLocked(fsService, fsi);
    }

    @Override
    public boolean isReadable(FsService fsService, FsItem fsi) throws IOException {
        return this.getChecker(fsService, fsi).isReadable(fsService, fsi);
    }

    @Override
    public boolean isWritable(FsService fsService, FsItem fsi) throws IOException {
        return this.getChecker(fsService, fsi).isWritable(fsService, fsi);
    }

    public void setFilterMappings(List<FsSecurityCheckFilterMapping> filterMappings) {
        this._filterMappings = filterMappings;
    }
}

