/*
 * Decompiled with CFR 0.152.
 */
package cz.triangle.domy.www;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import cz.rtnext.rs.data.Estate;
import cz.rtnext.rs.data.ObsahTabulkaNemovitosti;
import cz.triangle.domy.Lokalita;
import cz.triangle.domy.PolozkaMenu;
import cz.triangle.domy.action.StrankaNalezenych;
import cz.triangle.domy.www.DefiniceTabulky;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class NemovitostiDelegate {
    public List nactiDeveloperskeProjekty(Map<String, String> filtr, Session hsess) {
        String ostatni;
        String komerce;
        String domy;
        List vysledek = null;
        Criteria criteriaIdProjektu = hsess.createCriteria(Estate.class);
        criteriaIdProjektu.setProjection(Projections.distinct((Projection)Projections.property((String)"idProjektu")));
        criteriaIdProjektu.add(Restrictions.isNotNull((String)"idProjektu"));
        Disjunction dis = Restrictions.disjunction();
        String byty = filtr.get("byty");
        if (byty != null && byty.equalsIgnoreCase("true")) {
            dis.add((Criterion)Restrictions.eq((String)"typeOfRealEstateLong", (Object)new Long(1L)));
        }
        if ((domy = filtr.get("domy")) != null && domy.equalsIgnoreCase("true")) {
            dis.add((Criterion)Restrictions.eq((String)"typeOfRealEstateLong", (Object)new Long(2L)));
        }
        if ((komerce = filtr.get("komerce")) != null && komerce.equalsIgnoreCase("true")) {
            dis.add((Criterion)Restrictions.eq((String)"typeOfRealEstateLong", (Object)new Long(4L)));
        }
        if ((ostatni = filtr.get("ostatni")) != null && ostatni.equalsIgnoreCase("true")) {
            dis.add(Restrictions.not((Criterion)Restrictions.in((String)"typeOfRealEstateLong", (Object[])new Long[]{new Long(1L), new Long(2L), new Long(3L)})));
        }
        criteriaIdProjektu.add((Criterion)dis);
        List listIdProjektu = criteriaIdProjektu.list();
        Criteria criteria = hsess.createCriteria(Lokalita.class);
        criteria.add(Restrictions.in((String)"idProjektBw", (Collection)listIdProjektu));
        criteria.addOrder(Order.asc((String)"razeni"));
        vysledek = criteria.list();
        return vysledek;
    }

    public void nactiNemovitosti(Map<String, Object> filtr, Map<String, Object> vysledek, Session hsess, String id_jazyk) {
        String[] typProstor = (String[])filtr.get("typProstor");
        String podminkaTypProstor = "(1=1)";
        if (typProstor != null && typProstor.length > 0) {
            StringBuffer typyProstoru = new StringBuffer();
            int i = 0;
            while (i < typProstor.length) {
                String idProstoru = typProstor[i];
                if (i > 0) {
                    typyProstoru.append(',');
                }
                typyProstoru.append(idProstoru);
                ++i;
            }
            podminkaTypProstor = "(estate.dispositionLong in (" + typyProstoru + "))";
        }
        String typProdeje = (String)filtr.get("typProdeje");
        String podminkaTypProdeje = "(1=1)";
        if (typProdeje != null && typProdeje.trim().length() > 0 && !typProdeje.equalsIgnoreCase("-1")) {
            podminkaTypProdeje = "(estate.typeOfCommissionLong=" + typProdeje + ")";
        }
        String cenaMin = (String)filtr.get("cenaMin");
        String podminkaCenaMin = "(1=1)";
        if (cenaMin != null && cenaMin.trim().length() > 0 && !cenaMin.equalsIgnoreCase("-1")) {
            podminkaCenaMin = "(estate.price>=" + cenaMin + ")";
        }
        String cenaMax = (String)filtr.get("cenaMax");
        String podminkaCenaMax = "(1=1)";
        if (cenaMax != null && cenaMax.trim().length() > 0 && !cenaMax.equalsIgnoreCase("-1")) {
            podminkaCenaMax = "(estate.price<=" + cenaMax + ")";
        }
        String typNemovitosti = (String)filtr.get("typNemovitosti");
        String podminkaTypNemovitosti = "(1=1)";
        boolean jePozemek = false;
        if (typNemovitosti != null && typNemovitosti.trim().length() > 0 && !typNemovitosti.equalsIgnoreCase("-1")) {
            podminkaTypNemovitosti = "(estate.typeOfRealEstateLong=" + typNemovitosti + ")";
            if (typNemovitosti.equalsIgnoreCase("2")) {
                podminkaTypNemovitosti = "((estate.typeOfRealEstateLong in (3)) or (estate.typeOfRealEstateLong in (2) and estate.subtypeOfRealEstateLong not in (4,5)))";
            } else if (typNemovitosti.equalsIgnoreCase("-10")) {
                podminkaTypNemovitosti = "(estate.subtypeOfRealEstateLong in (4,5))";
            } else if (typNemovitosti.equalsIgnoreCase("-20")) {
                podminkaTypNemovitosti = "(estate.typeOfRealEstateLong not in (1,2,4,5) and (estate.subtypeOfRealEstateLong not in (4,5) or estate.subtypeOfRealEstateLong is null))";
            } else if (typNemovitosti.equalsIgnoreCase("-100")) {
                podminkaTypNemovitosti = "(estate.subtypeOfRealEstateLong in (7))";
            } else if (typNemovitosti.equalsIgnoreCase("-150")) {
                podminkaTypNemovitosti = "(estate.subtypeOfRealEstateLong in (8))";
            }
            if (typNemovitosti.equalsIgnoreCase("-200")) {
                podminkaTypNemovitosti = "(estate.subtypeOfRealEstateLong in (9))";
            }
            if (typNemovitosti.equalsIgnoreCase("5")) {
                jePozemek = true;
            }
        }
        String idProjektu = (String)filtr.get("idProjektu");
        String podminkaIdProjektu = "(1=1)";
        if (idProjektu != null && idProjektu.trim().length() > 0 && !idProjektu.equalsIgnoreCase("-1")) {
            podminkaIdProjektu = "(estate.idProjektu=" + idProjektu + ")";
        }
        String velikost = (String)filtr.get("velikost");
        String podminkaVelikost = "(1=1)";
        if (velikost != null && velikost.trim().length() > 0 && !velikost.equalsIgnoreCase("-1")) {
            podminkaVelikost = "(estate.areaUse>=" + velikost + ")";
        }
        String velikostod = (String)filtr.get("velikostod");
        String podminkaVelikostod = "(1=1)";
        if (velikostod != null && velikostod.trim().length() > 0 && !velikostod.equalsIgnoreCase("-1")) {
            podminkaVelikostod = "(estate.areaUse>=" + velikostod + ")";
            if (jePozemek) {
                podminkaVelikostod = "(estate.areaOfLot>=" + velikostod + ")";
            }
        }
        String velikostdo = (String)filtr.get("velikostdo");
        String podminkaVelikostdo = "(1=1)";
        if (velikostdo != null && velikostdo.trim().length() > 0 && !velikostdo.equalsIgnoreCase("-1")) {
            podminkaVelikostdo = "(estate.areaUse<=" + velikostdo + ")";
            if (jePozemek) {
                podminkaVelikostdo = "(estate.areaOfLot<=" + velikostdo + ")";
            }
        }
        String stav = (String)filtr.get("stav");
        String podminkaStav = "(1=1)";
        if (stav != null && stav.trim().length() > 0 && !stav.equalsIgnoreCase("-1")) {
            podminkaStav = stav.equalsIgnoreCase("bezprodanych") ? "(estate.statusOfCommissionLong<>4 and estate.statusOfCommissionLong<>5)" : (stav.equalsIgnoreCase("prodane") ? "(1=1)" : "(estate.statusOfCommissionLong=" + stav + ")");
        }
        String jennovostavby = (String)filtr.get("jennovostavby");
        String podminkaJennovostavby = "(1=1)";
        if (jennovostavby != null && jennovostavby.trim().length() > 0 && !jennovostavby.equalsIgnoreCase("-1") && jennovostavby.equalsIgnoreCase("true")) {
            podminkaJennovostavby = "(estate.statusOfEstateLong=1)";
        }
        String cisloZakazky = (String)filtr.get("cisloZakazky");
        String podminkaCisloZakazky = "(1=1)";
        if (cisloZakazky != null && cisloZakazky.trim().length() > 0 && !cisloZakazky.equalsIgnoreCase("-1")) {
            podminkaCisloZakazky = "(estate.registrationNumber like '%" + cisloZakazky + "%')";
        }
        String okres = (String)filtr.get("okres");
        String podminkaOkres = "(1=1)";
        if (okres != null && okres.trim().length() > 0 && !okres.equalsIgnoreCase("-1")) {
            podminkaOkres = "(estate.lc4Id=" + okres + ")";
        }
        String mesto = (String)filtr.get("mesto");
        String podminkaMesto = "(1=1)";
        if (mesto != null && mesto.trim().length() > 0 && !mesto.equalsIgnoreCase("-1")) {
            podminkaMesto = "(estate.lc5Id=" + mesto + ")";
        }
        String ctvrt = (String)filtr.get("ctvrt");
        String podminkaCtvrt = "(1=1)";
        if (ctvrt != null && ctvrt.trim().length() > 0 && !ctvrt.equalsIgnoreCase("-1")) {
            podminkaCtvrt = "(estate.lc7Id=" + ctvrt + ")";
        }
        String dumNazev = (String)filtr.get("dumNazev");
        String podminkaDumNazev = "(1=1)";
        if (dumNazev != null && dumNazev.trim().length() > 0 && !dumNazev.equalsIgnoreCase("-1")) {
            podminkaDumNazev = "(estate.ufProjektFaze='" + dumNazev + "')";
        }
        String razeni = (String)filtr.get("razeni");
        String podminkaRazeni = "order by estate.numberOfApartment";
        if (razeni != null && razeni.trim().length() > 0) {
            if (razeni.equalsIgnoreCase("nejlevnejsi")) {
                podminkaRazeni = "order by estate.price";
            }
            if (razeni.equalsIgnoreCase("nejnovejsi")) {
                podminkaRazeni = "order by estate.dateOfUpdateDate desc";
            } else if (razeni.equalsIgnoreCase("dispozice")) {
                podminkaRazeni = "order by estate.dispositionLong";
            } else if (razeni.equalsIgnoreCase("velikost")) {
                podminkaRazeni = "order by (estate.areaFloor + estate.areaOfTerrace + estate.areaOfBalcony)";
            } else if (razeni.equalsIgnoreCase("cisloBytu")) {
                podminkaRazeni = "order by estate.numberOfApartment";
            }
        }
        String naStranku = (String)filtr.get("naStranku");
        int iNaStranku = 40;
        try {
            iNaStranku = new Integer(naStranku);
        }
        catch (Exception e) {
            iNaStranku = 40;
        }
        String stranka = (String)filtr.get("stranka");
        int istranka = 1;
        try {
            istranka = new Integer(stranka);
        }
        catch (Exception e) {
            istranka = 1;
        }
        StrankaNalezenych sn = new StrankaNalezenych(hsess, "from Estate estate left join fetch estate.byt byt left join estate.fotos foto left join fetch byt.bytJazs as bytJazs where (foto.order=1 or foto.hid is null)  and (bytJazs.jazyk.id='" + id_jazyk + "' or bytJazs.jazyk.id is null)" + " and " + podminkaTypProstor + " and " + podminkaCenaMin + " and " + podminkaCenaMax + " and " + podminkaTypProdeje + " and " + podminkaTypNemovitosti + " and " + podminkaVelikost + " and " + podminkaVelikostod + " and " + podminkaVelikostdo + " and " + podminkaIdProjektu + " and " + podminkaStav + " and " + podminkaJennovostavby + " and " + podminkaOkres + " and " + podminkaMesto + " and " + podminkaCtvrt + " and " + podminkaCisloZakazky + " and " + podminkaDumNazev + " " + podminkaRazeni + ", foto.order", "select count (*) from Estate estate left join estate.fotos foto where (foto.order=1 or foto.hid is null) and " + podminkaTypProstor + " and " + podminkaCenaMin + " and " + podminkaCenaMax + " and " + podminkaTypProdeje + " and " + podminkaTypNemovitosti + " and " + podminkaVelikost + " and " + podminkaVelikostod + " and " + podminkaVelikostdo + " and " + podminkaIdProjektu + " and " + podminkaStav + " and " + podminkaJennovostavby + " and " + podminkaOkres + " and " + podminkaMesto + " and " + podminkaCtvrt + " and " + podminkaCisloZakazky + " and " + podminkaDumNazev, iNaStranku, istranka);
        vysledek.put("strankaNemovitosti", sn);
    }

    public void nactiCiselniky(Map<String, Object> vysledek, Session hsess) {
        vysledek.put("seznamDispozic", hsess.createSQLQuery("select distinct disposition_long, disposition_string from estate where disposition_long is not null order by disposition_long").list());
        vysledek.put("celkovaCenaMin", hsess.createSQLQuery("select min(price) from estate;").uniqueResult());
        vysledek.put("celkovaCenaMax", hsess.createSQLQuery("select max(price) from estate;").uniqueResult());
        vysledek.put("seznamTypuProdeje", hsess.createSQLQuery("select distinct type_of_commission_long, type_of_commission_string from estate where type_of_commission_long is not null order by type_of_commission_long").list());
    }

    public void nactiTabulkuNemovitosti(Integer idTabulky, Map<String, Object> filtr, Map<String, Object> vysledek, Session hsess, String id_jazyk) throws JsonParseException, JsonMappingException, IOException {
        ObsahTabulkaNemovitosti tabulka = (ObsahTabulkaNemovitosti)hsess.load(ObsahTabulkaNemovitosti.class, (Serializable)idTabulky);
        if (tabulka.getLokalita().getIdProjektBw() != null) {
            filtr.put("idProjektu", tabulka.getLokalita().getIdProjektBw().toString());
        }
        filtr.put("naStranku", "200");
        ObjectMapper mapper = new ObjectMapper();
        DefiniceTabulky prectena = (DefiniceTabulky)mapper.readValue(tabulka.getDefiniceTabulky(), DefiniceTabulky.class);
        List polozky = hsess.createQuery("select polozka from PolozkaMenu polozka, PolozkaMenu polozkaRodic where polozka.typPolozkyMenu.stranka='byty.jsp' and polozkaRodic.lokalita=? and polozka.kodRodic=polozkaRodic.kod order by polozka.razeni").setEntity(0, (Object)tabulka.getLokalita()).list();
        if (polozky.size() > 0) {
            vysledek.put("polozkaByty", (PolozkaMenu)polozky.get(0));
        }
        vysledek.put("definiceTabulky", prectena);
        vysledek.put("tabulka", tabulka);
        filtr.put("dumNazev", prectena.getDum());
        String typNemovitostiString = prectena.getTypNemovitosti();
        try {
            if (typNemovitostiString.equalsIgnoreCase("komerce")) {
                filtr.put("typNemovitosti", "4");
            } else if (typNemovitostiString.equalsIgnoreCase("byty")) {
                filtr.put("typNemovitosti", "1");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.nactiNemovitosti(filtr, vysledek, hsess, id_jazyk);
    }

    public void nactiPorovnavaneNemovitosti(Set<Integer> zapamatovaneSet, Map<String, Object> vysledek, Session hsess) {
        if (zapamatovaneSet == null || zapamatovaneSet.size() == 0) {
            return;
        }
        int i = 0;
        StringBuffer sb = new StringBuffer();
        for (Integer hids : zapamatovaneSet) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(hids);
            ++i;
        }
        if (sb.toString().trim().equalsIgnoreCase("")) {
            sb.append("-1");
        }
        List zapamatovaneNemovitosti = hsess.createQuery("from Estate estate where estate in (" + sb.toString() + ")").list();
        vysledek.put("porovnavaneNemovitosti", zapamatovaneNemovitosti);
    }

    public List nactiDeveloperskeProjekty(Session hsess) {
        List vysledek = null;
        Criteria criteria = hsess.createCriteria(Lokalita.class);
        criteria.add((Criterion)Restrictions.lt((String)"zverejneniOd", (Object)new Date()));
        criteria.add(Restrictions.eqOrIsNull((String)"typStavuLokality.id", (Object)"aktualni"));
        criteria.addOrder(Order.asc((String)"razeni"));
        vysledek = criteria.list();
        return vysledek;
    }
}

