/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.mapping;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.annotation.PayloadRoot;
import org.springframework.ws.server.endpoint.annotation.PayloadRoots;
import org.springframework.ws.server.endpoint.mapping.AbstractAnnotationMethodEndpointMapping;
import org.springframework.ws.server.endpoint.support.PayloadRootUtils;

public class PayloadRootAnnotationMethodEndpointMapping
extends AbstractAnnotationMethodEndpointMapping<QName> {
    private static TransformerFactory transformerFactory = TransformerFactory.newInstance();

    @Override
    protected QName getLookupKeyForMessage(MessageContext messageContext) throws Exception {
        return PayloadRootUtils.getPayloadRootQName(messageContext.getRequest().getPayloadSource(), transformerFactory);
    }

    @Override
    protected List<QName> getLookupKeysForMethod(Method method) {
        ArrayList<QName> result = new ArrayList<QName>();
        PayloadRoots payloadRoots = (PayloadRoots)AnnotationUtils.findAnnotation((Method)method, PayloadRoots.class);
        if (payloadRoots != null) {
            for (PayloadRoot payloadRoot : payloadRoots.value()) {
                result.add(this.getQNameFromAnnotation(payloadRoot));
            }
        } else {
            PayloadRoot payloadRoot = (PayloadRoot)AnnotationUtils.findAnnotation((Method)method, PayloadRoot.class);
            if (payloadRoot != null) {
                result.add(this.getQNameFromAnnotation(payloadRoot));
            }
        }
        return result;
    }

    private QName getQNameFromAnnotation(PayloadRoot payloadRoot) {
        if (StringUtils.hasLength((String)payloadRoot.localPart()) && StringUtils.hasLength((String)payloadRoot.namespace())) {
            return new QName(payloadRoot.namespace(), payloadRoot.localPart());
        }
        return new QName(payloadRoot.localPart());
    }
}

