/*
 * Decompiled with CFR 0.152.
 */
package cz.rtnext.rs.config;

import cn.bluejoe.elfinder.controller.executor.DefaultCommandExecutorFactory;
import cn.bluejoe.elfinder.impl.DefaultFsService;
import cn.bluejoe.elfinder.impl.DefaultFsServiceConfig;
import cn.bluejoe.elfinder.impl.FsSecurityCheckFilterMapping;
import cn.bluejoe.elfinder.impl.FsSecurityCheckForAll;
import cn.bluejoe.elfinder.impl.FsSecurityCheckerChain;
import cn.bluejoe.elfinder.impl.StaticFsServiceFactory;
import cn.bluejoe.elfinder.localfs.LocalFsVolume;
import cn.bluejoe.elfinder.service.FsVolume;
import java.io.File;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@Configuration
@EnableWebMvc
@ComponentScan(value={"cn.bluejoe.elfinder.controller"})
public class ElFinderWebConfig {
    @Autowired
    private ServletContext servletContext;

    @Bean
    public DefaultCommandExecutorFactory commandExecutorFactory() {
        DefaultCommandExecutorFactory commandExecutorFactory = new DefaultCommandExecutorFactory();
        commandExecutorFactory.setClassNamePattern("cn.bluejoe.elfinder.controller.executors.%sCommandExecutor");
        return commandExecutorFactory;
    }

    @Bean
    public StaticFsServiceFactory fsServiceFactory() {
        LocalFsVolume volume = new LocalFsVolume();
        volume.setName("soubory");
        File file = new File(this.servletContext.getRealPath("/dbimg"));
        volume.setRootDir(file);
        DefaultFsServiceConfig serviceConfig = new DefaultFsServiceConfig();
        serviceConfig.setTmbWidth(80);
        DefaultFsService fsService = new DefaultFsService();
        fsService.setServiceConfig(serviceConfig);
        fsService.setVolumes(new FsVolume[]{volume});
        FsSecurityCheckerChain fsSecurityCheckerChain = new FsSecurityCheckerChain();
        FsSecurityCheckForAll fsSecurityCheckForAll = new FsSecurityCheckForAll();
        fsSecurityCheckForAll.setWritable(false);
        FsSecurityCheckFilterMapping fsSecurityCheckFilterMapping = new FsSecurityCheckFilterMapping();
        fsSecurityCheckFilterMapping.setPattern("lokalita_.*");
        fsSecurityCheckFilterMapping.setChecker(fsSecurityCheckForAll);
        ArrayList<FsSecurityCheckFilterMapping> filterMappings = new ArrayList<FsSecurityCheckFilterMapping>();
        filterMappings.add(fsSecurityCheckFilterMapping);
        fsSecurityCheckerChain.setFilterMappings(filterMappings);
        fsService.setSecurityChecker(fsSecurityCheckerChain);
        StaticFsServiceFactory fsServiceFactory = new StaticFsServiceFactory();
        fsServiceFactory.setFsService(fsService);
        return fsServiceFactory;
    }
}

