/*
 * Decompiled with CFR 0.152.
 */
package fr.improve.struts.taglib.layout.skin;

import fr.improve.struts.taglib.layout.formatter.AbstractFormatter;
import fr.improve.struts.taglib.layout.policy.AbstractPolicy;
import fr.improve.struts.taglib.layout.skin.BadSkinConfigurationException;
import fr.improve.struts.taglib.layout.sort.SortRules;
import fr.improve.struts.taglib.layout.util.FieldInterface;
import fr.improve.struts.taglib.layout.util.FormUtilsInterface;
import fr.improve.struts.taglib.layout.util.IButtonImageRenderer;
import fr.improve.struts.taglib.layout.util.ICrumbRenderer;
import fr.improve.struts.taglib.layout.util.IPagerRenderer;
import fr.improve.struts.taglib.layout.util.LayoutUtils;
import fr.improve.struts.taglib.layout.util.TreeviewInterface;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class Skin {
    public static final String CSS_FILE = "skin";
    public static final String IMAGE_DIR = "directory.images";
    public static final String CONFIG_DIR = "directory.config";
    public static final String CSS_DIR = "directory.css";
    public static final String NULL_FIELDS = "display.null.fields";
    public static final String PANEL_CLASS = "panel.class";
    public static final String COLLECTION_CLASS = "collection.class";
    public static final String TABS_CLASS = "tabs.class";
    public static final String FIELD_CLASS = "field.class";
    public static final String FORMATTER_CLASS = "formatter.class";
    public static final String POLICY_CLASS = "policy.class";
    public static final String FOLLOW_LINKS_IF_CHANGED = "follow.change";
    public static final String DISPLAY_ERRORS_MESSAGE = "error.display";
    public static final String FOCUS_FIRST_ERROR_FIELD = "error.focus";
    public static final String SORT_KEEP_ERROR_MESSAGE = "sort.error.keep";
    public static final String SORT_TOKEN_REQUIRED = "sort.token.required";
    public static final String LINK_TOKEN_INCLUDE = "link.token.include";
    public static final String FORMUTIL_CLASSS = "formutils.class";
    public static final String TREEVIEW_CLASSS = "treeview.class";
    public static final String PAGER_CLASS = "pager.class";
    public static final String POPUP_CLASS = "popup.class";
    public static final String CRUMB_CLASS = "crumb.class";
    public static final String BUTTON_CLASS = "button.class";
    public static final String TREE_NUMBER_MENUS_LOADED = "tree.numberOfMenusLoaded";
    public static final String NESTED_COMPATILIBTY_PROPERTY = "nested.compatibility";
    public static final String TREEVIEW_ACTION = "treeview.action";
    public static final String EL_CHARACTER = "el.character";
    public static final String AUTO_SKIP = "autoskip.active";
    public static final String COOKIE = "cookie.active";
    private static String resourcesName = "Struts-Layout";
    private static Map skins = new Hashtable();
    private ResourceBundle resources;
    private ResourceBundle defaultResources;
    private Locale locale;
    private AbstractFormatter formatter;
    private AbstractPolicy policy;
    private FormUtilsInterface formutils;
    private TreeviewInterface treeview;
    private String configDir;
    private String imageDir;
    private String cssDir;
    private boolean nestedCompatbility;
    private boolean sortTokenRequired;
    private boolean linkTokenRequired;
    private int numberOfMenusLoaded;
    private FieldInterface fieldInterface;
    private IPagerRenderer pagerRenderer;
    private ICrumbRenderer crumbRenderer;
    private IButtonImageRenderer buttonRenderer;
    private Map sortingRules = new HashMap();
    private boolean xhtml;

    public static void setResourcesName(String in_name) {
        resourcesName = in_name;
    }

    private Skin(String in_name, String in_locale) {
        this.locale = new Locale(in_name, in_locale);
        try {
            String lc_policyClass;
            this.resources = Skin.loadBundles(resourcesName, this.locale, this);
            this.defaultResources = Skin.loadBundles("Struts-Layout", null, this);
            String lc_formatterClass = this.getProperty(FORMATTER_CLASS);
            if (lc_formatterClass != null && lc_formatterClass.length() > 0) {
                this.formatter = (AbstractFormatter)Skin.loadClass(lc_formatterClass, this).newInstance();
            }
            if ((lc_policyClass = this.getProperty(POLICY_CLASS)) != null && lc_policyClass.length() > 0) {
                this.policy = (AbstractPolicy)Skin.loadClass(lc_policyClass, this).newInstance();
            }
            String lc_fieldInterfaceClass = this.getProperty(FIELD_CLASS);
            this.fieldInterface = (FieldInterface)Skin.loadClass(lc_fieldInterfaceClass, this).newInstance();
            String lc_formUtilsClass = this.getProperty(FORMUTIL_CLASSS);
            this.formutils = (FormUtilsInterface)Skin.loadClass(lc_formUtilsClass, this).newInstance();
            String lc_treeviewClass = this.getProperty(TREEVIEW_CLASSS);
            this.treeview = (TreeviewInterface)Skin.loadClass(lc_treeviewClass, this).newInstance();
            String lc_pagerRendererClass = this.getProperty(PAGER_CLASS);
            this.pagerRenderer = (IPagerRenderer)Skin.loadClass(lc_pagerRendererClass, this).newInstance();
            String lc_crumbRendererClass = this.getProperty(CRUMB_CLASS);
            this.crumbRenderer = (ICrumbRenderer)Skin.loadClass(lc_crumbRendererClass, this).newInstance();
            String lc_buttonRendererClass = this.getProperty(BUTTON_CLASS);
            this.buttonRenderer = (IButtonImageRenderer)Skin.loadClass(lc_buttonRendererClass, this).newInstance();
            this.configDir = this.getProperty(CONFIG_DIR);
            this.imageDir = this.getProperty(IMAGE_DIR);
            this.sortTokenRequired = Boolean.valueOf(this.getProperty(SORT_TOKEN_REQUIRED));
            this.linkTokenRequired = Boolean.valueOf(this.getProperty(LINK_TOKEN_INCLUDE));
            this.numberOfMenusLoaded = Integer.valueOf(this.getProperty(TREE_NUMBER_MENUS_LOADED));
            this.nestedCompatbility = Boolean.valueOf(this.getProperty(NESTED_COMPATILIBTY_PROPERTY));
        }
        catch (MissingResourceException e) {
            throw new BadSkinConfigurationException(e);
        }
        catch (ClassNotFoundException cnfe) {
            throw new BadSkinConfigurationException(cnfe);
        }
        catch (IllegalAccessException iae) {
            throw new BadSkinConfigurationException(iae);
        }
        catch (InstantiationException ie) {
            throw new BadSkinConfigurationException(ie);
        }
        catch (ClassCastException cce) {
            throw new BadSkinConfigurationException(cce);
        }
        this.loadStringRules();
        try {
            this.cssDir = this.getProperty(CSS_DIR);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    protected static ResourceBundle loadBundles(String in_name, Locale in_locale, Object in_object) {
        Locale lc_locale;
        ClassLoader lc_loader = Thread.currentThread().getContextClassLoader();
        if (lc_loader == null) {
            lc_loader = in_object.getClass().getClassLoader();
        }
        if ((lc_locale = in_locale) == null) {
            lc_locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(resourcesName, lc_locale, lc_loader);
    }

    protected static Class loadClass(String in_name, Object in_object) throws ClassNotFoundException {
        ClassLoader lc_loader = Thread.currentThread().getContextClassLoader();
        if (lc_loader == null) {
            lc_loader = in_object.getClass().getClassLoader();
        }
        return lc_loader.loadClass(in_name);
    }

    protected void loadStringRules() {
        Enumeration<String> enumeration = this.resources.getKeys();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement();
            if (!key.startsWith("sort.rules.") || !key.endsWith(".class")) continue;
            int start = 11;
            int end = key.lastIndexOf(46);
            String locale = end > start ? key.substring(start, end) : "";
            String className = this.resources.getString(key).trim();
            try {
                Class clazz = Skin.loadClass(className, this);
                SortRules rules = (SortRules)clazz.newInstance();
                this.sortingRules.put(locale, rules);
            }
            catch (ClassNotFoundException e) {
                throw new BadSkinConfigurationException("String class rules " + className + " not found");
            }
            catch (InstantiationException e) {
                throw new BadSkinConfigurationException("Could not instanciate class rules " + className + " : " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new BadSkinConfigurationException("Could not instanciate class rules " + className + " : " + e.getMessage());
            }
            catch (ClassCastException e) {
                throw new BadSkinConfigurationException("String class rules " + className + " is not an instance of SortRules");
            }
        }
    }

    public SortRules getSortRules(Locale in_locale) {
        if (in_locale == null) {
            return (SortRules)this.sortingRules.get("");
        }
        String key = in_locale.toString();
        SortRules rules = null;
        while (rules == null && key != null) {
            rules = (SortRules)this.sortingRules.get(key);
            if (rules != null) continue;
            int position = key.indexOf(95);
            key = position != -1 ? key.substring(0, position) : (key != null && key.length() > 0 ? "" : null);
        }
        return rules;
    }

    public static Skin getSkin(String in_name, String in_locale) {
        if (LayoutUtils.getNoErrorMode()) {
            return new Skin(in_name, in_locale);
        }
        Skin lc_skin = (Skin)skins.get(String.valueOf(in_name) + "_" + in_locale);
        if (lc_skin == null) {
            lc_skin = new Skin(in_name, in_locale);
            skins.put(String.valueOf(in_name) + "_" + in_locale, lc_skin);
        }
        return lc_skin;
    }

    public String getImageDirectory(ServletRequest in_request) {
        HttpServletRequest lc_request = (HttpServletRequest)in_request;
        if (this.imageDir.charAt(0) == '/') {
            return this.imageDir;
        }
        return String.valueOf(lc_request.getContextPath()) + '/' + this.imageDir;
    }

    public void setImageDir(String in_imageDir) {
        this.imageDir = in_imageDir;
    }

    public String getConfigDirectory(ServletRequest in_request) {
        HttpServletRequest lc_request = (HttpServletRequest)in_request;
        if (this.configDir.charAt(0) == '/') {
            return this.configDir;
        }
        return String.valueOf(lc_request.getContextPath()) + '/' + this.configDir;
    }

    public String getCssDirectory(ServletRequest in_request) {
        if (this.cssDir == null || this.cssDir.length() == 0) {
            return this.getConfigDirectory(in_request);
        }
        HttpServletRequest lc_request = (HttpServletRequest)in_request;
        if (this.cssDir.charAt(0) == '/') {
            return this.cssDir;
        }
        return String.valueOf(lc_request.getContextPath()) + '/' + this.cssDir;
    }

    public void setConfigDir(String in_configDir) {
        this.configDir = in_configDir;
    }

    public boolean getDisplayNullFields() {
        return "true".equalsIgnoreCase(this.getProperty(NULL_FIELDS));
    }

    public boolean getFocusFirstErrorField() {
        return "true".equalsIgnoreCase(this.getProperty(FOCUS_FIRST_ERROR_FIELD, "false"));
    }

    public boolean getSortKeepErrorMessage() {
        return "true".equalsIgnoreCase(this.getProperty(SORT_KEEP_ERROR_MESSAGE, "true"));
    }

    public boolean getFollowLinkIfFormChanged() {
        return "true".equalsIgnoreCase(this.getProperty(FOLLOW_LINKS_IF_CHANGED));
    }

    public boolean getDisplayErrorMessage() {
        return "true".equalsIgnoreCase(this.getProperty(DISPLAY_ERRORS_MESSAGE));
    }

    public String getName() {
        return this.locale.getLanguage();
    }

    public String getLocale() {
        return this.locale.getCountry();
    }

    public String getCssFileName() {
        String lc_fileName = this.getProperty(CSS_FILE);
        if (lc_fileName == null || lc_fileName.length() == 0) {
            return String.valueOf(this.getName()) + ".css";
        }
        return this.getProperty(CSS_FILE);
    }

    public Class getPanelClass(String in_model) {
        Class lc_class = null;
        try {
            lc_class = in_model == null ? Skin.loadClass(this.getProperty(PANEL_CLASS), this) : Skin.loadClass(this.getProperty("panel.class." + in_model), this);
        }
        catch (ClassNotFoundException e) {
            throw new BadSkinConfigurationException(e);
        }
        return lc_class;
    }

    public Class getPopupClass(String in_model) {
        Class lc_class = null;
        try {
            lc_class = in_model == null ? Skin.loadClass(this.getProperty(POPUP_CLASS), this) : Skin.loadClass(this.getProperty("popup.class." + in_model), this);
        }
        catch (ClassNotFoundException e) {
            throw new BadSkinConfigurationException(e);
        }
        return lc_class;
    }

    public Class getCollectionClass(String in_model) {
        Class lc_class = null;
        try {
            lc_class = in_model == null ? Skin.loadClass(this.getProperty(COLLECTION_CLASS), this) : Skin.loadClass(this.getProperty("collection.class." + in_model), this);
        }
        catch (ClassNotFoundException e) {
            throw new BadSkinConfigurationException(e);
        }
        return lc_class;
    }

    public Class getTabsClass() {
        Class lc_class = null;
        try {
            lc_class = Skin.loadClass(this.getProperty(TABS_CLASS), this);
        }
        catch (ClassNotFoundException e) {
            throw new BadSkinConfigurationException(e);
        }
        return lc_class;
    }

    public FieldInterface getFieldInterface() {
        return this.getFieldInterface(null);
    }

    public FieldInterface getFieldInterface(String in_model) {
        if (in_model == null) {
            return this.fieldInterface;
        }
        FieldInterface lc_interface = null;
        try {
            Class lc_class = Skin.loadClass(this.getProperty("field.class." + in_model), this);
            lc_interface = (FieldInterface)lc_class.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new BadSkinConfigurationException(cnfe);
        }
        catch (IllegalAccessException iae) {
            throw new BadSkinConfigurationException(iae);
        }
        catch (InstantiationException ie) {
            throw new BadSkinConfigurationException(ie);
        }
        return lc_interface;
    }

    public IPagerRenderer getPagerRenderer() {
        return this.pagerRenderer;
    }

    public ICrumbRenderer getCrumbRenderer(String in_model) {
        if (in_model == null) {
            return this.crumbRenderer;
        }
        ICrumbRenderer lc_interface = null;
        try {
            Class lc_class = Skin.loadClass(this.getProperty("crumb.class." + in_model), this);
            lc_interface = (ICrumbRenderer)lc_class.newInstance();
        }
        catch (Exception e) {
            throw new BadSkinConfigurationException(e);
        }
        return lc_interface;
    }

    public IButtonImageRenderer getButtonRenderer(String in_model) {
        if (in_model == null) {
            return this.buttonRenderer;
        }
        throw new IllegalStateException("Not implemented");
    }

    public AbstractFormatter getFormatter() {
        if (this.formatter == null) {
            throw new BadSkinConfigurationException("Null formatter");
        }
        return this.formatter;
    }

    public AbstractPolicy getPolicy() {
        if (this.policy == null) {
            throw new BadSkinConfigurationException("Null policy");
        }
        return this.policy;
    }

    public FormUtilsInterface getFormUtils() {
        return this.formutils;
    }

    public boolean isSortTokenRequired() {
        return this.sortTokenRequired;
    }

    public boolean isLinkTokenRequired() {
        return this.linkTokenRequired;
    }

    public String getProperty(String in_property) throws MissingResourceException {
        String lc_value;
        try {
            lc_value = this.resources.getString(in_property);
        }
        catch (MissingResourceException mre) {
            lc_value = this.defaultResources.getString(in_property);
        }
        return lc_value;
    }

    public String getProperty(String in_property, String in_defaultValue) {
        try {
            String lc_value = this.getProperty(in_property);
            return lc_value;
        }
        catch (MissingResourceException e) {
            return in_defaultValue;
        }
    }

    public int getNumberOfMenusLoaded() {
        return this.numberOfMenusLoaded;
    }

    public boolean isNestedCompatible() {
        return this.nestedCompatbility;
    }

    public TreeviewInterface getTreeviewInterface() {
        return this.treeview;
    }

    public String getELCharacter() {
        return this.getProperty(EL_CHARACTER, "$");
    }

    public boolean isAutoskipActivated() {
        return Boolean.TRUE.toString().equals(this.getProperty(AUTO_SKIP, Boolean.FALSE.toString()));
    }

    public boolean isXhtml() {
        return this.xhtml;
    }

    public boolean isCookieActivated() {
        return Boolean.TRUE.toString().equals(this.getProperty(COOKIE, Boolean.TRUE.toString()));
    }
}

