/*
 * Decompiled with CFR 0.152.
 */
package cz.triangle.domy;

import cz.triangle.domy.PolozkaMenu;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class StromMenu {
    private PolozkaMenu tmpPolozka;
    protected ArrayList menu;
    protected ArrayList vybrane;
    protected HashMap polozky;
    protected HashMap podmenu;
    protected PolozkaMenu obsahovaPolozka;
    protected ArrayList tmpDeti;
    protected ArrayList cesta = new ArrayList();

    public StromMenu() {
    }

    public StromMenu(List pol) {
        this.menu = new ArrayList();
        this.vybrane = new ArrayList();
        this.obsahovaPolozka = null;
        this.podmenu = new HashMap();
        this.polozky = new HashMap();
        for (PolozkaMenu polozka : pol) {
            String kodRodic = polozka.getKodRodic();
            if (kodRodic == null) {
                kodRodic = "root";
            }
            this.polozky.put(polozka.getKod(), polozka);
            ArrayList<PolozkaMenu> tmpPodmenu = (ArrayList<PolozkaMenu>)this.podmenu.get(kodRodic);
            if (tmpPodmenu == null) {
                tmpPodmenu = new ArrayList<PolozkaMenu>();
                this.podmenu.put(kodRodic, tmpPodmenu);
            }
            tmpPodmenu.add(polozka);
        }
    }

    public void vytvor(String kod) {
        ArrayList tmp;
        PolozkaMenu zadanaPolozka = null;
        if (kod != null) {
            zadanaPolozka = (PolozkaMenu)this.polozky.get(kod);
        }
        if (zadanaPolozka == null) {
            zadanaPolozka = this.nactiPrvniPolozku();
        }
        if (zadanaPolozka == null) {
            return;
        }
        this.menu.add(this.vytvorUroven(zadanaPolozka));
        this.vybrane.add(this.tmpPolozka);
        this.tmpDeti = (ArrayList)this.podmenu.get(zadanaPolozka.getKod());
        while (this.tmpDeti != null && !this.tmpDeti.isEmpty()) {
            tmp = this.vytvorUrovenNizsi(this.tmpDeti);
            if (tmp == null) break;
            this.vybrane.add(this.tmpPolozka);
            this.menu.add(tmp);
        }
        PolozkaMenu rodic = this.dejNadrazenyElement(zadanaPolozka);
        while (rodic != null) {
            tmp = this.vytvorUroven(rodic);
            if (tmp == null) break;
            this.menu.add(0, tmp);
            this.vybrane.add(0, this.tmpPolozka);
            rodic = this.dejNadrazenyElement(rodic);
        }
        this.nastavUrovne(this.menu);
        this.vytvorCestu();
        this.vypocitejLinky();
    }

    private PolozkaMenu nactiPrvniPolozku() {
        ArrayList rootMenu = (ArrayList)this.podmenu.get("root");
        if (rootMenu != null && rootMenu.size() > 0) {
            return (PolozkaMenu)rootMenu.get(0);
        }
        return null;
    }

    protected ArrayList vytvorUroven(PolozkaMenu zadany) {
        ArrayList<PolozkaMenu> vysledek = new ArrayList<PolozkaMenu>();
        String kod = zadany.getKod();
        if (zadany == null) {
            return null;
        }
        ArrayList seznam = null;
        seznam = zadany.getKodRodic() == null ? (ArrayList)this.podmenu.get("root") : (ArrayList)this.podmenu.get(zadany.getKodRodic());
        for (PolozkaMenu element : seznam) {
            if (element.getKod().equalsIgnoreCase(kod)) {
                element.setVybrany(true);
                this.tmpPolozka = element;
                if (this.obsahovaPolozka == null && element.getObsah().booleanValue()) {
                    this.obsahovaPolozka = element;
                }
            }
            vysledek.add(element);
        }
        return vysledek;
    }

    protected ArrayList vytvorUrovenNizsi(ArrayList seznam) {
        ArrayList<PolozkaMenu> vysledek = new ArrayList<PolozkaMenu>();
        int index = 0;
        for (PolozkaMenu polozka : seznam) {
            if (index == 0) {
                if (this.obsahovaPolozka == null) {
                    polozka.setVybrany(true);
                    this.tmpPolozka = polozka;
                    if (polozka.getObsah().booleanValue()) {
                        this.obsahovaPolozka = polozka;
                    }
                }
                this.tmpDeti = (ArrayList)this.podmenu.get(polozka.getKod());
                ++index;
            }
            vysledek.add(polozka);
        }
        if (vysledek.size() == 0) {
            vysledek = null;
        }
        return vysledek;
    }

    protected PolozkaMenu dejNadrazenyElement(PolozkaMenu zadany) {
        if (zadany == null) {
            return null;
        }
        PolozkaMenu rodic = (PolozkaMenu)this.polozky.get(zadany.getKodRodic());
        if (rodic == null) {
            return null;
        }
        return rodic;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("");
        int uroven = 0;
        for (ArrayList urovenMenu : this.menu) {
            sb.append("Uroven " + uroven + "\n");
            for (PolozkaMenu polozka : urovenMenu) {
                sb.append("\t" + polozka);
                if (polozka == this.obsahovaPolozka) {
                    sb.append(" <<obsah>> ");
                }
                sb.append("\n");
            }
            ++uroven;
        }
        sb.append("\nVybrane polozky\n");
        uroven = 0;
        for (PolozkaMenu element : this.vybrane) {
            sb.append(uroven);
            sb.append(": " + element.getPopisek() + "\n");
            ++uroven;
        }
        return sb.toString();
    }

    protected void nastavUrovne(ArrayList menu) {
        int uroven = 0;
        for (ArrayList urovenMenu : menu) {
            for (PolozkaMenu polozka : urovenMenu) {
                polozka.setUroven(uroven);
            }
            ++uroven;
        }
    }

    protected void vytvorCestu() {
        PolozkaMenu tmpPolozka = this.getObsahovaPolozka();
        while (tmpPolozka != null) {
            this.cesta.add(0, tmpPolozka);
            tmpPolozka = (PolozkaMenu)this.polozky.get(tmpPolozka.getKodRodic());
        }
    }

    protected void vypocitejLinky() {
        for (ArrayList podmenu : this.podmenu.values()) {
            int i = 0;
            while (i < podmenu.size()) {
                PolozkaMenu polozka = (PolozkaMenu)podmenu.get(i);
                this.nastavVypocitanyLink(polozka);
                if (i > 0) {
                    polozka.setKodPredchozi(((PolozkaMenu)podmenu.get(i - 1)).getKod());
                }
                if (i < podmenu.size() - 1) {
                    polozka.setKodNasledujici(((PolozkaMenu)podmenu.get(i + 1)).getKod());
                }
                ++i;
            }
        }
    }

    protected void nastavVypocitanyLink(PolozkaMenu polozka) {
        PolozkaMenu tmpPolozka = polozka;
        while (tmpPolozka != null && !tmpPolozka.getObsah().booleanValue()) {
            ArrayList podm = (ArrayList)this.podmenu.get(tmpPolozka.getKod());
            if (podm == null) {
                return;
            }
            if (podm.size() > 0) {
                tmpPolozka = (PolozkaMenu)podm.get(0);
                continue;
            }
            return;
        }
        polozka.setVypocitanyLink(tmpPolozka.getKod());
    }

    public String getObsahovaHlavickaObrazek() {
        if (this.obsahovaPolozka == null) {
            return null;
        }
        String hlavickaObrazek = this.obsahovaPolozka.getHlavickaObrazek();
        PolozkaMenu rodic = this.dejNadrazenyElement(this.obsahovaPolozka);
        while (rodic != null && (hlavickaObrazek == null || hlavickaObrazek.trim().equalsIgnoreCase(""))) {
            hlavickaObrazek = rodic.getHlavickaObrazek();
            if (hlavickaObrazek != null && !hlavickaObrazek.trim().equalsIgnoreCase("")) break;
            rodic = this.dejNadrazenyElement(rodic);
        }
        if (hlavickaObrazek == null) {
            return this.nactiPrvniPolozku().getHlavickaObrazek();
        }
        return hlavickaObrazek;
    }

    public ArrayList getMenu() {
        return this.menu;
    }

    public void setMenu(ArrayList menu) {
        this.menu = menu;
    }

    public PolozkaMenu getObsahovaPolozka() {
        return this.obsahovaPolozka;
    }

    public void setObsahovaPolozka(PolozkaMenu obsahovaPolozka) {
        this.obsahovaPolozka = obsahovaPolozka;
    }

    public ArrayList getVybrane() {
        return this.vybrane;
    }

    public HashMap getPodmenu() {
        return this.podmenu;
    }

    public void setPodmenu(HashMap podmenu) {
        this.podmenu = podmenu;
    }

    public ArrayList getCesta() {
        return this.cesta;
    }

    public void setCesta(ArrayList cesta) {
        this.cesta = cesta;
    }

    public HashMap getPolozky() {
        return this.polozky;
    }
}

