/*
 * Decompiled with CFR 0.152.
 */
package cz.triangle.domy.www;

import cz.triangle.domy.www.Nalezenec;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.cz.CzechAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleSpanFragmenter;
import org.apache.lucene.search.highlight.TokenSources;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;

public class StrankaNalezenychHledani {
    private String indexDir;
    private String dotaz;
    private int naStranku;
    private int stranka;
    private ArrayList seznam;
    private int pocet;
    private int celkemNalezenych;

    public StrankaNalezenychHledani(String indexDir, String dotaz, int naStranku, int stranka) throws IOException, ParseException {
        this.indexDir = indexDir;
        this.dotaz = dotaz;
        this.stranka = stranka;
        if (stranka < 1) {
            this.stranka = 1;
        }
        this.naStranku = naStranku;
        if (naStranku < 1) {
            this.naStranku = 1;
        }
        this.seznam = new ArrayList();
        this.pocet = 0;
        this.najdi();
    }

    private void najdi() throws IOException, ParseException {
        IndexSearcher is = null;
        try {
            try {
                is = new IndexSearcher((Directory)new SimpleFSDirectory(new File(this.indexDir)), true);
                String q = this.dotaz;
                StringTokenizer st = new StringTokenizer(q);
                StringBuffer sb = new StringBuffer();
                while (st.hasMoreTokens()) {
                    String element = st.nextToken();
                    try {
                        Float.parseFloat(element);
                        sb.append(element);
                        if (!st.hasMoreTokens()) continue;
                        sb.append(" ");
                    }
                    catch (Exception exception) {
                        sb.append(String.valueOf(element) + "*");
                        if (!st.hasMoreTokens()) continue;
                        sb.append(" ");
                    }
                }
                q = sb.toString();
                q = q.trim();
                HashMap boosts = new HashMap();
                String[] fields = new String[]{"title", "obsah"};
                CzechAnalyzer analyzer = new CzechAnalyzer();
                MultiFieldQueryParser qp = new MultiFieldQueryParser(fields, (Analyzer)analyzer);
                qp.setDefaultOperator(QueryParser.AND_OPERATOR);
                Query query = qp.parse(q);
                TopDocs hits = is.search(query, null, 60);
                Highlighter highlighter = new Highlighter(null);
                int i = (this.stranka - 1) * this.naStranku;
                while (i < hits.totalHits && i < this.stranka * this.naStranku) {
                    TokenStream stream = TokenSources.getAnyTokenStream((IndexReader)is.getIndexReader(), (int)hits.scoreDocs[i].doc, (String)"obsah", (Document)is.doc(hits.scoreDocs[i].doc), (Analyzer)analyzer);
                    QueryScorer scorer = new QueryScorer(query, "obsah");
                    SimpleSpanFragmenter fragmenter = new SimpleSpanFragmenter(scorer);
                    highlighter.setFragmentScorer((Scorer)scorer);
                    this.seznam.add(new Nalezenec(is.doc(hits.scoreDocs[i].doc), highlighter.getBestFragment(stream, is.doc(hits.scoreDocs[i].doc).get("obsah"))));
                    ++this.pocet;
                    ++i;
                }
                this.celkemNalezenych = hits.totalHits < 60 ? hits.totalHits : 60;
            }
            catch (Exception exception) {
                if (is != null) {
                    is.close();
                }
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public int getPocet() {
        return this.pocet;
    }

    public int getStranka() {
        return this.stranka;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Nalezenec element : this.seznam) {
            sb.append(element.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public int getCelkemNalezenych() {
        return this.celkemNalezenych;
    }

    public ArrayList getSeznam() {
        return this.seznam;
    }

    public int getNaStranku() {
        return this.naStranku;
    }

    public int getPocetStranek() {
        int vysledek = this.celkemNalezenych / this.naStranku;
        if (this.celkemNalezenych % this.naStranku != 0) {
            ++vysledek;
        }
        return vysledek;
    }

    public int getMinNalezenec() {
        int vysledek = this.stranka * this.naStranku - this.naStranku + 1;
        return vysledek;
    }

    public int getMaxNalezenec() {
        int vysledek = this.stranka * this.naStranku;
        if (vysledek > this.celkemNalezenych) {
            vysledek = this.celkemNalezenych;
        }
        return vysledek;
    }
}

