/*
 * Decompiled with CFR 0.152.
 */
package cz.triangle.domy.www;

import cz.triangle.domy.PolozkaMenu;
import cz.triangle.domy.StromMenu;
import cz.triangle.util.HibernateUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.hibernate.classic.Session;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TmpConnectorServlet
extends HttpServlet {
    private static String baseDir;
    private static boolean debug;

    static {
        debug = false;
    }

    public void init() throws ServletException {
        String realBaseDir;
        File baseFile;
        baseDir = this.getInitParameter("baseDir");
        debug = new Boolean(this.getInitParameter("debug"));
        if (baseDir == null) {
            baseDir = "/UserFiles/";
        }
        if (!(baseFile = new File(realBaseDir = this.getServletContext().getRealPath(baseDir))).exists()) {
            baseFile.mkdir();
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String currentFolderStr;
        if (debug) {
            System.out.println("--- BEGIN DOGET ---");
        }
        response.setContentType("text/xml; charset=UTF-8");
        response.setHeader("Cache-Control", "no-cache");
        PrintWriter out = response.getWriter();
        String commandStr = request.getParameter("Command");
        String typeStr = request.getParameter("Type");
        String currentPath = currentFolderStr = request.getParameter("CurrentFolder");
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        Node root = this.CreateCommonXml(document, commandStr, typeStr, currentFolderStr, String.valueOf(request.getContextPath()) + currentPath);
        if (debug) {
            System.out.println("Command = " + commandStr);
        }
        Session hsess = HibernateUtil.getSessionFactory().getCurrentSession();
        List polozky = hsess.createQuery("from PolozkaMenu polozka where polozka.idJazyk='cz' order by polozka.razeni").list();
        StromMenu strom = new StromMenu(polozky);
        strom.vytvor(null);
        if (commandStr.equals("GetFolders")) {
            this.getFolders(currentPath, strom, root, document);
        } else if (commandStr.equals("GetFoldersAndFiles")) {
            this.getFolders(currentPath, strom, root, document);
            this.getFiles(currentPath, strom, root, document);
        } else if (commandStr.equals("CreateFolder")) {
            String retValue = "103";
            this.setCreateFolderResponse(retValue, root, document);
        }
        document.getDocumentElement().normalize();
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
            if (debug) {
                StreamResult dbgResult = new StreamResult(System.out);
                transformer.transform(source, dbgResult);
                System.out.println("");
                System.out.println("--- END DOGET ---");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        out.flush();
        out.close();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (debug) {
            System.out.println("--- BEGIN DOPOST ---");
        }
        response.setContentType("text/html; charset=UTF-8");
        response.setHeader("Cache-Control", "no-cache");
        PrintWriter out = response.getWriter();
        String commandStr = request.getParameter("Command");
        String typeStr = request.getParameter("Type");
        String currentFolderStr = request.getParameter("CurrentFolder");
        String currentPath = String.valueOf(baseDir) + typeStr + currentFolderStr;
        String currentDirPath = this.getServletContext().getRealPath(currentPath);
        if (debug) {
            System.out.println(currentDirPath);
        }
        String retVal = "203";
        out.flush();
        out.close();
        if (debug) {
            System.out.println("--- END DOPOST ---");
        }
    }

    private void setCreateFolderResponse(String retValue, Node root, Document doc) {
        Element myEl = doc.createElement("Error");
        myEl.setAttribute("number", retValue);
        root.appendChild(myEl);
    }

    private void getFolders(String kodRodic, StromMenu strom, Node root, Document doc) {
        Element folders = doc.createElement("Folders");
        root.appendChild(folders);
        List podmenu = null;
        podmenu = kodRodic.equals("/") ? (List)strom.getMenu().get(0) : (List)strom.getPodmenu().get(kodRodic.substring(1, kodRodic.length() - 1));
        if (podmenu != null) {
            for (PolozkaMenu polozka : podmenu) {
                if (strom.getPodmenu().get(polozka.getKod()) == null) continue;
                Element myEl = doc.createElement("Folder");
                myEl.setAttribute("name", polozka.getKod());
                folders.appendChild(myEl);
            }
        }
    }

    private void getFiles(String kodRodic, StromMenu strom, Node root, Document doc) {
        Element files = doc.createElement("Files");
        root.appendChild(files);
        List podmenu = null;
        podmenu = kodRodic.equals("/") ? (List)strom.getMenu().get(0) : (List)strom.getPodmenu().get(kodRodic.substring(1, kodRodic.length() - 1));
        if (podmenu != null) {
            for (PolozkaMenu polozka : podmenu) {
                Element myEl = doc.createElement("File");
                myEl.setAttribute("name", String.valueOf(polozka.getKod()) + ".html");
                myEl.setAttribute("size", "");
                myEl.setAttribute("url", String.valueOf(polozka.getKod()) + ".do");
                files.appendChild(myEl);
            }
        }
    }

    private Node CreateCommonXml(Document doc, String commandStr, String typeStr, String currentPath, String currentUrl) {
        Element root = doc.createElement("Connector");
        doc.appendChild(root);
        root.setAttribute("command", commandStr);
        root.setAttribute("resourceType", typeStr);
        Element myEl = doc.createElement("CurrentFolder");
        myEl.setAttribute("path", currentPath);
        myEl.setAttribute("url", currentUrl);
        root.appendChild(myEl);
        return root;
    }

    private static String getNameWithoutExtension(String fileName) {
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    private String getExtension(String fileName) {
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }
}

