/*
 * Decompiled with CFR 0.152.
 */
package fr.improve.struts.taglib.layout;

import fr.improve.struts.taglib.layout.LabelledTag;
import fr.improve.struts.taglib.layout.event.EndLayoutEvent;
import fr.improve.struts.taglib.layout.event.LayoutEventListener;
import fr.improve.struts.taglib.layout.event.StartLayoutEvent;
import fr.improve.struts.taglib.layout.util.BasicPanel;
import fr.improve.struts.taglib.layout.util.LayoutUtils;
import fr.improve.struts.taglib.layout.util.PanelInterface;
import fr.improve.struts.taglib.layout.util.TagUtils;
import javax.servlet.jsp.JspException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PanelTag
extends LabelledTag
implements LayoutEventListener {
    private static Log LOG = LogFactory.getLog(PanelTag.class);
    protected static PanelInterface defaultPanel = null;
    protected PanelInterface panel = null;
    protected int cols = 2;
    protected String width;
    protected String height;
    protected String align = null;
    public static final String CENTER = "center";
    public static final String LEFT = "left";
    public static final String RIGHT = "rigth";
    protected short editMode = (short)2;
    protected short createMode = (short)2;
    protected short inspectMode = 1;
    protected short fieldDisplayMode;
    protected String arg0Name;
    protected String arg0Property;
    protected String model;
    protected String jspStyleClass;

    protected void initDynamicValues() {
        super.initDynamicValues();
        this.jspStyleClass = this.styleClass;
        if (this.styleClass == null) {
            this.styleClass = this.getSkin().getProperty("styleclass.panel", null);
        }
    }

    protected void reset() {
        this.styleClass = this.jspStyleClass;
        this.jspStyleClass = null;
        super.reset();
    }

    public Object processStartLayoutEvent(StartLayoutEvent in_event) throws JspException {
        return in_event.consume(this.pageContext, "<tr>");
    }

    public Object processEndLayoutEvent(EndLayoutEvent in_event) throws JspException {
        return in_event.consume(this.pageContext, "</tr>");
    }

    protected void computeDisplayMode() {
        int formMode = this.getSkin().getFormUtils().getFormDisplayMode(this.pageContext);
        switch (formMode) {
            case 0: {
                this.fieldDisplayMode = this.createMode;
                break;
            }
            case 1: {
                this.fieldDisplayMode = this.editMode;
                break;
            }
            case 2: {
                this.fieldDisplayMode = this.inspectMode;
            }
        }
    }

    protected void doAfterBody(StringBuffer buffer) throws JspException {
        this.panel.doAfterBody(buffer);
    }

    protected void doBeforeBody(StringBuffer buffer) throws JspException {
        this.doBeforeBody(buffer, this.align);
    }

    protected void doBeforeBody(StringBuffer buffer, String align) throws JspException {
        this.panel.doBeforeBody(buffer, align);
    }

    protected void doEndPanel(StringBuffer buffer) throws JspException {
        this.panel.doEndPanel(buffer);
    }

    protected void doEndLayout() throws JspException {
        new EndLayoutEvent(this, "</td>").send();
    }

    public int doEndLayoutTag() throws JspException {
        if (this.fieldDisplayMode == 0) {
            return 6;
        }
        StringBuffer buffer = new StringBuffer();
        this.doAfterBody(buffer);
        this.doEndPanel(buffer);
        TagUtils.write(this.pageContext, buffer.toString());
        this.doEndLayout();
        return 6;
    }

    protected void doPrintBlankLine(StringBuffer buffer) throws JspException {
        this.panel.doPrintBlankLine(buffer, this.cols);
    }

    protected void doPrintTitle(StringBuffer buffer) throws JspException {
        Object l_value;
        Object l_bean;
        String l_title = null;
        if (this.arg0Name != null && (l_bean = this.pageContext.findAttribute(this.arg0Name)) != null && (l_value = LayoutUtils.getProperty(l_bean, this.arg0Property)) != null) {
            this.arg0 = l_value.toString();
        }
        if (this.key == null && this.arg0 != null) {
            l_title = this.arg0;
        }
        if (this.key != null || this.name != null) {
            l_title = this.getLabel();
        }
        this.panel.doPrintTitle(buffer, l_title);
    }

    protected void doStartPanel(StringBuffer buffer) throws JspException {
        this.doStartPanel(buffer, this.align);
    }

    protected void doStartPanel(StringBuffer buffer, String align) throws JspException {
        this.init();
        this.panel.init(this.pageContext, this.styleClass, this);
        this.panel.doStartPanel(buffer, align, this.width);
    }

    protected void doStartLayout() throws JspException {
        this.cols = this.getSkin().getFieldInterface().getColumnNumber();
        new StartLayoutEvent(this, "<td valign=\"top\" colspan=\"" + this.cols + "\">").send();
    }

    public int doStartLayoutTag() throws JspException {
        this.computeDisplayMode();
        if (this.fieldDisplayMode == 0) {
            return 0;
        }
        this.doStartLayout();
        StringBuffer buffer = new StringBuffer();
        this.doStartPanel(buffer);
        this.doPrintTitle(buffer);
        this.doBeforeBody(buffer);
        TagUtils.write(this.pageContext, buffer.toString());
        return 1;
    }

    public String getArg0Name() {
        return this.arg0Name;
    }

    public String getArg0Property() {
        return this.arg0Property;
    }

    public PanelInterface getPanelInterface() {
        return this.panel;
    }

    public void init() {
        try {
            defaultPanel = (PanelInterface)this.getSkin().getPanelClass(this.model).newInstance();
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to instanciate model " + this.model), (Throwable)e);
            defaultPanel = new BasicPanel();
        }
        this.panel = defaultPanel;
    }

    public void release() {
        super.release();
        this.cols = 2;
        this.width = null;
        this.height = null;
        this.align = CENTER;
        this.panel = defaultPanel;
        this.model = null;
        this.editMode = (short)2;
        this.createMode = (short)2;
        this.inspectMode = 1;
    }

    public void setAlign(String align) {
        this.align = align;
    }

    public String getAlign() {
        return this.align;
    }

    public void setArg0Name(String newArg0Name) {
        this.arg0Name = newArg0Name;
    }

    public void setArg0Property(String newArg0Property) {
        this.arg0Property = newArg0Property;
    }

    public void setCols(int cols) {
        this.cols = cols;
    }

    public void setMode(String mode) throws JspException {
        if (mode == null) {
            return;
        }
        if (mode.length() != 5) {
            throw new JspException("fieldTag mode " + mode + " is invalid.");
        }
        char c = mode.charAt(0);
        this.createMode = this.convertMode(c);
        c = mode.charAt(2);
        this.editMode = this.convertMode(c);
        c = mode.charAt(4);
        this.inspectMode = this.convertMode(c);
    }

    private short convertMode(char c) throws JspException {
        short lc_mode;
        switch (c) {
            case 'N': {
                lc_mode = 0;
                break;
            }
            case 'E': {
                lc_mode = 2;
                break;
            }
            case 'I': {
                lc_mode = 1;
                break;
            }
            default: {
                throw new JspException("panelTag mode " + c + " is invalid. Valid mode are N, E and I");
            }
        }
        return lc_mode;
    }

    public void setWidth(String width) {
        this.width = !width.equals("0") ? width : null;
    }

    public String getWidth() {
        return this.width;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }
}

