/*
 * Decompiled with CFR 0.152.
 */
package fr.improve.struts.taglib.layout.sort;

import fr.improve.struts.taglib.layout.sort.SortRules;
import fr.improve.struts.taglib.layout.util.LayoutUtils;
import java.util.Comparator;
import javax.servlet.jsp.JspException;

public class BeanComparator
implements Comparator {
    protected String property;
    protected SortRules stringSortingRules;

    public BeanComparator(String in_property, SortRules in_rules) {
        this.property = in_property;
        this.stringSortingRules = in_rules;
    }

    public int compare(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return this.compareNull(o1, o2);
        }
        try {
            Object lc_object1 = LayoutUtils.getProperty(o1, this.property);
            Object lc_object2 = LayoutUtils.getProperty(o2, this.property);
            if (lc_object1 == null || lc_object2 == null) {
                return this.compareNull(lc_object1, lc_object2);
            }
            if (lc_object1 instanceof String && lc_object2 instanceof String) {
                return this.compareString((String)lc_object1, (String)lc_object2);
            }
            if (lc_object1 instanceof Comparable && lc_object2 instanceof Comparable) {
                return this.compareComparable((Comparable)lc_object1, (Comparable)lc_object2);
            }
            if (lc_object1 instanceof Boolean && lc_object2 instanceof Boolean) {
                return this.compareBoolean((Boolean)lc_object1, (Boolean)lc_object2);
            }
            throw new ClassCastException("Cannot compare objects of class " + (lc_object1 != null ? lc_object1.getClass().getName() : "null") + " and " + (lc_object2 != null ? lc_object2.getClass().getName() : "null"));
        }
        catch (JspException e) {
            throw new ClassCastException();
        }
    }

    public int compareBoolean(Boolean in_bool1, Boolean in_bool2) {
        boolean lc_b1 = in_bool1;
        boolean lc_b2 = in_bool2;
        if (lc_b1 && lc_b2 || !lc_b1 && !lc_b2) {
            return 0;
        }
        if (!lc_b1) {
            return -1;
        }
        if (!lc_b2) {
            return 1;
        }
        return 0;
    }

    public int compareString(String lc_value1, String lc_value2) {
        if (this.stringSortingRules == null) {
            return lc_value1.compareTo(lc_value2);
        }
        return this.stringSortingRules.getRules().compare(lc_value1, lc_value2);
    }

    public int compareComparable(Comparable lc_value1, Comparable lc_value2) {
        return lc_value1.compareTo(lc_value2);
    }

    public int compareNull(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return 0;
    }
}

