/*
 * Decompiled with CFR 0.152.
 */
package fr.improve.struts.taglib.layout.tab;

import fr.improve.struts.taglib.layout.BodyLayoutTagSupport;
import fr.improve.struts.taglib.layout.event.EndLayoutEvent;
import fr.improve.struts.taglib.layout.event.ErrorEvent;
import fr.improve.struts.taglib.layout.event.ErrorEventListener;
import fr.improve.struts.taglib.layout.event.StartLayoutEvent;
import fr.improve.struts.taglib.layout.tab.TabHeader;
import fr.improve.struts.taglib.layout.util.LayoutUtils;
import fr.improve.struts.taglib.layout.util.TabsInterface;
import fr.improve.struts.taglib.layout.util.TagUtils;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

public class TabsTag
extends BodyLayoutTagSupport
implements ErrorEventListener {
    private Map tabs = new TreeMap(new TabComparator());
    private String LAST_TAB_KEY = "fr.improve.struts.taglib.layout.tab.TabsTag.KEY";
    private String currentId;
    private int currentTab = -1;
    private TabsInterface tabsRenderer;
    private String styleClass;
    private String width;
    private String selectedTabKeyName;
    private String selectedTabKey;
    private boolean tabAlreadySelected = false;

    public String addTab(String in_titleKey, String in_title, String in_href, String in_reqCode, String in_width, boolean in_selected) {
        ++this.currentTab;
        StringBuffer lc_id = new StringBuffer("tabs");
        lc_id.append(this.currentId);
        lc_id.append("tab");
        lc_id.append(this.currentTab);
        TabHeader lc_header = new TabHeader();
        lc_header.width = in_width;
        lc_header.title = in_title;
        lc_header.titleKey = in_titleKey;
        lc_header.href = in_href;
        lc_header.reqCode = in_reqCode;
        if (in_selected) {
            lc_header.styleClass = this.tabsRenderer.getHeaderEnabledStyle();
            this.tabAlreadySelected = true;
        } else {
            lc_header.styleClass = this.tabsRenderer.getHeaderDisabledStyle();
        }
        this.tabs.put(String.valueOf(this.currentTab), lc_header);
        return lc_id.toString();
    }

    private String computeNewTabId() {
        Integer lc_id = (Integer)this.pageContext.getRequest().getAttribute(this.LAST_TAB_KEY);
        if (lc_id == null) {
            lc_id = new Integer(0);
        }
        this.pageContext.getRequest().setAttribute(this.LAST_TAB_KEY, (Object)new Integer(lc_id + 1));
        return lc_id.toString();
    }

    public void processErrorEvent(ErrorEvent in_event) {
        TabHeader lc_header = (TabHeader)this.tabs.get(String.valueOf(this.currentTab));
        lc_header.styleClass = this.tabsRenderer.getHeaderErrorStyle();
    }

    public int doStartLayoutTag() throws JspException {
        try {
            this.tabsRenderer = (TabsInterface)LayoutUtils.getSkin(this.pageContext.getSession()).getTabsClass().newInstance();
            this.tabsRenderer.init(this.pageContext, this.styleClass, (TagSupport)this);
            this.currentId = this.computeNewTabId();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        new StartLayoutEvent(this, new StringBuffer("<td colspan=\"").append(LayoutUtils.getSkin(this.pageContext.getSession()).getFieldInterface().getColumnNumber()).append("\">").toString()).send();
        return 2;
    }

    public int doAfterBody() throws JspException {
        StringBuffer lc_buffer = new StringBuffer();
        this.tabsRenderer.doStartPanel(lc_buffer, "center", this.width);
        this.tabsRenderer.doStartHeaders(lc_buffer);
        this.tabsRenderer.doPrintHeaders(lc_buffer, this.currentId, this.tabs);
        this.tabsRenderer.doEndHeaders(lc_buffer);
        this.tabsRenderer.doBeforeBody(lc_buffer, "center");
        TagUtils.writePrevious(this.pageContext, lc_buffer.toString());
        lc_buffer.setLength(0);
        if (this.bodyContent != null) {
            TagUtils.writePrevious(this.pageContext, this.bodyContent.getString());
            this.bodyContent.clearBody();
        }
        this.tabsRenderer.doAfterBody(lc_buffer);
        this.tabsRenderer.doEndPanel(lc_buffer);
        TagUtils.writePrevious(this.pageContext, lc_buffer.toString());
        return 0;
    }

    public int doEndLayoutTag() throws JspException {
        new EndLayoutEvent(this, "</td>").send();
        this.tabsRenderer = null;
        this.currentId = null;
        this.currentTab = -1;
        this.tabs.clear();
        this.tabAlreadySelected = false;
        return 6;
    }

    public void release() {
        super.release();
        this.selectedTabKeyName = null;
        this.styleClass = null;
        this.width = null;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getSelectedTabKeyName() {
        return this.selectedTabKeyName;
    }

    public void setSelectedTabKeyName(String selectedTabKeyName) {
        this.selectedTabKeyName = selectedTabKeyName;
    }

    public boolean isTabAlreadySelected() {
        return this.tabAlreadySelected;
    }

    public String getSelectedTabKey() {
        return this.selectedTabKey;
    }

    public void setSelectedTabKey(String in_name) {
        this.selectedTabKey = in_name;
    }

    private class TabComparator
    implements Comparator {
        private TabComparator() {
        }

        public int compare(Object o1, Object o2) {
            int l2;
            String s1 = (String)o1;
            String s2 = (String)o2;
            int l1 = s1.length();
            if (l1 == (l2 = s2.length())) {
                return s1.compareTo(s2);
            }
            return l1 - l2;
        }
    }
}

