/*
 * Decompiled with CFR 0.152.
 */
package fr.improve.struts.taglib.layout.treeview;

import fr.improve.struts.taglib.layout.PanelTag;
import fr.improve.struts.taglib.layout.menu.MenuComponent;
import fr.improve.struts.taglib.layout.treeview.TreeItemInfo;
import fr.improve.struts.taglib.layout.util.LayoutUtils;
import fr.improve.struts.taglib.layout.util.MenuInterface;
import fr.improve.struts.taglib.layout.util.TagUtils;
import fr.improve.struts.taglib.layout.util.TreeviewInterface;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;

public class TreeViewTag
extends PanelTag
implements MenuInterface {
    private static final String TREEVIEW_NUMBER = "fr.improve.struts.taglib.layout.TreeviewTag.TREEVIEW_NUMBER";
    public static final String DEFAULT_TREEVIEW_ACTION = "treeview.do";
    protected Vector menus = new Vector();
    protected boolean autoIncrement = true;
    protected int expandedLevelsAtFirst = -1;

    public void addItem(MenuComponent item) {
        this.menus.add(item);
    }

    public void addItems(MenuComponent[] items) {
        this.menus.addAll(Arrays.asList(items));
    }

    public int doEndLayoutTag() throws JspException {
        boolean allowIndirection = false;
        if (this.menus.size() == 0 && this.name != null) {
            MenuComponent lc_tree = LayoutUtils.getMenu(this.pageContext, this.name);
            if (lc_tree == null) {
                throw new JspException("Could not find menu named \"" + this.name + "\"");
            }
            this.addItems(lc_tree.getMenuComponents());
            allowIndirection = true;
        }
        this.doStartLayout();
        StringBuffer buffer = new StringBuffer();
        this.doStartPanel(buffer);
        buffer.append("<tr><td>");
        String lc_i = this.computeTreeviewId();
        buffer.append("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" id=\"treeView" + lc_i + "\">\n");
        String lc_styleClass = this.styleClass;
        if (lc_styleClass == null) {
            lc_styleClass = "";
        }
        if (lc_styleClass.length() != 0 && this.autoIncrement) {
            lc_styleClass = String.valueOf(lc_styleClass) + "1";
        }
        TreeViewTag.doPrintMenu(buffer, this.menus.toArray(new MenuComponent[this.menus.size()]), (HttpServletRequest)this.pageContext.getRequest(), this.pageContext.getServletContext(), this.bundle, lc_i, this.name, lc_styleClass, allowIndirection);
        buffer.append("</table>");
        if (this.pageContext.getRequest().getAttribute("fr.improve.struts.taglib.layout.treeview.TreeViewTag.KEY") == null && this.name != null && allowIndirection) {
            buffer.append("<iframe id=\"treeFrame\" name=\"treeFrame\" style=\"width:0px; height:0px; border: 0px\" src=\"");
            buffer.append(this.buildIFrameSource((HttpServletRequest)this.pageContext.getRequest()));
            buffer.append("\"></iframe>");
            this.pageContext.getRequest().setAttribute("fr.improve.struts.taglib.layout.treeview.TreeViewTag.KEY", (Object)"");
        }
        buffer.append("</td></tr>");
        this.doEndPanel(buffer);
        if (this.expandedLevelsAtFirst > 0) {
            Cookie[] lc_cookies = ((HttpServletRequest)this.pageContext.getRequest()).getCookies();
            boolean lc_firstDisplay = true;
            if (lc_cookies != null) {
                int i = 0;
                while (i < lc_cookies.length) {
                    if (lc_cookies[i].getName().equals("treeView")) {
                        lc_firstDisplay = false;
                        break;
                    }
                    ++i;
                }
            }
            if (lc_firstDisplay) {
                buffer.append("<script>");
                buffer.append("expandFirstLevels(\"");
                buffer.append(lc_i);
                buffer.append("\", ");
                buffer.append(this.expandedLevelsAtFirst);
                buffer.append(");");
                buffer.append("</script>");
            }
        }
        TagUtils.write(this.pageContext, buffer.toString());
        this.doEndLayout();
        this.menus.removeAllElements();
        this.name = null;
        return 6;
    }

    private String computeTreeviewId() throws JspException {
        if (this.name != null) {
            return this.name;
        }
        TreeViewIds treeviewIds = (TreeViewIds)this.pageContext.getSession().getAttribute(TREEVIEW_NUMBER);
        if (treeviewIds == null) {
            treeviewIds = new TreeViewIds();
            this.pageContext.getSession().setAttribute(TREEVIEW_NUMBER, (Object)treeviewIds);
        }
        if (this.name != null) {
            Integer lc_id = (Integer)treeviewIds.namedTreeview.get(this.name);
            if (lc_id == null) {
                lc_id = new Integer(treeviewIds.getNewId());
                treeviewIds.namedTreeview.put(this.name, lc_id);
            }
            return lc_id.toString();
        }
        if (this.pageContext.getRequest().getAttribute(TREEVIEW_NUMBER) != null) {
            throw new JspException("There can be only one anonymous treeview per request");
        }
        this.pageContext.getRequest().setAttribute(TREEVIEW_NUMBER, (Object)"");
        Integer lc_id = (Integer)treeviewIds.anonymousTreeview.get(((HttpServletRequest)this.pageContext.getRequest()).getRequestURI());
        if (lc_id == null) {
            lc_id = new Integer(treeviewIds.getNewId());
            treeviewIds.anonymousTreeview.put(((HttpServletRequest)this.pageContext.getRequest()).getRequestURI(), lc_id);
        }
        return lc_id.toString();
    }

    public static int doPrintMenu(StringBuffer buffer, MenuComponent[] menus, HttpServletRequest in_request, ServletContext in_servletcontext, String in_bundle, String in_path, String in_name, String in_styleClass) throws JspException {
        return TreeViewTag.doPrintMenu(buffer, menus, in_request, in_servletcontext, in_bundle, in_path, in_name, in_styleClass, true);
    }

    public static int doPrintMenu(StringBuffer buffer, MenuComponent[] menus, HttpServletRequest in_request, ServletContext in_servletcontext, String in_bundle, String in_path, String in_name, String in_styleClass, boolean in_allowIndirection) throws JspException {
        TreeviewInterface lc_treeviewRenderer = LayoutUtils.getSkin(in_request.getSession()).getTreeviewInterface();
        TreeItemInfo lc_info = new TreeItemInfo();
        int lc_numberOfMenusPrinted = menus.length;
        lc_info.imageDirectory = LayoutUtils.getSkin(in_request.getSession()).getImageDirectory((ServletRequest)in_request);
        lc_info.styleClass = lc_treeviewRenderer.computeStyleClass(in_styleClass);
        lc_info.bundle = in_bundle;
        lc_info.name = in_name;
        int i = 0;
        while (i < menus.length) {
            MenuComponent item = menus[i];
            String link = item.getLocation();
            String key = item.getTitle();
            String image = item.getImage();
            String target = item.getTarget();
            String onclick = item.getOnClick();
            String style = item.getStyle();
            lc_info.hasSubMenus = item.hasMenuComponents();
            lc_info.isLast = i + 1 == menus.length;
            String lc_id = item.getId();
            if (lc_id == null) {
                lc_id = String.valueOf(i);
            }
            lc_info.path = in_path.length() == 0 ? lc_id : String.valueOf(in_path) + "*" + lc_id;
            lc_info.isClosed = TreeViewTag.isNodeClosed(in_request, lc_info.path);
            int lc_numberOfMenusToLoad = LayoutUtils.getSkin(in_request.getSession()).getNumberOfMenusLoaded();
            lc_info.useIndirection = in_allowIndirection && lc_numberOfMenusPrinted >= lc_numberOfMenusToLoad && in_name != null && lc_info.isClosed;
            lc_treeviewRenderer.startRow(buffer);
            lc_treeviewRenderer.renderTree(buffer, in_request, lc_info);
            if (lc_info.hasSubMenus) {
                lc_treeviewRenderer.startSubMenu(buffer);
            }
            lc_treeviewRenderer.renderIcon(buffer, lc_info, item);
            lc_treeviewRenderer.startLabel(buffer, in_styleClass, onclick, style);
            lc_treeviewRenderer.renderImage(buffer, in_request, lc_info, item);
            lc_treeviewRenderer.renderLabel(buffer, in_request, in_servletcontext, lc_info, item);
            lc_treeviewRenderer.endLabel(buffer);
            lc_treeviewRenderer.renderActions(buffer, in_request, in_servletcontext, lc_info, item);
            if (lc_info.hasSubMenus) {
                lc_numberOfMenusPrinted = lc_treeviewRenderer.endSubMenu(buffer, in_request, in_servletcontext, lc_numberOfMenusPrinted, item, lc_info);
            }
            lc_treeviewRenderer.endRow(buffer);
            ++i;
        }
        return lc_numberOfMenusPrinted;
    }

    public static boolean isNodeClosed(HttpServletRequest in_request, String in_path) {
        Cookie[] lc_cookies = in_request.getCookies();
        if (lc_cookies == null) {
            return true;
        }
        int i = 0;
        while (i < lc_cookies.length) {
            Cookie lc_cookie = lc_cookies[i];
            if (lc_cookie.getName().equals("treeView")) {
                return lc_cookie.getValue().indexOf("_treeView" + in_path + "_") == -1;
            }
            ++i;
        }
        return true;
    }

    public int doStartLayoutTag() throws JspException {
        return 1;
    }

    public void setAutoIncrement(String in_value) {
        this.autoIncrement = "true".equalsIgnoreCase(in_value);
    }

    public void release() {
        super.release();
        this.autoIncrement = true;
        this.expandedLevelsAtFirst = -1;
    }

    public final void setExpandedLevelsAtFirst(int expandedLevelsAtFirst) {
        this.expandedLevelsAtFirst = expandedLevelsAtFirst;
    }

    private String buildIFrameSource(HttpServletRequest in_request) {
        String action = LayoutUtils.getSkin(in_request.getSession()).getProperty("treeview.action", DEFAULT_TREEVIEW_ACTION);
        return String.valueOf(in_request.getContextPath()) + "/" + action + "?iframe=iframe";
    }

    public class TreeViewIds
    implements Serializable {
        private int counter = -1;
        Hashtable namedTreeview = new Hashtable();
        Hashtable anonymousTreeview = new Hashtable();

        TreeViewIds() {
        }

        public synchronized int getNewId() {
            ++this.counter;
            return this.counter;
        }
    }
}

