/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.datastore;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.exception.IllegalStateOfArgumentException;
import net.sf.uadetector.datareader.DataReader;
import net.sf.uadetector.datareader.XmlDataReader;
import net.sf.uadetector.datastore.AbstractDataStore;
import net.sf.uadetector.datastore.AbstractRefreshableDataStore;
import net.sf.uadetector.datastore.DataStore;
import net.sf.uadetector.datastore.UpdateOperationWithCacheFileTask;
import net.sf.uadetector.internal.data.Data;
import net.sf.uadetector.internal.util.FileUtil;
import net.sf.uadetector.internal.util.UrlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CachingXmlDataStore
extends AbstractRefreshableDataStore {
    private static final String CACHE_DIR = System.getProperty("java.io.tmpdir");
    private static final Logger LOG = LoggerFactory.getLogger(CachingXmlDataStore.class);
    private static final String MSG_CACHE_FILE_IS_EMPTY = "The cache file is empty. The given UAS data source will be imported.";
    private static final String MSG_CACHE_FILE_IS_FILLED = "The cache file is filled and will be imported.";
    private static final String MSG_CACHE_FILE_IS_DAMAGED = "The cache file '%s' is damaged and must be removed manually.";
    private static final String MSG_CACHE_FILE_IS_DAMAGED_AND_DELETED = "The cache file '%s' is damaged and has been deleted.";
    private static final String PREFIX = "uas";
    private static final String SUFFIX = ".xml";

    @Nonnull
    public static CachingXmlDataStore createCachingXmlDataStore(@Nonnull DataStore fallback) {
        return CachingXmlDataStore.createCachingXmlDataStore(CachingXmlDataStore.findOrCreateCacheFile(), fallback);
    }

    @Nonnull
    public static CachingXmlDataStore createCachingXmlDataStore(@Nonnull File cacheFile, @Nonnull DataStore fallback) {
        return CachingXmlDataStore.createCachingXmlDataStore(cacheFile, UrlUtil.build("http://user-agent-string.info/rpc/get_data.php?key=free&format=xml"), UrlUtil.build("http://user-agent-string.info/rpc/get_data.php?key=free&format=ini&ver=y"), DEFAULT_CHARSET, fallback);
    }

    @Nonnull
    public static CachingXmlDataStore createCachingXmlDataStore(@Nonnull File cacheFile, @Nonnull URL dataUrl, @Nonnull URL versionUrl, @Nonnull Charset charset, @Nonnull DataStore fallback) {
        Check.notNull((Object)cacheFile, (String)"cacheFile");
        Check.notNull((Object)charset, (String)"charset");
        Check.notNull((Object)dataUrl, (String)"dataUrl");
        Check.notNull((Object)fallback, (String)"fallback");
        Check.notNull((Object)versionUrl, (String)"versionUrl");
        XmlDataReader reader = new XmlDataReader();
        DataStore fallbackDataStore = CachingXmlDataStore.readCacheFileAsFallback(reader, cacheFile, dataUrl, versionUrl, charset, fallback);
        return new CachingXmlDataStore(reader, dataUrl, versionUrl, charset, cacheFile, fallbackDataStore);
    }

    @Nonnull
    public static CachingXmlDataStore createCachingXmlDataStore(@Nonnull URL dataUrl, @Nonnull URL versionUrl, @Nonnull Charset charset, @Nonnull DataStore fallback) {
        return CachingXmlDataStore.createCachingXmlDataStore(CachingXmlDataStore.findOrCreateCacheFile(), dataUrl, versionUrl, charset, fallback);
    }

    private static void deleteCacheFile(File cacheFile) {
        try {
            if (cacheFile.delete()) {
                LOG.warn(String.format(MSG_CACHE_FILE_IS_DAMAGED_AND_DELETED, cacheFile.getPath()));
            } else {
                LOG.warn(String.format(MSG_CACHE_FILE_IS_DAMAGED, cacheFile.getPath()));
            }
        }
        catch (Exception e) {
            LOG.warn(String.format(MSG_CACHE_FILE_IS_DAMAGED, cacheFile.getPath()));
        }
    }

    @Nonnull
    public static File findOrCreateCacheFile() {
        File file = new File(CACHE_DIR, "uas.xml");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new IllegalStateOfArgumentException("Can not create a cache file.", (Throwable)e);
            }
        }
        return file;
    }

    private static boolean isEmpty(@Nonnull File file, @Nonnull Charset charset) {
        try {
            return FileUtil.isEmpty(file, charset);
        }
        catch (IOException e) {
            throw new IllegalStateOfArgumentException("The given file could not be read.", (Throwable)e);
        }
    }

    private static DataStore readCacheFileAsFallback(@Nonnull DataReader reader, @Nonnull File cacheFile, @Nonnull URL dataUrl, @Nonnull URL versionUrl, @Nonnull Charset charset, @Nonnull DataStore fallback) {
        DataStore fallbackDataStore;
        if (!CachingXmlDataStore.isEmpty(cacheFile, charset)) {
            URL cacheFileUrl = UrlUtil.toUrl(cacheFile);
            try {
                fallbackDataStore = new CacheFileDataStore(reader.read(cacheFileUrl, charset), reader, cacheFileUrl, versionUrl, charset);
                LOG.debug(MSG_CACHE_FILE_IS_FILLED);
            }
            catch (RuntimeException e) {
                fallbackDataStore = fallback;
                CachingXmlDataStore.deleteCacheFile(cacheFile);
            }
        } else {
            fallbackDataStore = fallback;
            LOG.debug(MSG_CACHE_FILE_IS_EMPTY);
        }
        return fallbackDataStore;
    }

    private CachingXmlDataStore(@Nonnull DataReader reader, @Nonnull URL dataUrl, @Nonnull URL versionUrl, @Nonnull Charset charset, @Nonnull File cacheFile, @Nonnull DataStore fallback) {
        super(reader, dataUrl, versionUrl, charset, fallback);
        this.setUpdateOperation(new UpdateOperationWithCacheFileTask(this, cacheFile));
    }

    private static class CacheFileDataStore
    extends AbstractDataStore {
        protected CacheFileDataStore(Data data, DataReader reader, URL dataUrl, URL versionUrl, Charset charset) {
            super(data, reader, dataUrl, versionUrl, charset);
        }
    }
}

