/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.internal.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.exception.IllegalStateOfArgumentException;
import net.sf.uadetector.internal.data.Data;
import net.sf.uadetector.internal.data.OrderedPatternComparator;
import net.sf.uadetector.internal.data.domain.Browser;
import net.sf.uadetector.internal.data.domain.BrowserOperatingSystemMapping;
import net.sf.uadetector.internal.data.domain.BrowserPattern;
import net.sf.uadetector.internal.data.domain.BrowserType;
import net.sf.uadetector.internal.data.domain.OperatingSystem;
import net.sf.uadetector.internal.data.domain.OperatingSystemPattern;
import net.sf.uadetector.internal.data.domain.Robot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class DataBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DataBuilder.class);
    @Nonnull
    private final Map<Integer, BrowserType> browserTypes = new HashMap<Integer, BrowserType>();
    @Nonnull
    private final Map<Integer, SortedSet<BrowserPattern>> browserPatterns = new HashMap<Integer, SortedSet<BrowserPattern>>();
    @Nonnull
    private final Map<Integer, SortedSet<OperatingSystemPattern>> operatingSystemPatterns = new HashMap<Integer, SortedSet<OperatingSystemPattern>>();
    @Nonnull
    private final Map<Integer, Browser.Builder> browserBuilders = new HashMap<Integer, Browser.Builder>();
    @Nonnull
    private final Set<Browser> browsers = new HashSet<Browser>();
    @Nonnull
    private final Map<Integer, OperatingSystem.Builder> operatingSystemBuilders = new HashMap<Integer, OperatingSystem.Builder>();
    @Nonnull
    private final Set<OperatingSystem> operatingSystems = new HashSet<OperatingSystem>();
    @Nonnull
    private final List<Robot> robots = new ArrayList<Robot>();
    private String version;
    @Nonnull
    private final Set<BrowserOperatingSystemMapping> browserToOperatingSystemMap = new HashSet<BrowserOperatingSystemMapping>();
    private static final OrderedPatternComparator<BrowserPattern> BROWSER_PATTERN_COMPARATOR = new OrderedPatternComparator();
    private static final OrderedPatternComparator<OperatingSystemPattern> OS_PATTERN_COMPARATOR = new OrderedPatternComparator();

    private static void addOperatingSystemToBrowser(Map<Integer, Browser.Builder> browserBuilders, Map<Integer, OperatingSystem> operatingSystems, Map<Integer, Integer> browserOsMap) {
        for (Map.Entry<Integer, Integer> entry : browserOsMap.entrySet()) {
            if (browserBuilders.containsKey(entry.getKey())) {
                Browser.Builder browserBuilder = browserBuilders.get(entry.getKey());
                if (operatingSystems.containsKey(entry.getValue())) {
                    browserBuilder.setOperatingSystem(operatingSystems.get(entry.getValue()));
                    continue;
                }
                LOG.warn("Can not find an operating system with ID '" + entry.getValue() + "' for browser '" + browserBuilder.getProducer() + " " + (Object)((Object)browserBuilder.getFamily()) + "'.");
                continue;
            }
            LOG.warn("Can not find a browser with ID '" + entry.getKey() + "'.");
        }
    }

    private static void addPatternToBrowser(Map<Integer, Browser.Builder> builders, Map<Integer, SortedSet<BrowserPattern>> patterns) {
        for (Map.Entry<Integer, Browser.Builder> entry : builders.entrySet()) {
            if (patterns.containsKey(entry.getKey())) {
                entry.getValue().setPatterns(patterns.get(entry.getKey()));
                continue;
            }
            LOG.warn("No pattern available for '" + entry.getValue().getProducer() + " " + (Object)((Object)entry.getValue().getFamily()) + "'.");
        }
    }

    private static void addPatternToOperatingSystem(Map<Integer, OperatingSystem.Builder> builders, Map<Integer, SortedSet<OperatingSystemPattern>> patterns) {
        for (Map.Entry<Integer, OperatingSystem.Builder> entry : builders.entrySet()) {
            SortedSet<OperatingSystemPattern> patternSet = patterns.get(entry.getKey());
            if (patternSet != null) {
                entry.getValue().addPatterns(patternSet);
                continue;
            }
            LOG.debug("No patterns for operating system entry (with id '" + entry.getKey() + "') available.");
        }
    }

    private static void addTypeToBrowser(Map<Integer, Browser.Builder> builders, Map<Integer, BrowserType> types) {
        for (Map.Entry<Integer, Browser.Builder> entry : builders.entrySet()) {
            int typeId = entry.getValue().getTypeId();
            if (typeId < 0) continue;
            if (types.containsKey(typeId)) {
                entry.getValue().setType(types.get(typeId));
                continue;
            }
            LOG.warn("No type available for '" + entry.getValue().getProducer() + " " + (Object)((Object)entry.getValue().getFamily()) + "'.");
        }
    }

    private static Set<Browser> buildBrowsers(Map<Integer, Browser.Builder> browserBuilders) {
        HashSet<Browser> browsers = new HashSet<Browser>();
        for (Map.Entry<Integer, Browser.Builder> entry : browserBuilders.entrySet()) {
            try {
                browsers.add(entry.getValue().build());
            }
            catch (Exception e) {
                LOG.warn("Can not build browser: " + e.getLocalizedMessage());
            }
        }
        return browsers;
    }

    private static Map<Integer, OperatingSystem> buildOperatingSystems(Map<Integer, OperatingSystem.Builder> osBuilders) {
        HashMap<Integer, OperatingSystem> operatingSystems = new HashMap<Integer, OperatingSystem>();
        for (Map.Entry<Integer, OperatingSystem.Builder> entry : osBuilders.entrySet()) {
            try {
                operatingSystems.put(entry.getKey(), entry.getValue().build());
            }
            catch (Exception e) {
                LOG.warn("Can not build operating system: " + e.getLocalizedMessage());
            }
        }
        return operatingSystems;
    }

    private static SortedMap<BrowserPattern, Browser> buildPatternToBrowserMap(Set<Browser> browserSet) {
        TreeMap<BrowserPattern, Browser> patternBrowser = new TreeMap<BrowserPattern, Browser>(BROWSER_PATTERN_COMPARATOR);
        for (Browser browser : browserSet) {
            for (BrowserPattern pattern : browser.getPatterns()) {
                patternBrowser.put(pattern, browser);
            }
        }
        return patternBrowser;
    }

    private static SortedMap<OperatingSystemPattern, OperatingSystem> buildPatternToOperatingSystemMap(Set<OperatingSystem> osSet) {
        TreeMap<OperatingSystemPattern, OperatingSystem> map = new TreeMap<OperatingSystemPattern, OperatingSystem>(OS_PATTERN_COMPARATOR);
        for (OperatingSystem os : osSet) {
            for (OperatingSystemPattern pattern : os.getPatterns()) {
                map.put(pattern, os);
            }
        }
        return map;
    }

    private static Map<Integer, Integer> convertBrowserOsMapping(Set<BrowserOperatingSystemMapping> browserOperatingSystemMappings) {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        for (BrowserOperatingSystemMapping mapping : browserOperatingSystemMappings) {
            result.put(mapping.getBrowserId(), mapping.getOperatingSystemId());
        }
        return result;
    }

    private static Set<OperatingSystem> convertOperatingSystems(Map<Integer, OperatingSystem> operatingSystems) {
        HashSet<OperatingSystem> result = new HashSet<OperatingSystem>();
        for (Map.Entry<Integer, OperatingSystem> entry : operatingSystems.entrySet()) {
            result.add(entry.getValue());
        }
        return result;
    }

    public DataBuilder appendBrowser(@Nonnull Browser browser) {
        Check.notNull((Object)browser, (String)"browser");
        this.browsers.add(browser);
        return this;
    }

    @Nonnull
    public DataBuilder appendBrowserBuilder(@Nonnull Browser.Builder browserBuilder) {
        Check.notNull((Object)browserBuilder, (String)"browserBuilder");
        Check.notNegative((int)browserBuilder.getId(), (String)"browserBuilder.getId()");
        if (browserBuilder.getType() == null && browserBuilder.getTypeId() < 0) {
            throw new IllegalStateOfArgumentException("A Type or Type-ID of argument 'browserBuilder' must be set.");
        }
        if (this.browserBuilders.containsKey(browserBuilder.getId())) {
            throw new IllegalStateOfArgumentException("The browser builder '" + browserBuilder.getProducer() + " " + (Object)((Object)browserBuilder.getFamily()) + "' is already in the map.");
        }
        Browser.Builder builder = browserBuilder.copy();
        this.browserBuilders.put(builder.getId(), builder);
        return this;
    }

    @Nonnull
    public DataBuilder appendBrowserOperatingSystemMapping(@Nonnull BrowserOperatingSystemMapping browserOsMapping) {
        Check.notNull((Object)browserOsMapping, (String)"browserOsMapping");
        this.browserToOperatingSystemMap.add(browserOsMapping);
        return this;
    }

    @Nonnull
    public DataBuilder appendBrowserPattern(@Nonnull BrowserPattern pattern) {
        Check.notNull((Object)pattern, (String)"pattern");
        if (!this.browserPatterns.containsKey(pattern.getId())) {
            this.browserPatterns.put(pattern.getId(), new TreeSet<BrowserPattern>(BROWSER_PATTERN_COMPARATOR));
        }
        this.browserPatterns.get(pattern.getId()).add(pattern);
        return this;
    }

    @Nonnull
    public DataBuilder appendBrowserType(@Nonnull BrowserType type) {
        Check.notNull((Object)type, (String)"type");
        this.browserTypes.put(type.getId(), type);
        return this;
    }

    @Nonnull
    public DataBuilder appendOperatingSystem(@Nonnull OperatingSystem operatingSystem) {
        Check.notNull((Object)operatingSystem, (String)"operatingSystem");
        this.operatingSystems.add(operatingSystem);
        return this;
    }

    @Nonnull
    public DataBuilder appendOperatingSystemBuilder(@Nonnull OperatingSystem.Builder operatingSystemBuilder) {
        Check.notNull((Object)operatingSystemBuilder, (String)"operatingSystemBuilder");
        Check.notNegative((int)operatingSystemBuilder.getId(), (String)"operatingSystemBuilder.getId()");
        Check.stateIsTrue((!this.operatingSystemBuilders.containsKey(operatingSystemBuilder.getId()) ? 1 : 0) != 0, (String)"Operating system builder with ID '%s' already exists.", (Object[])new Object[]{operatingSystemBuilder.getId()});
        OperatingSystem.Builder builder = operatingSystemBuilder.copy();
        this.operatingSystemBuilders.put(builder.getId(), builder);
        return this;
    }

    @Nonnull
    public DataBuilder appendOperatingSystemPattern(@Nonnull OperatingSystemPattern pattern) {
        Check.notNull((Object)pattern, (String)"pattern");
        if (!this.operatingSystemPatterns.containsKey(pattern.getId())) {
            this.operatingSystemPatterns.put(pattern.getId(), new TreeSet<OperatingSystemPattern>(OS_PATTERN_COMPARATOR));
        }
        this.operatingSystemPatterns.get(pattern.getId()).add(pattern);
        return this;
    }

    @Nonnull
    public DataBuilder appendRobot(@Nonnull Robot robot) {
        Check.notNull((Object)robot, (String)"robot");
        this.robots.add(robot);
        return this;
    }

    @Nonnull
    public Data build() {
        DataBuilder.addTypeToBrowser(this.browserBuilders, this.browserTypes);
        DataBuilder.addPatternToBrowser(this.browserBuilders, this.browserPatterns);
        DataBuilder.addPatternToOperatingSystem(this.operatingSystemBuilders, this.operatingSystemPatterns);
        Map<Integer, OperatingSystem> systems = DataBuilder.buildOperatingSystems(this.operatingSystemBuilders);
        DataBuilder.addOperatingSystemToBrowser(this.browserBuilders, systems, DataBuilder.convertBrowserOsMapping(this.browserToOperatingSystemMap));
        Set<OperatingSystem> osSet = DataBuilder.convertOperatingSystems(systems);
        osSet.addAll(this.operatingSystems);
        Set<Browser> browserSet = DataBuilder.buildBrowsers(this.browserBuilders);
        browserSet.addAll(this.browsers);
        SortedMap<BrowserPattern, Browser> patternToBrowserMap = DataBuilder.buildPatternToBrowserMap(browserSet);
        SortedMap<OperatingSystemPattern, OperatingSystem> patternToOperatingSystemMap = DataBuilder.buildPatternToOperatingSystemMap(osSet);
        return new Data(browserSet, this.browserPatterns, this.browserTypes, patternToBrowserMap, this.browserToOperatingSystemMap, osSet, this.operatingSystemPatterns, patternToOperatingSystemMap, this.robots, this.version);
    }

    @Nonnull
    public DataBuilder setVersion(@Nonnull String version) {
        Check.notNull((Object)version, (String)"version");
        this.version = version;
        return this;
    }
}

