/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.internal.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import net.sf.qualitycheck.Check;
import net.sf.uadetector.internal.util.CompareNullSafe;

public final class RegularExpressionConverter {
    private static final String PATTERN_TO_REGEX_TEMPLATE = "/%s/%s";
    private static final Pattern PERL_STYLE = Pattern.compile("^/.*/((i|m|s|x)*)?$");
    private static final Pattern PERL_STYLE_TOLERANT = Pattern.compile("^/.*/(([A-z])*)?$");

    public static String convertPatternToPerlRegex(@Nonnull Pattern pattern) {
        Check.notNull((Object)pattern, (String)"pattern");
        String modifiers = Flag.convertToModifiers(Flag.parse(pattern.flags()));
        return String.format(PATTERN_TO_REGEX_TEMPLATE, pattern.pattern(), modifiers);
    }

    public static Pattern convertPerlRegexToPattern(@Nonnull String regex) {
        return RegularExpressionConverter.convertPerlRegexToPattern(regex, false);
    }

    public static Pattern convertPerlRegexToPattern(@Nonnull String regex, @Nonnull boolean faultTolerant) {
        Matcher matcher;
        Check.notNull((Object)regex, (String)"regex");
        String pattern = regex.trim();
        Matcher matcher2 = matcher = faultTolerant ? PERL_STYLE_TOLERANT.matcher(pattern) : PERL_STYLE.matcher(pattern);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("The given regular expression '" + pattern + "' seems to be not in PERL style or has unsupported modifiers.");
        }
        pattern = pattern.substring(1);
        int lastIndex = pattern.lastIndexOf(47);
        pattern = pattern.substring(0, lastIndex);
        int flags = Flag.convertToBitmask(Flag.parse(matcher.group(1)));
        return Pattern.compile(pattern, flags);
    }

    private RegularExpressionConverter() {
    }

    public static enum Flag {
        CANON_EQ(128, 'c'),
        CASE_INSENSITIVE(2, 'i'),
        COMMENTS(4, 'x'),
        DOTALL(32, 's'),
        LITERAL(16, 'l'),
        MULTILINE(8, 'm'),
        UNICODE_CASE(64, 'u'),
        UNIX_LINES(1, 'e');

        private static final FlagByCharacterComparator FLAG_COMPARATOR;
        private final char character;
        private final int number;

        public static int convertToBitmask(@Nonnull Collection<Flag> flags) {
            Check.notNull(flags, (String)"flags");
            int bitmask = 0;
            for (Flag flag : flags) {
                bitmask |= flag.getNumber();
            }
            return bitmask;
        }

        public static String convertToModifiers(@Nonnull Collection<Flag> flags) {
            Check.notNull(flags, (String)"flags");
            StringBuilder modifiers = new StringBuilder(8);
            TreeSet<Flag> sortedFlags = new TreeSet<Flag>(Collections.reverseOrder(FLAG_COMPARATOR));
            sortedFlags.addAll(flags);
            for (Flag flag : sortedFlags) {
                modifiers.append(flag.getCharacter());
            }
            return modifiers.toString();
        }

        public static Flag evaluateByCharacter(char flag) {
            Check.notNegative((int)flag, (String)"flag");
            Flag result = null;
            for (Flag value : Flag.values()) {
                if (value.getCharacter() != flag) continue;
                result = value;
                break;
            }
            return result;
        }

        public static Flag evaluateByNumber(int flag) {
            Check.notNegative((int)flag, (String)"flag");
            Flag result = null;
            for (Flag value : Flag.values()) {
                if (value.getNumber() != flag) continue;
                result = value;
                break;
            }
            return result;
        }

        @Nonnull
        public static Set<Flag> parse(@Nonnegative int bitmask) {
            Check.notNegative((int)bitmask, (String)"bitmask");
            HashSet<Flag> flags = new HashSet<Flag>();
            for (Flag flag : Flag.values()) {
                if ((bitmask & flag.getNumber()) == 0) continue;
                flags.add(flag);
            }
            return flags;
        }

        public static Set<Flag> parse(@Nonnull String modifiers) {
            Check.notNull((Object)modifiers, (String)"modifiers");
            HashSet<Flag> flags = new HashSet<Flag>();
            for (int i = 0; i < modifiers.length(); ++i) {
                Flag flag = Flag.evaluateByCharacter(modifiers.charAt(i));
                if (flag == null) continue;
                flags.add(flag);
            }
            return flags;
        }

        private Flag(int value, char character) {
            this.number = value;
            this.character = character;
        }

        public char getCharacter() {
            return this.character;
        }

        public int getNumber() {
            return this.number;
        }

        static {
            FLAG_COMPARATOR = new FlagByCharacterComparator();
        }

        private static class FlagByCharacterComparator
        extends CompareNullSafe<Flag> {
            private static final long serialVersionUID = 1L;

            private FlagByCharacterComparator() {
            }

            @Override
            public int compareType(@Nonnull Flag f1, @Nonnull Flag f2) {
                Character c1 = Character.valueOf(f1.getCharacter());
                Character c2 = Character.valueOf(f2.getCharacter());
                return c1.compareTo(c2);
            }
        }
    }
}

