/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.spi;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.hibernate.hql.internal.ast.tree.DeleteStatement;
import org.hibernate.hql.internal.ast.tree.FromElement;
import org.hibernate.hql.spi.AbstractTableBasedBulkIdHandler;
import org.hibernate.hql.spi.MultiTableBulkIdStrategy;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.Delete;
import org.jboss.logging.Logger;

public class TableBasedDeleteHandlerImpl
extends AbstractTableBasedBulkIdHandler
implements MultiTableBulkIdStrategy.DeleteHandler {
    private static final Logger log = Logger.getLogger(TableBasedDeleteHandlerImpl.class);
    private final Queryable targetedPersister;
    private final String idInsertSelect;
    private final List<ParameterSpecification> idSelectParameterSpecifications;
    private final String[] deletes;

    public TableBasedDeleteHandlerImpl(SessionFactoryImplementor factory, HqlSqlWalker walker) {
        this(factory, walker, null, null);
    }

    public TableBasedDeleteHandlerImpl(SessionFactoryImplementor factory, HqlSqlWalker walker, String catalog, String schema) {
        super(factory, walker, catalog, schema);
        DeleteStatement deleteStatement = (DeleteStatement)walker.getAST();
        FromElement fromElement = deleteStatement.getFromClause().getFromElement();
        this.targetedPersister = fromElement.getQueryable();
        String bulkTargetAlias = fromElement.getTableAlias();
        AbstractTableBasedBulkIdHandler.ProcessedWhereClause processedWhereClause = this.processWhereClause(deleteStatement.getWhereClause());
        this.idSelectParameterSpecifications = processedWhereClause.getIdSelectParameterSpecifications();
        this.idInsertSelect = this.generateIdInsertSelect(this.targetedPersister, bulkTargetAlias, processedWhereClause);
        log.tracev("Generated ID-INSERT-SELECT SQL (multi-table delete) : {0}", (Object)this.idInsertSelect);
        String[] tableNames = this.targetedPersister.getConstraintOrderedTableNameClosure();
        String[][] columnNames = this.targetedPersister.getContraintOrderedTableKeyColumnClosure();
        String idSubselect = this.generateIdSubselect(this.targetedPersister);
        this.deletes = new String[tableNames.length];
        for (int i = tableNames.length - 1; i >= 0; --i) {
            Delete delete = new Delete().setTableName(tableNames[i]).setWhere("(" + StringHelper.join(", ", columnNames[i]) + ") IN (" + idSubselect + ")");
            if (this.factory().getSettings().isCommentsEnabled()) {
                delete.setComment("bulk delete");
            }
            this.deletes[i] = delete.toStatementString();
        }
    }

    @Override
    public Queryable getTargetedQueryable() {
        return this.targetedPersister;
    }

    @Override
    public String[] getSqlStatements() {
        return this.deletes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(SessionImplementor session, QueryParameters queryParameters) {
        this.prepareForUse(this.targetedPersister, session);
        try {
            Statement ps = null;
            int resultCount = 0;
            try {
                try {
                    ps = session.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(this.idInsertSelect, false);
                    int pos = 1;
                    pos += this.handlePrependedParametersOnIdSelection((PreparedStatement)ps, session, pos);
                    for (ParameterSpecification parameterSpecification : this.idSelectParameterSpecifications) {
                        pos += parameterSpecification.bind((PreparedStatement)ps, queryParameters, session, pos);
                    }
                    resultCount = ps.executeUpdate();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException e) {
                throw this.convert(e, "could not insert/select ids for bulk delete", this.idInsertSelect);
            }
            for (String delete : this.deletes) {
                try {
                    try {
                        ps = session.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(delete, false);
                        this.handleAddedParametersOnDelete((PreparedStatement)ps, session);
                        ps.executeUpdate();
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                }
                catch (SQLException e) {
                    throw this.convert(e, "error performing bulk delete", delete);
                }
            }
            int n = resultCount;
            return n;
        }
        finally {
            this.releaseFromUse(this.targetedPersister, session);
        }
    }

    protected int handlePrependedParametersOnIdSelection(PreparedStatement ps, SessionImplementor session, int pos) throws SQLException {
        return 0;
    }

    protected void handleAddedParametersOnDelete(PreparedStatement ps, SessionImplementor session) throws SQLException {
    }
}

