/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.ScrollableResults;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.hql.internal.HolderInstantiator;
import org.hibernate.internal.AbstractScrollableResults;
import org.hibernate.loader.Loader;
import org.hibernate.type.Type;

public class ScrollableResultsImpl
extends AbstractScrollableResults
implements ScrollableResults {
    private Object[] currentRow;

    public ScrollableResultsImpl(ResultSet rs, PreparedStatement ps, SessionImplementor sess, Loader loader, QueryParameters queryParameters, Type[] types, HolderInstantiator holderInstantiator) throws MappingException {
        super(rs, ps, sess, loader, queryParameters, types, holderInstantiator);
    }

    @Override
    protected Object[] getCurrentRow() {
        return this.currentRow;
    }

    @Override
    public boolean scroll(int i) throws HibernateException {
        try {
            boolean result = this.getResultSet().relative(i);
            this.prepareCurrentRow(result);
            return result;
        }
        catch (SQLException sqle) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(sqle, "could not advance using scroll()");
        }
    }

    @Override
    public boolean first() throws HibernateException {
        try {
            boolean result = this.getResultSet().first();
            this.prepareCurrentRow(result);
            return result;
        }
        catch (SQLException sqle) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(sqle, "could not advance using first()");
        }
    }

    @Override
    public boolean last() throws HibernateException {
        try {
            boolean result = this.getResultSet().last();
            this.prepareCurrentRow(result);
            return result;
        }
        catch (SQLException sqle) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(sqle, "could not advance using last()");
        }
    }

    @Override
    public boolean next() throws HibernateException {
        try {
            boolean result = this.getResultSet().next();
            this.prepareCurrentRow(result);
            return result;
        }
        catch (SQLException sqle) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(sqle, "could not advance using next()");
        }
    }

    @Override
    public boolean previous() throws HibernateException {
        try {
            boolean result = this.getResultSet().previous();
            this.prepareCurrentRow(result);
            return result;
        }
        catch (SQLException sqle) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(sqle, "could not advance using previous()");
        }
    }

    @Override
    public void afterLast() throws HibernateException {
        try {
            this.getResultSet().afterLast();
        }
        catch (SQLException sqle) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(sqle, "exception calling afterLast()");
        }
    }

    @Override
    public void beforeFirst() throws HibernateException {
        try {
            this.getResultSet().beforeFirst();
        }
        catch (SQLException sqle) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(sqle, "exception calling beforeFirst()");
        }
    }

    @Override
    public boolean isFirst() throws HibernateException {
        try {
            return this.getResultSet().isFirst();
        }
        catch (SQLException sqle) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(sqle, "exception calling isFirst()");
        }
    }

    @Override
    public boolean isLast() throws HibernateException {
        try {
            return this.getResultSet().isLast();
        }
        catch (SQLException sqle) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(sqle, "exception calling isLast()");
        }
    }

    @Override
    public int getRowNumber() throws HibernateException {
        try {
            return this.getResultSet().getRow() - 1;
        }
        catch (SQLException sqle) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(sqle, "exception calling getRow()");
        }
    }

    @Override
    public boolean setRowNumber(int rowNumber) throws HibernateException {
        if (rowNumber >= 0) {
            ++rowNumber;
        }
        try {
            boolean result = this.getResultSet().absolute(rowNumber);
            this.prepareCurrentRow(result);
            return result;
        }
        catch (SQLException sqle) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(sqle, "could not advance using absolute()");
        }
    }

    private void prepareCurrentRow(boolean underlyingScrollSuccessful) throws HibernateException {
        if (!underlyingScrollSuccessful) {
            this.currentRow = null;
            return;
        }
        Object result = this.getLoader().loadSingleRow(this.getResultSet(), this.getSession(), this.getQueryParameters(), false);
        this.currentRow = result != null && result.getClass().isArray() ? (Object[])result : new Object[]{result};
        if (this.getHolderInstantiator() != null) {
            this.currentRow = new Object[]{this.getHolderInstantiator().instantiate(this.currentRow)};
        }
        this.afterScrollOperation();
    }
}

