/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import org.hibernate.MappingException;
import org.hibernate.cfg.Mappings;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.type.CollectionType;

public class Map
extends IndexedCollection {
    public Map(Mappings mappings, PersistentClass owner) {
        super(mappings, owner);
    }

    @Override
    public boolean isMap() {
        return true;
    }

    @Override
    public CollectionType getDefaultCollectionType() {
        if (this.isSorted()) {
            return this.getMappings().getTypeResolver().getTypeFactory().sortedMap(this.getRole(), this.getReferencedPropertyName(), this.isEmbedded(), this.getComparator());
        }
        if (this.hasOrder()) {
            return this.getMappings().getTypeResolver().getTypeFactory().orderedMap(this.getRole(), this.getReferencedPropertyName(), this.isEmbedded());
        }
        return this.getMappings().getTypeResolver().getTypeFactory().map(this.getRole(), this.getReferencedPropertyName(), this.isEmbedded());
    }

    @Override
    public void createAllKeys() throws MappingException {
        super.createAllKeys();
        if (!this.isInverse()) {
            this.getIndex().createForeignKey();
        }
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }
}

