/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.cfg.Environment;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.ServiceRegistryBuilder;
import org.hibernate.service.internal.StandardServiceRegistryImpl;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.tool.hbm2ddl.ConnectionHelper;

class ManagedProviderConnectionHelper
implements ConnectionHelper {
    private Properties cfgProperties;
    private StandardServiceRegistryImpl serviceRegistry;
    private Connection connection;

    public ManagedProviderConnectionHelper(Properties cfgProperties) {
        this.cfgProperties = cfgProperties;
    }

    @Override
    public void prepare(boolean needsAutoCommit) throws SQLException {
        this.serviceRegistry = ManagedProviderConnectionHelper.createServiceRegistry(this.cfgProperties);
        this.connection = this.serviceRegistry.getService(ConnectionProvider.class).getConnection();
        if (needsAutoCommit && !this.connection.getAutoCommit()) {
            this.connection.commit();
            this.connection.setAutoCommit(true);
        }
    }

    private static StandardServiceRegistryImpl createServiceRegistry(Properties properties) {
        Environment.verifyProperties(properties);
        ConfigurationHelper.resolvePlaceHolders(properties);
        return (StandardServiceRegistryImpl)new ServiceRegistryBuilder().applySettings(properties).buildServiceRegistry();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() throws SQLException {
        try {
            this.releaseConnection();
        }
        finally {
            this.releaseServiceRegistry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseConnection() throws SQLException {
        if (this.connection != null) {
            try {
                new SqlExceptionHelper().logAndClearWarnings(this.connection);
            }
            finally {
                try {
                    this.serviceRegistry.getService(ConnectionProvider.class).closeConnection(this.connection);
                }
                finally {
                    this.connection = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseServiceRegistry() {
        if (this.serviceRegistry != null) {
            try {
                this.serviceRegistry.destroy();
            }
            finally {
                this.serviceRegistry = null;
            }
        }
    }
}

