/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JRSubreportReturnValue;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseElement;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public class JRBaseSubreport
extends JRBaseElement
implements JRSubreport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_USING_CACHE = "usingCache";
    public static final String PROPERTY_RUN_TO_BOTTOM = "runToBottom";
    protected Boolean isUsingCache;
    private Boolean runToBottom;
    protected JRExpression parametersMapExpression;
    protected JRSubreportParameter[] parameters;
    protected JRExpression connectionExpression;
    protected JRExpression dataSourceExpression;
    protected JRExpression expression;
    protected JRSubreportReturnValue[] returnValues;

    public ModeEnum getModeValue() {
        return JRStyleResolver.getMode(this, ModeEnum.TRANSPARENT);
    }

    protected JRBaseSubreport(JRSubreport subreport, JRBaseObjectFactory factory) {
        super(subreport, factory);
        this.isUsingCache = subreport.getUsingCache();
        this.runToBottom = subreport.isRunToBottom();
        this.parametersMapExpression = factory.getExpression(subreport.getParametersMapExpression());
        JRSubreportParameter[] jrSubreportParameters = subreport.getParameters();
        if (jrSubreportParameters != null && jrSubreportParameters.length > 0) {
            this.parameters = new JRSubreportParameter[jrSubreportParameters.length];
            for (int i = 0; i < this.parameters.length; ++i) {
                this.parameters[i] = factory.getSubreportParameter(jrSubreportParameters[i]);
            }
        }
        this.connectionExpression = factory.getExpression(subreport.getConnectionExpression());
        this.dataSourceExpression = factory.getExpression(subreport.getDataSourceExpression());
        JRSubreportReturnValue[] subrepReturnValues = subreport.getReturnValues();
        if (subrepReturnValues != null && subrepReturnValues.length > 0) {
            this.returnValues = new JRSubreportReturnValue[subrepReturnValues.length];
            for (int i = 0; i < subrepReturnValues.length; ++i) {
                this.returnValues[i] = factory.getSubreportReturnValue(subrepReturnValues[i]);
            }
        }
        this.expression = factory.getExpression(subreport.getExpression());
    }

    public boolean isUsingCache() {
        if (this.isUsingCache == null) {
            JRExpression subreportExpression = this.getExpression();
            if (subreportExpression != null) {
                return String.class.getName().equals(subreportExpression.getValueClassName());
            }
            return true;
        }
        return this.isUsingCache;
    }

    public JRExpression getParametersMapExpression() {
        return this.parametersMapExpression;
    }

    public JRSubreportParameter[] getParameters() {
        return this.parameters;
    }

    public JRExpression getConnectionExpression() {
        return this.connectionExpression;
    }

    public JRExpression getDataSourceExpression() {
        return this.dataSourceExpression;
    }

    public JRExpression getExpression() {
        return this.expression;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public void visit(JRVisitor visitor) {
        visitor.visitSubreport(this);
    }

    public JRSubreportReturnValue[] getReturnValues() {
        return this.returnValues;
    }

    public Boolean isOwnUsingCache() {
        return this.isUsingCache;
    }

    public Boolean getUsingCache() {
        return this.isUsingCache;
    }

    public void setUsingCache(Boolean isUsingCache) {
        Boolean old = this.isUsingCache;
        this.isUsingCache = isUsingCache;
        this.getEventSupport().firePropertyChange(PROPERTY_USING_CACHE, old, this.isUsingCache);
    }

    public Boolean isRunToBottom() {
        return this.runToBottom;
    }

    public void setRunToBottom(Boolean runToBottom) {
        Boolean old = this.runToBottom;
        this.runToBottom = runToBottom;
        this.getEventSupport().firePropertyChange(PROPERTY_RUN_TO_BOTTOM, old, this.runToBottom);
    }

    public Object clone() {
        JRBaseSubreport clone = (JRBaseSubreport)super.clone();
        clone.parameters = (JRSubreportParameter[])JRCloneUtils.cloneArray((JRCloneable[])this.parameters);
        clone.returnValues = (JRSubreportReturnValue[])JRCloneUtils.cloneArray((JRCloneable[])this.returnValues);
        clone.parametersMapExpression = JRCloneUtils.nullSafeClone(this.parametersMapExpression);
        clone.connectionExpression = JRCloneUtils.nullSafeClone(this.connectionExpression);
        clone.dataSourceExpression = JRCloneUtils.nullSafeClone(this.dataSourceExpression);
        clone.expression = JRCloneUtils.nullSafeClone(this.expression);
        return clone;
    }
}

