/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.util.Arrays;
import java.util.Collection;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JRValidationFault;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRValidationException
extends JRException {
    private static final long serialVersionUID = 10200L;
    private final Collection<JRValidationFault> faults;

    public JRValidationException(String message, Object source) {
        this(JRValidationException.createFault(message, source));
    }

    private static JRValidationFault createFault(String message, Object source) {
        JRValidationFault fault = new JRValidationFault();
        fault.setMessage(message);
        fault.setSource(source);
        return fault;
    }

    public JRValidationException(JRValidationFault fault) {
        this(Arrays.asList(fault));
    }

    public JRValidationException(Collection<JRValidationFault> faults) {
        this(null, faults);
    }

    public JRValidationException(String message, Collection<JRValidationFault> faults) {
        super(JRValidationException.appendMessages(message, faults));
        this.faults = faults;
    }

    public Collection<JRValidationFault> getFaults() {
        return this.faults;
    }

    protected static String appendMessages(String header, Collection<JRValidationFault> faults) {
        if (header == null) {
            header = "Report design not valid : ";
        }
        StringBuffer sbuffer = new StringBuffer();
        sbuffer.append(header);
        int i = 1;
        for (JRValidationFault fault : faults) {
            sbuffer.append("\n\t " + i + ". " + fault.getMessage());
            ++i;
        }
        return sbuffer.toString();
    }
}

