/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.fill.JRFillCellContents;
import net.sf.jasperreports.engine.fill.JRFillFrame;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRBoxUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.ObjectUtils;

public class JRTemplateFrame
extends JRTemplateElement
implements JRBoxContainer {
    private static final long serialVersionUID = 10200L;
    protected JRLineBox lineBox;
    private Byte border;
    private Byte topBorder;
    private Byte leftBorder;
    private Byte bottomBorder;
    private Byte rightBorder;
    private Color borderColor;
    private Color topBorderColor;
    private Color leftBorderColor;
    private Color bottomBorderColor;
    private Color rightBorderColor;
    private Integer padding;
    private Integer topPadding;
    private Integer leftPadding;
    private Integer bottomPadding;
    private Integer rightPadding;

    public JRTemplateFrame(JROrigin origin, JRDefaultStyleProvider defaultStyleProvider, JRFillCellContents cell) {
        super(origin, defaultStyleProvider);
        this.parentStyle = cell.getStyle();
        this.setBackcolor(cell.getBackcolor());
        this.setMode(cell.getModeValue());
        this.copyBox(cell.getLineBox());
    }

    public JRTemplateFrame(JROrigin origin, JRDefaultStyleProvider defaultStyleProvider, JRFillFrame frame) {
        super(origin, defaultStyleProvider);
        this.setElement(frame);
        this.copyBox(frame.getLineBox());
    }

    public JRTemplateFrame(JROrigin origin, JRDefaultStyleProvider defaultStyleProvider) {
        super(origin, defaultStyleProvider);
        this.lineBox = new JRBaseLineBox(this);
    }

    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    public void copyBox(JRLineBox lineBox) {
        this.lineBox = lineBox.clone(this);
    }

    public ModeEnum getModeValue() {
        return JRStyleResolver.getMode(this, ModeEnum.TRANSPARENT);
    }

    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.lineBox == null) {
            this.lineBox = new JRBaseLineBox(this);
            JRBoxUtil.setToBox(this.border, this.topBorder, this.leftBorder, this.bottomBorder, this.rightBorder, this.borderColor, this.topBorderColor, this.leftBorderColor, this.bottomBorderColor, this.rightBorderColor, this.padding, this.topPadding, this.leftPadding, this.bottomPadding, this.rightPadding, this.lineBox);
            this.border = null;
            this.topBorder = null;
            this.leftBorder = null;
            this.bottomBorder = null;
            this.rightBorder = null;
            this.borderColor = null;
            this.topBorderColor = null;
            this.leftBorderColor = null;
            this.bottomBorderColor = null;
            this.rightBorderColor = null;
            this.padding = null;
            this.topPadding = null;
            this.leftPadding = null;
            this.bottomPadding = null;
            this.rightPadding = null;
        }
    }

    public int getHashCode() {
        ObjectUtils.HashCode hash = ObjectUtils.hash();
        this.addTemplateHash(hash);
        hash.addIdentical(this.lineBox);
        return hash.getHashCode();
    }

    public boolean isIdentical(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JRTemplateFrame)) {
            return false;
        }
        JRTemplateFrame template = (JRTemplateFrame)object;
        return this.templateIdentical(template) && ObjectUtils.identical(this.lineBox, template.lineBox);
    }
}

