/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import java.util.Arrays;
import org.springframework.aop.SpringProxy;
import org.springframework.aop.TargetClassAware;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.support.AopUtils;
import org.springframework.aop.target.SingletonTargetSource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AopProxyUtils {
    public static Class<?> ultimateTargetClass(Object candidate) {
        Assert.notNull((Object)candidate, (String)"Candidate object must not be null");
        Object current = candidate;
        Class<?> result = null;
        while (current instanceof TargetClassAware) {
            TargetSource targetSource;
            result = ((TargetClassAware)current).getTargetClass();
            Object nested = null;
            if (current instanceof Advised && (targetSource = ((Advised)current).getTargetSource()) instanceof SingletonTargetSource) {
                nested = ((SingletonTargetSource)targetSource).getTarget();
            }
            current = nested;
        }
        if (result == null) {
            result = AopUtils.isCglibProxy(candidate) ? candidate.getClass().getSuperclass() : candidate.getClass();
        }
        return result;
    }

    public static Class[] completeProxiedInterfaces(AdvisedSupport advised) {
        Class<?> targetClass;
        Class[] specifiedInterfaces = advised.getProxiedInterfaces();
        if (specifiedInterfaces.length == 0 && (targetClass = advised.getTargetClass()) != null && targetClass.isInterface()) {
            specifiedInterfaces = new Class[]{targetClass};
        }
        boolean addSpringProxy = !advised.isInterfaceProxied(SpringProxy.class);
        boolean addAdvised = !advised.isOpaque() && !advised.isInterfaceProxied(Advised.class);
        int nonUserIfcCount = 0;
        if (addSpringProxy) {
            ++nonUserIfcCount;
        }
        if (addAdvised) {
            ++nonUserIfcCount;
        }
        Class[] proxiedInterfaces = new Class[specifiedInterfaces.length + nonUserIfcCount];
        System.arraycopy(specifiedInterfaces, 0, proxiedInterfaces, 0, specifiedInterfaces.length);
        if (addSpringProxy) {
            proxiedInterfaces[specifiedInterfaces.length] = SpringProxy.class;
        }
        if (addAdvised) {
            proxiedInterfaces[proxiedInterfaces.length - 1] = Advised.class;
        }
        return proxiedInterfaces;
    }

    public static Class[] proxiedUserInterfaces(Object proxy) {
        Class<?>[] proxyInterfaces = proxy.getClass().getInterfaces();
        int nonUserIfcCount = 0;
        if (proxy instanceof SpringProxy) {
            ++nonUserIfcCount;
        }
        if (proxy instanceof Advised) {
            ++nonUserIfcCount;
        }
        Object[] userInterfaces = new Class[proxyInterfaces.length - nonUserIfcCount];
        System.arraycopy(proxyInterfaces, 0, userInterfaces, 0, userInterfaces.length);
        Assert.notEmpty((Object[])userInterfaces, (String)"JDK proxy must implement one or more interfaces");
        return userInterfaces;
    }

    public static boolean equalsInProxy(AdvisedSupport a, AdvisedSupport b) {
        return a == b || AopProxyUtils.equalsProxiedInterfaces(a, b) && AopProxyUtils.equalsAdvisors(a, b) && a.getTargetSource().equals(b.getTargetSource());
    }

    public static boolean equalsProxiedInterfaces(AdvisedSupport a, AdvisedSupport b) {
        return Arrays.equals(a.getProxiedInterfaces(), b.getProxiedInterfaces());
    }

    public static boolean equalsAdvisors(AdvisedSupport a, AdvisedSupport b) {
        return Arrays.equals(a.getAdvisors(), b.getAdvisors());
    }
}

