/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.definition.pattern;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tiles.Definition;
import org.apache.tiles.definition.pattern.PatternDefinitionResolver;
import org.apache.tiles.definition.pattern.PatternUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexpPatternDefinitionResolver<T>
implements PatternDefinitionResolver<T> {
    private Map<T, List<PatternMapping>> key2patternMappingList = new HashMap<T, List<PatternMapping>>();

    @Override
    public Definition resolveDefinition(String name, T customizationKey) {
        Definition retValue = null;
        List<PatternMapping> mappings = this.key2patternMappingList.get(customizationKey);
        if (mappings != null) {
            for (PatternMapping mapping : mappings) {
                Matcher matcher = mapping.pattern.matcher(name);
                if (!matcher.matches()) continue;
                int groupCount = matcher.groupCount() + 1;
                Object[] vars = new Object[groupCount];
                for (int i = 0; i < groupCount; ++i) {
                    vars[i] = matcher.group(i);
                }
                retValue = PatternUtil.replacePlaceholders(mapping.definition, name, vars);
                break;
            }
        }
        return retValue;
    }

    @Override
    public Map<String, Definition> storeDefinitionPatterns(Map<String, Definition> localeDefsMap, T customizationKey) {
        List<PatternMapping> patternMappingList = this.key2patternMappingList.get(customizationKey);
        if (patternMappingList == null) {
            patternMappingList = new ArrayList<PatternMapping>();
            this.key2patternMappingList.put(customizationKey, patternMappingList);
        }
        return this.addRegexpMappings(localeDefsMap, patternMappingList);
    }

    private Map<String, Definition> addRegexpMappings(Map<String, Definition> localeDefsMap, List<PatternMapping> patternMappingList) {
        LinkedHashSet<String> excludedKeys = new LinkedHashSet<String>();
        for (Map.Entry<String, Definition> entry : localeDefsMap.entrySet()) {
            String name = entry.getKey();
            if (name.startsWith("~")) {
                patternMappingList.add(new PatternMapping(name.substring(1), new Definition(entry.getValue())));
                continue;
            }
            excludedKeys.add(name);
        }
        return PatternUtil.createExtractedMap(localeDefsMap, excludedKeys);
    }

    private static final class PatternMapping {
        private Pattern pattern;
        private Definition definition;

        private PatternMapping(String regexp, Definition definition) {
            this.pattern = Pattern.compile(regexp);
            this.definition = definition;
        }
    }
}

