/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSBounds;
import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSDefineObject;
import com.flagstone.transform.FSKerning;
import com.flagstone.transform.FSShape;
import com.flagstone.transform.FSTransformObject;
import com.flagstone.transform.Transform;
import java.util.ArrayList;
import java.util.Iterator;

public class FSDefineFont2
extends FSDefineObject {
    private int encoding = 0;
    private boolean small = false;
    private boolean italic = false;
    private boolean bold = false;
    private int language = 0;
    private String name = "";
    private ArrayList shapes = new ArrayList();
    private ArrayList codes = new ArrayList();
    private int ascent = 0;
    private int descent = 0;
    private int leading = 0;
    private ArrayList advances = null;
    private ArrayList bounds = null;
    private ArrayList kernings = null;

    public FSDefineFont2(FSCoder fSCoder) {
        super(48, 0);
        this.decode(fSCoder);
    }

    public FSDefineFont2(int n, String string) {
        super(48, n);
        this.setName(string);
    }

    public FSDefineFont2(FSDefineFont2 fSDefineFont2) {
        super(fSDefineFont2);
        this.encoding = fSDefineFont2.encoding;
        this.small = fSDefineFont2.small;
        this.italic = fSDefineFont2.italic;
        this.bold = fSDefineFont2.bold;
        this.language = fSDefineFont2.language;
        this.name = new String(fSDefineFont2.name);
        this.shapes = new ArrayList();
        Iterator iterator = fSDefineFont2.shapes.iterator();
        while (iterator.hasNext()) {
            this.shapes.add(((FSShape)iterator.next()).clone());
        }
        this.codes = new ArrayList();
        iterator = fSDefineFont2.codes.iterator();
        while (iterator.hasNext()) {
            this.codes.add(new Integer((Integer)iterator.next()));
        }
        this.ascent = fSDefineFont2.ascent;
        this.descent = fSDefineFont2.descent;
        this.leading = fSDefineFont2.leading;
        if (this.advances != null) {
            this.advances = new ArrayList();
            iterator = fSDefineFont2.advances.iterator();
            while (iterator.hasNext()) {
                this.advances.add(new Integer((Integer)iterator.next()));
            }
        }
        if (this.bounds != null) {
            this.bounds = new ArrayList();
            iterator = fSDefineFont2.bounds.iterator();
            while (iterator.hasNext()) {
                this.bounds.add(((FSBounds)iterator.next()).clone());
            }
        }
        if (this.kernings != null) {
            this.kernings = new ArrayList();
            iterator = fSDefineFont2.kernings.iterator();
            while (iterator.hasNext()) {
                this.kernings.add(((FSKerning)iterator.next()).clone());
            }
        }
    }

    public void add(FSShape fSShape) {
        this.shapes.add(fSShape);
    }

    public void addCode(int n) {
        this.codes.add(new Integer(n));
    }

    public void addAdvance(int n) {
        this.advances.add(new Integer(n));
    }

    public void add(FSBounds fSBounds) {
        this.bounds.add(fSBounds);
    }

    public void add(FSKerning fSKerning) {
        this.kernings.add(fSKerning);
    }

    public int getEncoding() {
        return this.encoding;
    }

    public boolean isSmall() {
        return this.small;
    }

    public void setSmall(boolean bl) {
        this.small = bl;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isBold() {
        return this.bold;
    }

    public int getLanguage() {
        return this.language;
    }

    public void setLanguage(int n) {
        this.language = n;
    }

    public String getName() {
        return this.name;
    }

    public ArrayList getShapes() {
        return this.shapes;
    }

    public ArrayList getCodes() {
        return this.codes;
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getDescent() {
        return this.descent;
    }

    public int getLeading() {
        return this.leading;
    }

    public ArrayList getAdvances() {
        return this.advances;
    }

    public ArrayList getBounds() {
        return this.bounds;
    }

    public ArrayList getKernings() {
        return this.kernings;
    }

    public void setEncoding(int n) {
        this.encoding = n;
    }

    public void setItalic(boolean bl) {
        this.italic = bl;
    }

    public void setBold(boolean bl) {
        this.bold = bl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setShapes(ArrayList arrayList) {
        this.shapes = arrayList;
    }

    public void setCodes(ArrayList arrayList) {
        this.codes = arrayList;
    }

    public void setAscent(int n) {
        this.ascent = n;
    }

    public void setDescent(int n) {
        this.descent = n;
    }

    public void setLeading(int n) {
        this.leading = n;
    }

    public void setAdvances(ArrayList arrayList) {
        this.advances = arrayList;
    }

    public void setBounds(ArrayList arrayList) {
        this.bounds = arrayList;
    }

    public void setKernings(ArrayList arrayList) {
        this.kernings = arrayList;
    }

    public Object clone() {
        FSDefineFont2 fSDefineFont2 = (FSDefineFont2)super.clone();
        fSDefineFont2.shapes = new ArrayList();
        Iterator iterator = this.shapes.iterator();
        while (iterator.hasNext()) {
            fSDefineFont2.shapes.add(((FSShape)iterator.next()).clone());
        }
        fSDefineFont2.codes = new ArrayList();
        iterator = this.codes.iterator();
        while (iterator.hasNext()) {
            fSDefineFont2.codes.add(new Integer((Integer)iterator.next()));
        }
        if (this.advances != null) {
            fSDefineFont2.advances = new ArrayList();
            iterator = this.advances.iterator();
            while (iterator.hasNext()) {
                fSDefineFont2.advances.add(new Integer((Integer)iterator.next()));
            }
        }
        if (this.bounds != null) {
            fSDefineFont2.bounds = new ArrayList();
            iterator = this.bounds.iterator();
            while (iterator.hasNext()) {
                fSDefineFont2.bounds.add(((FSBounds)iterator.next()).clone());
            }
        }
        if (this.kernings != null) {
            fSDefineFont2.kernings = new ArrayList();
            iterator = this.kernings.iterator();
            while (iterator.hasNext()) {
                fSDefineFont2.kernings.add(((FSKerning)iterator.next()).clone());
            }
        }
        return fSDefineFont2;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSDefineFont2 fSDefineFont2 = (FSDefineFont2)object;
            bl = this.encoding == fSDefineFont2.encoding;
            bl = bl && this.small == fSDefineFont2.small;
            bl = bl && this.italic == fSDefineFont2.italic;
            bl = bl && this.bold == fSDefineFont2.bold;
            boolean bl2 = bl = bl && this.language == fSDefineFont2.language;
            if (this.name != null) {
                bl = bl && this.name.equals(fSDefineFont2.name);
            } else {
                boolean bl3 = bl = bl && this.name == fSDefineFont2.name;
            }
            if (this.shapes != null) {
                bl = bl && this.shapes.equals(fSDefineFont2.shapes);
            } else {
                boolean bl4 = bl = bl && this.shapes == fSDefineFont2.shapes;
            }
            if (this.codes != null) {
                bl = bl && this.codes.equals(fSDefineFont2.codes);
            } else {
                boolean bl5 = bl = bl && this.codes == fSDefineFont2.codes;
            }
            if (this.containsLayoutInfo()) {
                bl = bl && this.ascent == fSDefineFont2.ascent;
                bl = bl && this.descent == fSDefineFont2.descent;
                boolean bl6 = bl = bl && this.leading == fSDefineFont2.leading;
                if (this.advances != null) {
                    bl = bl && this.advances.equals(fSDefineFont2.advances);
                } else {
                    boolean bl7 = bl = bl && this.advances == fSDefineFont2.advances;
                }
                if (this.bounds != null) {
                    bl = bl && this.bounds.equals(fSDefineFont2.bounds);
                } else {
                    boolean bl8 = bl = bl && this.bounds == fSDefineFont2.bounds;
                }
                bl = this.kernings != null ? bl && this.kernings.equals(fSDefineFont2.kernings) : bl && this.kernings == fSDefineFont2.kernings;
            }
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "encoding", this.encoding);
            Transform.append(stringBuffer, "small", this.small);
            Transform.append(stringBuffer, "italic", this.italic);
            Transform.append(stringBuffer, "bold", this.bold);
            Transform.append(stringBuffer, "language", this.language);
            Transform.append(stringBuffer, "name", this.name);
            Transform.append(stringBuffer, "shapes", this.shapes, n);
            Transform.append(stringBuffer, "codes", this.codes, n);
            Transform.append(stringBuffer, "ascent", this.ascent);
            Transform.append(stringBuffer, "descent", this.descent);
            Transform.append(stringBuffer, "leading", this.leading);
            Transform.append(stringBuffer, "advances", this.advances, n);
            Transform.append(stringBuffer, "bounds", this.bounds, n);
            Transform.append(stringBuffer, "kernings", this.kernings, n);
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        boolean bl = this.wideOffsetsForIndexedArray(this.shapes, fSCoder);
        int n = 0;
        n = fSCoder.context[2] > 5 ? 1 : (this.encoding != 1 ? 1 : 0);
        super.length(fSCoder);
        fSCoder.context[6] = 1;
        fSCoder.context[7] = 0;
        fSCoder.context[12] = n;
        this.length += 3;
        this.length += FSCoder.strlen(this.name, false);
        this.length += 2;
        this.length += this.shapes.size() * (bl ? 4 : 2);
        this.length += bl ? 4 : 2;
        Iterator iterator = this.shapes.iterator();
        while (iterator.hasNext()) {
            this.length += ((FSTransformObject)iterator.next()).length(fSCoder);
        }
        this.length += this.shapes.size() * (n == 1 ? 2 : 1);
        if (this.containsLayoutInfo()) {
            this.length += 6;
            this.length += this.shapes.size() * 2;
            iterator = this.bounds.iterator();
            while (iterator.hasNext()) {
                this.length += ((FSTransformObject)iterator.next()).length(fSCoder);
            }
            this.length += 2;
            this.length += this.kernings.size() * (n == 1 ? 6 : 4);
        }
        fSCoder.context[6] = 0;
        fSCoder.context[7] = 0;
        fSCoder.context[12] = 0;
        return this.length;
    }

    public void encode(FSCoder fSCoder) {
        int n;
        int n2;
        int n3;
        boolean bl = this.wideOffsetsForIndexedArray(this.shapes, fSCoder);
        int n4 = 0;
        int n5 = 0;
        if (fSCoder.context[2] > 5) {
            n4 = 1;
        } else {
            int n6 = n4 = this.encoding != 1 ? 1 : 0;
        }
        if (this.encoding == 1) {
            n5 = 1;
        } else if (this.small) {
            n5 = 2;
        } else if (this.encoding == 2) {
            n5 = 4;
        }
        super.encode(fSCoder);
        fSCoder.context[6] = 1;
        fSCoder.context[7] = 0;
        fSCoder.context[12] = n4;
        fSCoder.writeBits(this.containsLayoutInfo() ? 1 : 0, 1);
        fSCoder.writeBits(n5, 3);
        fSCoder.writeBits(bl ? 1 : 0, 1);
        fSCoder.writeBits(n4, 1);
        fSCoder.writeBits(this.italic ? 1 : 0, 1);
        fSCoder.writeBits(this.bold ? 1 : 0, 1);
        fSCoder.writeWord(fSCoder.context[2] > 5 ? this.language : 0, 1);
        fSCoder.writeWord(FSCoder.strlen(this.name, false), 1);
        fSCoder.writeString(this.name);
        fSCoder.writeWord(this.shapes.size(), 2);
        int n7 = n3 = fSCoder.getPointer();
        int n8 = bl ? 4 : 2;
        for (int i = 0; i <= this.shapes.size(); ++i) {
            fSCoder.writeWord(0, n8);
        }
        Iterator iterator = this.shapes.iterator();
        while (iterator.hasNext()) {
            n2 = fSCoder.getPointer();
            n = fSCoder.getPointer() - n3 >> 3;
            fSCoder.setPointer(n7);
            fSCoder.writeWord(n, n8);
            fSCoder.setPointer(n2);
            ((FSTransformObject)iterator.next()).encode(fSCoder);
            n7 += n8 << 3;
        }
        n2 = fSCoder.getPointer();
        n = fSCoder.getPointer() - n3 >> 3;
        fSCoder.setPointer(n7);
        fSCoder.writeWord(n, n8);
        fSCoder.setPointer(n2);
        iterator = this.codes.iterator();
        while (iterator.hasNext()) {
            fSCoder.writeWord((Integer)iterator.next(), n4 == 1 ? 2 : 1);
        }
        if (this.containsLayoutInfo()) {
            fSCoder.writeWord(this.ascent, 2);
            fSCoder.writeWord(this.descent, 2);
            fSCoder.writeWord(this.leading, 2);
            iterator = this.advances.iterator();
            while (iterator.hasNext()) {
                fSCoder.writeWord((Integer)iterator.next(), 2);
            }
            iterator = this.bounds.iterator();
            while (iterator.hasNext()) {
                ((FSTransformObject)iterator.next()).encode(fSCoder);
            }
            fSCoder.writeWord(this.kernings.size(), 2);
            iterator = this.kernings.iterator();
            while (iterator.hasNext()) {
                ((FSTransformObject)iterator.next()).encode(fSCoder);
            }
        }
        fSCoder.context[6] = 0;
        fSCoder.context[7] = 0;
        fSCoder.context[12] = 0;
        fSCoder.endObject(this.name());
    }

    public void decode(FSCoder fSCoder) {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        super.decode(fSCoder);
        bl3 = fSCoder.readBits(1, false) != 0;
        int n5 = fSCoder.readBits(3, false);
        this.encoding = 0;
        if (n5 == 1) {
            this.encoding = 1;
        } else if (n5 == 2) {
            this.small = true;
        } else if (n5 == 4) {
            this.encoding = 2;
        }
        bl = fSCoder.readBits(1, false) != 0;
        bl2 = fSCoder.readBits(1, false) != 0;
        fSCoder.context[12] = bl2 ? 1 : 0;
        this.italic = fSCoder.readBits(1, false) != 0;
        this.bold = fSCoder.readBits(1, false) != 0;
        this.language = fSCoder.readBits(8, false);
        n4 = fSCoder.readWord(1, false);
        this.name = fSCoder.readString(n4);
        n2 = fSCoder.readWord(2, false);
        int n6 = fSCoder.getPointer();
        int[] nArray = new int[n2 + 1];
        for (n = 0; n < n2; ++n) {
            nArray[n] = fSCoder.readWord(bl ? 4 : 2, false);
        }
        nArray[n2] = fSCoder.readWord(bl ? 4 : 2, false);
        for (n = 0; n < n2; ++n) {
            fSCoder.setPointer(n6 + (nArray[n] << 3));
            if (fSCoder.context[20] == 1) {
                this.shapes.add(new FSShape(fSCoder));
                continue;
            }
            this.shapes.add(new FSShape(fSCoder, nArray[n + 1] - nArray[n]));
        }
        for (n = 0; n < n2; ++n) {
            this.codes.add(new Integer(fSCoder.readWord(bl2 ? 2 : 1, false)));
        }
        if (bl3) {
            this.ascent = fSCoder.readWord(2, true);
            this.descent = fSCoder.readWord(2, true);
            this.leading = fSCoder.readWord(2, true);
            this.advances = new ArrayList();
            this.bounds = new ArrayList();
            this.kernings = new ArrayList();
            for (n = 0; n < n2; ++n) {
                this.advances.add(new Integer(fSCoder.readWord(2, true)));
            }
            for (n = 0; n < n2; ++n) {
                this.bounds.add(new FSBounds(fSCoder));
            }
            n3 = fSCoder.readWord(2, false);
            for (n = 0; n < n3; ++n) {
                this.kernings.add(new FSKerning(fSCoder));
            }
        }
        fSCoder.context[12] = 0;
        fSCoder.endObject(this.name());
    }

    private boolean containsLayoutInfo() {
        boolean bl = false;
        bl = bl || this.ascent != 0;
        bl = bl || this.descent != 0;
        bl = bl || this.leading != 0;
        bl = bl || this.advances != null && this.advances.size() > 0;
        bl = bl || this.bounds != null && this.bounds.size() > 0;
        bl = bl || this.kernings != null && this.kernings.size() > 0;
        return bl;
    }

    private boolean wideOffsetsForIndexedArray(ArrayList arrayList, FSCoder fSCoder) {
        boolean bl = false;
        int n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            n += ((FSTransformObject)iterator.next()).length(fSCoder);
        }
        if (arrayList.size() * 2 + n > 65535) {
            bl = true;
        }
        return bl;
    }
}

