/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSDefineObject;
import com.flagstone.transform.Transform;

public class FSDefineJPEGImage2
extends FSDefineObject {
    private byte[] image = null;
    private byte[] encodingTable = null;

    public FSDefineJPEGImage2(FSCoder fSCoder) {
        super(21, 0);
        this.decode(fSCoder);
    }

    public FSDefineJPEGImage2(int n, byte[] byArray, byte[] byArray2) {
        super(21, n);
        this.setImage(byArray);
        this.setEncodingTable(byArray2);
    }

    public FSDefineJPEGImage2(int n, byte[] byArray) {
        super(21, n);
        this.setImage(byArray);
        this.setEncodingTable(null);
    }

    public FSDefineJPEGImage2(FSDefineJPEGImage2 fSDefineJPEGImage2) {
        super(fSDefineJPEGImage2);
        this.image = Transform.clone(fSDefineJPEGImage2.image);
        this.encodingTable = Transform.clone(fSDefineJPEGImage2.encodingTable);
    }

    public byte[] getImage() {
        return this.image;
    }

    public byte[] getEncodingTable() {
        return this.encodingTable;
    }

    public void setImage(byte[] byArray) {
        this.image = byArray;
    }

    public void setEncodingTable(byte[] byArray) {
        if (byArray == null) {
            byArray = new byte[]{-1, -40, -1, -39};
        }
        this.encodingTable = byArray;
    }

    public Object clone() {
        FSDefineJPEGImage2 fSDefineJPEGImage2 = (FSDefineJPEGImage2)super.clone();
        fSDefineJPEGImage2.image = Transform.clone(this.image);
        fSDefineJPEGImage2.encodingTable = Transform.clone(this.encodingTable);
        return fSDefineJPEGImage2;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSDefineJPEGImage2 fSDefineJPEGImage2 = (FSDefineJPEGImage2)object;
            bl = Transform.equals(this.image, fSDefineJPEGImage2.image);
            bl = bl && Transform.equals(this.encodingTable, fSDefineJPEGImage2.encodingTable);
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "encodingTable", "<data>");
            Transform.append(stringBuffer, "image", "<data>");
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        super.length(fSCoder);
        this.length += this.encodingTable.length;
        this.length += this.image.length;
        return this.length;
    }

    public void encode(FSCoder fSCoder) {
        super.encode(fSCoder);
        fSCoder.writeBytes(this.encodingTable);
        fSCoder.writeBytes(this.image);
        fSCoder.endObject(this.name());
    }

    public void decode(FSCoder fSCoder) {
        super.decode(fSCoder);
        this.setEncodingTable(this.readJPEGStream(fSCoder));
        byte[] byArray = new byte[this.length - this.encodingTable.length - 2];
        fSCoder.readBytes(byArray);
        this.setImage(byArray);
        fSCoder.endObject(this.name());
    }

    private byte[] readJPEGStream(FSCoder fSCoder) {
        byte[] byArray = null;
        int n = 65497;
        int n2 = fSCoder.getPointer();
        int n3 = n2 + (this.length - 2 << 3);
        int n4 = 0;
        do {
            if ((n4 = fSCoder.scanBits(16, false)) == n) {
                n3 = fSCoder.getPointer() + 16;
                break;
            }
            fSCoder.adjustPointer(8);
        } while (fSCoder.getPointer() < n3);
        int n5 = n3 - n2 >>> 3;
        fSCoder.setPointer(n2);
        byArray = new byte[n5];
        fSCoder.readBytes(byArray);
        return byArray;
    }
}

