/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSMovieObject;
import com.flagstone.transform.Transform;
import java.util.ArrayList;
import java.util.Iterator;

public class FSFontInfo
extends FSMovieObject {
    private int identifier = 0;
    private String name = "";
    private int encoding = 0;
    private boolean small = false;
    private boolean italic = false;
    private boolean bold = false;
    private ArrayList codes = new ArrayList();
    private boolean _containsWideCodes = false;

    public FSFontInfo(FSCoder fSCoder) {
        super(13);
        this.decode(fSCoder);
    }

    public FSFontInfo(int n, String string) {
        super(13);
        this.setIdentifier(n);
        this.setName(string);
    }

    public FSFontInfo(FSFontInfo fSFontInfo) {
        super(fSFontInfo);
        this.identifier = fSFontInfo.identifier;
        this.name = new String(fSFontInfo.name);
        this.encoding = fSFontInfo.encoding;
        this.small = fSFontInfo.small;
        this.italic = fSFontInfo.italic;
        this.bold = fSFontInfo.bold;
        this.codes = new ArrayList(fSFontInfo.codes.size());
        Iterator iterator = fSFontInfo.codes.iterator();
        while (iterator.hasNext()) {
            this.codes.add(new Integer((Integer)iterator.next()));
        }
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public int getEncoding() {
        return this.encoding;
    }

    public boolean isSmall() {
        return this.small;
    }

    public void setSmall(boolean bl) {
        this.small = bl;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isBold() {
        return this.bold;
    }

    public ArrayList getCodes() {
        return this.codes;
    }

    public void setIdentifier(int n) {
        this.identifier = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setEncoding(int n) {
        this.encoding = n;
    }

    public void setItalic(boolean bl) {
        this.italic = bl;
    }

    public void setBold(boolean bl) {
        this.bold = bl;
    }

    public void setCodes(ArrayList arrayList) {
        this.codes = arrayList;
    }

    public Object clone() {
        FSFontInfo fSFontInfo = (FSFontInfo)super.clone();
        fSFontInfo.codes = new ArrayList();
        Iterator iterator = this.codes.iterator();
        while (iterator.hasNext()) {
            fSFontInfo.codes.add(new Integer((Integer)iterator.next()));
        }
        return fSFontInfo;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSFontInfo fSFontInfo = (FSFontInfo)object;
            bl = this.identifier == fSFontInfo.identifier;
            bl = bl && this.encoding == fSFontInfo.encoding;
            bl = bl && this.small == fSFontInfo.small;
            bl = bl && this.italic == fSFontInfo.italic;
            boolean bl2 = bl = bl && this.bold == fSFontInfo.bold;
            if (this.name != null) {
                bl = bl && this.name.equals(fSFontInfo.name);
            } else {
                boolean bl3 = bl = bl && this.name == fSFontInfo.name;
            }
            bl = this.codes != null ? bl && this.codes.equals(fSFontInfo.codes) : bl && this.codes == fSFontInfo.codes;
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "identifier", this.identifier);
            Transform.append(stringBuffer, "encoding", this.encoding);
            Transform.append(stringBuffer, "small", this.small);
            Transform.append(stringBuffer, "italic", this.italic);
            Transform.append(stringBuffer, "bold", this.bold);
            Transform.append(stringBuffer, "name", this.name);
            Transform.append(stringBuffer, "codes", this.codes, n);
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        super.length(fSCoder);
        this.length += 4;
        this.length += FSCoder.strlen(this.name, false);
        this._containsWideCodes = false;
        Iterator iterator = this.codes.iterator();
        while (iterator.hasNext()) {
            if ((Integer)iterator.next() <= 255) continue;
            this._containsWideCodes = true;
        }
        this.length += this.codes.size() * (this._containsWideCodes ? 2 : 1);
        return this.length;
    }

    public void encode(FSCoder fSCoder) {
        super.encode(fSCoder);
        fSCoder.writeWord(this.identifier, 2);
        fSCoder.writeWord(FSCoder.strlen(this.name, false), 1);
        fSCoder.writeString(this.name);
        fSCoder.writeBits(0, 2);
        fSCoder.writeBits(this.small ? 1 : 0, 1);
        fSCoder.writeBits(this.encoding, 2);
        fSCoder.writeBits(this.italic ? 1 : 0, 1);
        fSCoder.writeBits(this.bold ? 1 : 0, 1);
        fSCoder.writeBits(this._containsWideCodes ? 1 : 0, 1);
        Iterator iterator = this.codes.iterator();
        while (iterator.hasNext()) {
            fSCoder.writeWord((Integer)iterator.next(), this._containsWideCodes ? 2 : 1);
        }
        fSCoder.endObject(this.name());
    }

    public void decode(FSCoder fSCoder) {
        int n = 0;
        this.codes = new ArrayList();
        super.decode(fSCoder);
        this.identifier = fSCoder.readWord(2, false);
        n = fSCoder.readWord(1, false);
        this.name = fSCoder.readString(n);
        fSCoder.readBits(2, false);
        this.small = fSCoder.readBits(1, false) != 0;
        this.encoding = fSCoder.readBits(2, false);
        this.italic = fSCoder.readBits(1, false) != 0;
        this.bold = fSCoder.readBits(1, false) != 0;
        this._containsWideCodes = fSCoder.readBits(1, false) != 0;
        for (int i = 3 + n + 1; i < this.length; i += this._containsWideCodes ? 2 : 1) {
            this.codes.add(new Integer(fSCoder.readWord(this._containsWideCodes ? 2 : 1, false)));
        }
        fSCoder.endObject(this.name());
    }
}

