/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSClipEvent;
import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSColorTransform;
import com.flagstone.transform.FSCoordTransform;
import com.flagstone.transform.FSMovieObject;
import com.flagstone.transform.FSTransformObject;
import com.flagstone.transform.Transform;
import java.util.ArrayList;
import java.util.Iterator;

public class FSPlaceObject2
extends FSMovieObject {
    public static final int Modify = 1;
    public static final int New = 2;
    public static final int Replace = 3;
    private int place = 2;
    private int layer = 0;
    private int identifier = 0;
    private FSCoordTransform transform = null;
    private FSColorTransform colorTransform = null;
    private float ratio = -1.0f;
    private int clippingDepth = 0;
    private String name = null;
    private ArrayList clipEvents = null;
    private byte[] encodedEvents = null;

    public FSPlaceObject2(FSCoder fSCoder) {
        super(26);
        this.decode(fSCoder);
    }

    public FSPlaceObject2(int n, int n2, int n3, int n4) {
        super(26);
        this.setPlaceType(2);
        this.setIdentifier(n);
        this.setLayer(n2);
        this.setTransform(new FSCoordTransform(n3, n4));
    }

    public FSPlaceObject2(int n, int n2, float f, int n3, int n4) {
        super(26);
        this.setPlaceType(2);
        this.setIdentifier(n);
        this.setLayer(n2);
        this.setRatio(f);
        this.setTransform(new FSCoordTransform(n3, n4));
    }

    public FSPlaceObject2(int n, int n2, FSCoordTransform fSCoordTransform) {
        super(26);
        this.setPlaceType(2);
        this.setIdentifier(n);
        this.setLayer(n2);
        this.setTransform(fSCoordTransform);
    }

    public FSPlaceObject2(int n, int n2, FSCoordTransform fSCoordTransform, FSColorTransform fSColorTransform) {
        super(26);
        this.setPlaceType(2);
        this.setIdentifier(n);
        this.setLayer(n2);
        this.setTransform(fSCoordTransform);
        this.setColorTransform(fSColorTransform);
    }

    public FSPlaceObject2(int n, int n2, int n3, int n4, int n5) {
        super(26);
        this.setPlaceType(2);
        this.setIdentifier(n);
        this.setLayer(n2);
        this.setClippingDepth(n3);
        this.setTransform(new FSCoordTransform(n4, n5));
    }

    public FSPlaceObject2(int n, int n2, ArrayList arrayList, String string, int n3, int n4) {
        super(26);
        this.setPlaceType(2);
        this.setIdentifier(n);
        this.setLayer(n2);
        this.setClipEvents(arrayList);
        this.setName(string);
        this.setTransform(new FSCoordTransform(n3, n4));
    }

    public FSPlaceObject2(int n, int n2, byte[] byArray, String string, int n3, int n4) {
        super(26);
        this.setPlaceType(2);
        this.setIdentifier(n);
        this.setLayer(n2);
        this.setEncodedEvents(byArray);
        this.setName(string);
        this.setTransform(new FSCoordTransform(n3, n4));
    }

    public FSPlaceObject2(int n, int n2) {
        super(26);
        this.setPlaceType(3);
        this.setIdentifier(n);
        this.setLayer(n2);
    }

    public FSPlaceObject2(int n, int n2, int n3) {
        super(26);
        this.setPlaceType(1);
        this.setLayer(n);
        this.setTransform(new FSCoordTransform(n2, n3));
    }

    public FSPlaceObject2(int n, FSCoordTransform fSCoordTransform) {
        super(26);
        this.setPlaceType(1);
        this.setLayer(n);
        this.setTransform(fSCoordTransform);
    }

    public FSPlaceObject2(int n, FSColorTransform fSColorTransform) {
        super(26);
        this.setPlaceType(1);
        this.setLayer(n);
        this.setColorTransform(fSColorTransform);
    }

    public FSPlaceObject2(int n, FSCoordTransform fSCoordTransform, FSColorTransform fSColorTransform) {
        super(26);
        this.setPlaceType(1);
        this.setLayer(n);
        this.setTransform(fSCoordTransform);
        this.setColorTransform(fSColorTransform);
    }

    public FSPlaceObject2(int n, float f, int n2, int n3) {
        super(26);
        this.setPlaceType(1);
        this.setLayer(n);
        this.setRatio(f);
        this.setTransform(new FSCoordTransform(n2, n3));
    }

    public FSPlaceObject2(int n, float f, FSCoordTransform fSCoordTransform) {
        super(26);
        this.setPlaceType(1);
        this.setLayer(n);
        this.setRatio(f);
        this.setTransform(fSCoordTransform);
    }

    public FSPlaceObject2(int n, int n2, int n3, FSCoordTransform fSCoordTransform, FSColorTransform fSColorTransform) {
        super(26);
        this.setPlaceType(n);
        this.setIdentifier(n2);
        this.setLayer(n3);
        this.setTransform(fSCoordTransform);
        this.setColorTransform(fSColorTransform);
    }

    public FSPlaceObject2(FSPlaceObject2 fSPlaceObject2) {
        super(fSPlaceObject2);
        this.place = fSPlaceObject2.place;
        this.layer = fSPlaceObject2.layer;
        this.identifier = fSPlaceObject2.identifier;
        if (fSPlaceObject2.transform != null) {
            this.transform = new FSCoordTransform(fSPlaceObject2.transform);
        }
        if (fSPlaceObject2.colorTransform != null) {
            this.colorTransform = new FSColorTransform(fSPlaceObject2.colorTransform);
        }
        this.ratio = fSPlaceObject2.ratio;
        this.clippingDepth = fSPlaceObject2.clippingDepth;
        if (fSPlaceObject2.name != null) {
            this.name = new String(fSPlaceObject2.name);
        }
        if (fSPlaceObject2.clipEvents != null) {
            this.clipEvents = new ArrayList(fSPlaceObject2.clipEvents.size());
            Iterator iterator = fSPlaceObject2.clipEvents.iterator();
            while (iterator.hasNext()) {
                this.clipEvents.add(((FSClipEvent)iterator.next()).clone());
            }
        } else {
            this.encodedEvents = Transform.clone(this.encodedEvents);
        }
    }

    public void add(FSClipEvent fSClipEvent) {
        if (this.clipEvents == null) {
            this.clipEvents = new ArrayList();
        }
        this.clipEvents.add(fSClipEvent);
        this.encodedEvents = null;
    }

    public ArrayList getClipEvents() {
        return this.clipEvents;
    }

    public void setClipEvents(ArrayList arrayList) {
        this.clipEvents = arrayList;
        if (this.encodedEvents != null) {
            this.encodedEvents = null;
        }
    }

    public void setEncodedEvents(byte[] byArray) {
        this.encodedEvents = byArray;
        this.clipEvents = null;
    }

    public int getPlaceType() {
        return this.place;
    }

    public int getLayer() {
        return this.layer;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public FSCoordTransform getTransform() {
        return this.transform;
    }

    public FSColorTransform getColorTransform() {
        return this.colorTransform;
    }

    public float getRatio() {
        return this.ratio;
    }

    public int getClippingDepth() {
        return this.clippingDepth;
    }

    public String getName() {
        return this.name;
    }

    public void setPlaceType(int n) {
        this.place = n;
    }

    public void setLayer(int n) {
        this.layer = n;
    }

    public void setIdentifier(int n) {
        this.identifier = n;
    }

    public void setTransform(FSCoordTransform fSCoordTransform) {
        this.transform = fSCoordTransform;
    }

    public void setColorTransform(FSColorTransform fSColorTransform) {
        this.colorTransform = fSColorTransform;
    }

    public void setRatio(float f) {
        this.ratio = f;
    }

    public void setClippingDepth(int n) {
        this.clippingDepth = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Object clone() {
        FSPlaceObject2 fSPlaceObject2 = (FSPlaceObject2)super.clone();
        fSPlaceObject2.transform = this.transform != null ? (FSCoordTransform)this.transform.clone() : null;
        FSColorTransform fSColorTransform = fSPlaceObject2.colorTransform = this.colorTransform != null ? (FSColorTransform)this.colorTransform.clone() : null;
        if (this.clipEvents != null) {
            fSPlaceObject2.clipEvents = new ArrayList();
            Iterator iterator = this.clipEvents.iterator();
            while (iterator.hasNext()) {
                fSPlaceObject2.clipEvents.add(((FSClipEvent)iterator.next()).clone());
            }
        } else {
            fSPlaceObject2.encodedEvents = Transform.clone(this.encodedEvents);
        }
        return fSPlaceObject2;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSPlaceObject2 fSPlaceObject2 = (FSPlaceObject2)object;
            bl = this.place == fSPlaceObject2.place;
            bl = bl && this.layer == fSPlaceObject2.layer;
            boolean bl2 = bl = bl && this.identifier == fSPlaceObject2.identifier;
            if (this.transform == null) {
                bl = bl && fSPlaceObject2.transform == null;
            } else {
                boolean bl3 = bl = bl && this.transform.equals(fSPlaceObject2.transform);
            }
            bl = this.colorTransform == null ? bl && fSPlaceObject2.colorTransform == null : bl && this.colorTransform.equals(fSPlaceObject2.colorTransform);
            bl = bl && this.ratio == fSPlaceObject2.ratio;
            boolean bl4 = bl = bl && this.clippingDepth == fSPlaceObject2.clippingDepth;
            if (this.name == null) {
                bl = bl && fSPlaceObject2.name == null;
            } else {
                boolean bl5 = bl = bl && this.name.equals(fSPlaceObject2.name);
            }
            if (this.transform != null) {
                bl = bl && this.transform.equals(fSPlaceObject2.transform);
            } else {
                boolean bl6 = bl = bl && this.transform == fSPlaceObject2.transform;
            }
            bl = this.clipEvents != null ? bl && this.clipEvents.equals(fSPlaceObject2.clipEvents) : bl && Transform.equals(this.encodedEvents, fSPlaceObject2.encodedEvents);
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "place", this.place);
            Transform.append(stringBuffer, "layer", this.layer);
            Transform.append(stringBuffer, "identifier", this.identifier);
            Transform.append(stringBuffer, "transform", this.transform, n);
            Transform.append(stringBuffer, "colorTransform", this.colorTransform, n);
            Transform.append(stringBuffer, "ratio", this.ratio);
            Transform.append(stringBuffer, "clippingDepth", this.clippingDepth);
            Transform.append(stringBuffer, "name", this.name);
            if (this.clipEvents != null) {
                Transform.append(stringBuffer, "clipEvents", this.clipEvents, n);
            } else {
                stringBuffer.append("clipEvents = <data>; ");
            }
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        super.length(fSCoder);
        fSCoder.context[0] = 1;
        this.length += 3;
        this.length += this.place == 2 || this.place == 3 ? 2 : 0;
        this.length += this.containsTransform() ? this.transform.length(fSCoder) : 0;
        this.length += this.containsColorTransform(fSCoder) ? this.colorTransform.length(fSCoder) : 0;
        this.length += this.containsRatio() ? 2 : 0;
        this.length += this.containsClippingDepth() ? 2 : 0;
        this.length += this.containsName() ? FSCoder.strlen(this.name, true) : 0;
        if (this.containsClipEvents()) {
            if (this.clipEvents != null) {
                int n = fSCoder.context[2] > 5 ? 4 : 2;
                this.length += 2 + n;
                Iterator iterator = this.clipEvents.iterator();
                while (iterator.hasNext()) {
                    this.length += ((FSClipEvent)iterator.next()).length(fSCoder);
                }
                this.length += n;
            } else {
                this.length += this.encodedEvents.length;
            }
        }
        fSCoder.context[0] = 0;
        return this.length;
    }

    public void encode(FSCoder fSCoder) {
        super.encode(fSCoder);
        fSCoder.context[0] = 1;
        fSCoder.writeBits(this.containsClipEvents() ? 1 : 0, 1);
        fSCoder.writeBits(this.containsClippingDepth() ? 1 : 0, 1);
        fSCoder.writeBits(this.containsName() ? 1 : 0, 1);
        fSCoder.writeBits(this.containsRatio() ? 1 : 0, 1);
        fSCoder.writeBits(this.containsColorTransform(fSCoder) ? 1 : 0, 1);
        fSCoder.writeBits(this.containsTransform() ? 1 : 0, 1);
        fSCoder.writeBits(this.place, 2);
        fSCoder.writeWord(this.layer, 2);
        if (this.place == 2 || this.place == 3) {
            fSCoder.writeWord(this.identifier, 2);
        }
        if (this.containsTransform()) {
            this.transform.encode(fSCoder);
        }
        if (this.containsColorTransform(fSCoder)) {
            this.colorTransform.encode(fSCoder);
        }
        if (this.containsRatio()) {
            fSCoder.writeWord((int)(this.ratio * 65535.0f), 2);
        }
        if (this.containsName()) {
            fSCoder.writeString(this.name);
            fSCoder.writeWord(0, 1);
        }
        if (this.containsClippingDepth()) {
            fSCoder.writeWord(this.clippingDepth, 2);
        }
        if (this.containsClipEvents()) {
            if (this.clipEvents != null) {
                int n = fSCoder.context[2] > 5 ? 4 : 2;
                int n2 = 0;
                fSCoder.writeWord(0, 2);
                Iterator iterator = this.clipEvents.iterator();
                while (iterator.hasNext()) {
                    n2 |= ((FSClipEvent)iterator.next()).getEvent();
                }
                fSCoder.writeWord(n2, n);
                iterator = this.clipEvents.iterator();
                while (iterator.hasNext()) {
                    ((FSTransformObject)iterator.next()).encode(fSCoder);
                }
                fSCoder.writeWord(0, n);
            } else {
                fSCoder.writeBytes(this.encodedEvents);
            }
        }
        fSCoder.context[0] = 0;
        fSCoder.endObject(this.name());
    }

    public void decode(FSCoder fSCoder) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        super.decode(fSCoder);
        fSCoder.context[0] = 1;
        bl = fSCoder.readBits(1, false) != 0;
        bl2 = fSCoder.readBits(1, false) != 0;
        bl3 = fSCoder.readBits(1, false) != 0;
        bl4 = fSCoder.readBits(1, false) != 0;
        bl5 = fSCoder.readBits(1, false) != 0;
        bl6 = fSCoder.readBits(1, false) != 0;
        this.place = fSCoder.readBits(2, false);
        this.layer = fSCoder.readWord(2, false);
        if (this.place == 2 || this.place == 3) {
            this.identifier = fSCoder.readWord(2, false);
        }
        if (bl6) {
            this.transform = new FSCoordTransform(fSCoder);
        }
        if (bl5) {
            this.colorTransform = new FSColorTransform(fSCoder);
        }
        if (bl4) {
            this.ratio = (float)fSCoder.readWord(2, false) / 65535.0f;
        }
        if (bl3) {
            this.name = fSCoder.readString();
        }
        if (bl2) {
            this.clippingDepth = fSCoder.readWord(2, false);
        }
        if (bl) {
            int n = fSCoder.context[2] > 5 ? 4 : 2;
            this.clipEvents = new ArrayList();
            fSCoder.readWord(2, false);
            fSCoder.readWord(n, false);
            while (fSCoder.scanWord(n, false) != 0) {
                this.clipEvents.add(new FSClipEvent(fSCoder));
            }
            fSCoder.readWord(n, false);
        }
        fSCoder.context[0] = 0;
        fSCoder.endObject(this.name());
    }

    private boolean containsTransform() {
        return this.transform != null;
    }

    private boolean containsColorTransform(FSCoder fSCoder) {
        return this.colorTransform != null;
    }

    private boolean containsClipEvents() {
        return this.clipEvents != null && this.clipEvents.size() > 0 || this.encodedEvents != null;
    }

    private boolean containsClippingDepth() {
        return this.clippingDepth > 0;
    }

    private boolean containsName() {
        return this.name != null && this.name.length() > 0;
    }

    private boolean containsRatio() {
        return (double)this.ratio >= 0.0;
    }
}

