/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util;

import com.flagstone.transform.FSBitmapFill;
import com.flagstone.transform.FSBounds;
import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSCoordTransform;
import com.flagstone.transform.FSDefineImage;
import com.flagstone.transform.FSDefineImage2;
import com.flagstone.transform.FSDefineJPEGImage2;
import com.flagstone.transform.FSDefineObject;
import com.flagstone.transform.FSDefineShape3;
import com.flagstone.transform.FSLine;
import com.flagstone.transform.FSShape;
import com.flagstone.transform.FSShapeStyle;
import com.flagstone.transform.FSSolidLine;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class FSImageConstructor {
    public static final int JPEG = 0;
    public static final int IDX8 = 1;
    public static final int IDXA = 2;
    public static final int RGB5 = 3;
    public static final int RGB8 = 4;
    public static final int RGBA = 5;
    private static final int[] monochrome = new int[]{0, 255};
    private static final int[] greyscale2 = new int[]{0, 85, 170, 255};
    private static final int[] greyscale4 = new int[]{0, 17, 34, 51, 68, 85, 102, 119, 136, 153, 170, 187, 204, 221, 238, 255};
    private static final int[] bmpSignature = new int[]{66, 77};
    private final int BI_RGB = 0;
    private final int BI_RLE8 = 1;
    private final int BI_RLE4 = 2;
    private final int BI_BITFIELDS = 3;
    private static final int[] pngSignature = new int[]{137, 80, 78, 71, 13, 10, 26, 10};
    private static final int IHDR = 1229472850;
    private static final int PLTE = 1347179589;
    private static final int IDAT = 1229209940;
    private static final int IEND = 1229278788;
    private static final int tRNS = 1951551059;
    private static final int GREYSCALE = 0;
    private static final int TRUE_COLOUR = 2;
    private static final int INDEXED_COLOUR = 3;
    private static final int ALPHA_GREYSCALE = 4;
    private static final int ALPHA_TRUECOLOUR = 6;
    private static final int NO_FILTER = 0;
    private static final int SUB_FILTER = 1;
    private static final int UP_FILTER = 2;
    private static final int AVG_FILTER = 3;
    private static final int PAETH_FILTER = 4;
    private static final int[] startRow = new int[]{0, 0, 4, 0, 2, 0, 1};
    private static final int[] startColumn = new int[]{0, 4, 0, 2, 0, 1, 0};
    private static final int[] rowIncrement = new int[]{8, 8, 8, 4, 4, 2, 2};
    private static final int[] columnIncrement = new int[]{8, 8, 4, 4, 2, 2, 1};
    private static final int BIT_DEPTH = 0;
    private static final int COLOUR_COMPONENTS = 1;
    private static final int COMPRESSION_METHOD = 2;
    private static final int RED_MASK = 4;
    private static final int GREEN_MASK = 5;
    private static final int BLUE_MASK = 6;
    private static final int COLOUR_TYPE = 4;
    private static final int FILTER_METHOD = 5;
    private static final int INTERLACE_METHOD = 6;
    private static final int TRANSPARENT_GREY = 7;
    private static final int TRANSPARENT_RED = 8;
    private static final int TRANSPARENT_GREEN = 9;
    private static final int TRANSPARENT_BLUE = 10;
    private int format = 0;
    private int width = 0;
    private int height = 0;
    private byte[][] colourTable = null;
    private byte[][] indexedImage = null;
    private byte[][][] colorImage = null;
    private byte[] jpegImage = null;
    private int[] attributes = new int[16];
    private byte[] chunkData = new byte[0];

    public FSImageConstructor() {
    }

    public FSImageConstructor(String string) throws IOException, DataFormatException {
        this.setImage(this.dataFromFile(string));
    }

    public FSImageConstructor(byte[] byArray) throws DataFormatException {
        this.setImage(byArray);
    }

    public void setImageFromFile(String string) throws IOException, DataFormatException {
        this.setImage(this.dataFromFile(string));
    }

    public void setImage(byte[] byArray) throws DataFormatException {
        int n = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
        this.format = 0;
        this.width = 0;
        this.height = 0;
        this.attributes[0] = 0;
        this.attributes[1] = 0;
        this.attributes[4] = 0;
        this.attributes[2] = 0;
        this.attributes[5] = 0;
        this.attributes[6] = 0;
        this.chunkData = new byte[0];
        this.attributes[7] = -1;
        this.attributes[8] = -1;
        this.attributes[9] = -1;
        this.attributes[10] = -1;
        this.attributes[4] = 0;
        this.attributes[5] = 0;
        this.attributes[6] = 0;
        this.colourTable = null;
        this.indexedImage = null;
        this.colorImage = null;
        this.jpegImage = null;
        switch (n) {
            case 65496: {
                this.decodeJPEG(byArray);
                break;
            }
            case 16973: {
                this.decodeBMP(byArray);
                break;
            }
            case 35152: {
                this.decodePNG(byArray);
                break;
            }
            default: {
                throw new DataFormatException("Unsupported image format");
            }
        }
    }

    public int getFormat() {
        return this.format;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[][] getColorTable() {
        byte[][] byArray = null;
        if (this.colourTable != null) {
            byArray = new byte[this.colourTable.length][4];
            for (int i = 0; i < this.colourTable.length; ++i) {
                for (int j = 0; j < 4; ++j) {
                    byArray[i][j] = this.colourTable[i][j];
                }
            }
        }
        return byArray;
    }

    public byte[][] getIndexedImage() {
        byte[][] byArray = null;
        if (this.indexedImage != null) {
            byArray = new byte[this.height][this.width];
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    byArray[i][j] = this.indexedImage[i][j];
                }
            }
        }
        return byArray;
    }

    public byte[][][] getColorImage() {
        byte[][][] byArray = null;
        if (this.colorImage != null) {
            byArray = new byte[this.height][this.width][4];
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    byArray[i][j][0] = this.colorImage[i][j][0];
                    byArray[i][j][1] = this.colorImage[i][j][1];
                    byArray[i][j][2] = this.colorImage[i][j][2];
                    byArray[i][j][3] = this.colorImage[i][j][3];
                }
            }
        }
        return byArray;
    }

    public byte[] getJPEGImage() {
        byte[] byArray = null;
        if (this.jpegImage != null) {
            byArray = new byte[this.jpegImage.length];
            System.arraycopy(this.jpegImage, 0, byArray, 0, this.jpegImage.length);
        }
        return byArray;
    }

    public void setIndexedImage(int n, int n2, int n3, byte[][] byArray, byte[][] byArray2) {
        int n4;
        int n5;
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("Indexed images must have a format of IDX8 or IDXA");
        }
        this.format = n;
        this.width = n2;
        this.height = n3;
        this.colourTable = new byte[byArray.length][4];
        for (n5 = 0; n5 < byArray.length; ++n5) {
            for (n4 = 0; n4 < 4; ++n4) {
                this.colourTable[n5][n4] = byArray[n5][n4];
            }
        }
        this.indexedImage = new byte[this.height][this.width];
        for (n5 = 0; n5 < this.height; ++n5) {
            for (n4 = 0; n4 < this.width; ++n4) {
                this.indexedImage[n5][n4] = byArray2[n5][n4];
            }
        }
    }

    public void setColorImage(int n, int n2, int n3, byte[][][] byArray) {
        if (n != 3 && n != 4 && n != 5) {
            throw new IllegalArgumentException("True colour images must has a format of RGB5, RGB8 or RGBA");
        }
        this.format = n;
        this.width = n2;
        this.height = n3;
        this.colorImage = new byte[this.height][this.width][4];
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.colorImage[i][j][0] = byArray[i][j][0];
                this.colorImage[i][j][1] = byArray[i][j][1];
                this.colorImage[i][j][2] = byArray[i][j][2];
                this.colorImage[i][j][3] = byArray[i][j][3];
            }
        }
    }

    public void setJPEGImage(int n, int n2, byte[] byArray) {
        this.format = 0;
        this.width = n;
        this.height = n2;
        this.jpegImage = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.jpegImage, 0, byArray.length);
    }

    public FSDefineObject defineImage(int n) {
        FSDefineObject fSDefineObject = null;
        switch (this.format) {
            case 0: {
                fSDefineObject = new FSDefineJPEGImage2(n, this.jpegImage);
                break;
            }
            case 1: {
                fSDefineObject = new FSDefineImage(n, this.width, this.height, this.colourTable.length, this.zip(this.getImage(), this.colourTable, false));
                break;
            }
            case 2: {
                fSDefineObject = new FSDefineImage2(n, this.width, this.height, this.colourTable.length, this.zip(this.getImage(), this.colourTable, true));
                break;
            }
            case 3: {
                fSDefineObject = new FSDefineImage(n, this.width, this.height, this.zip(this.getImage()), 16);
                break;
            }
            case 4: {
                fSDefineObject = new FSDefineImage(n, this.width, this.height, this.zip(this.getImage()), 24);
                break;
            }
            case 5: {
                fSDefineObject = new FSDefineImage2(n, this.width, this.height, this.zip(this.getImage()));
            }
        }
        return fSDefineObject;
    }

    private byte[] getImage() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        byte[] byArray = null;
        switch (this.format) {
            case 1: 
            case 2: {
                n4 = this.width + 3 & 0xFFFFFFFC;
                byArray = new byte[n4 * this.height];
                for (n = 0; n < this.height; ++n) {
                    for (n2 = 0; n2 < this.width; ++n2) {
                        byArray[n3++] = this.indexedImage[n][n2];
                    }
                    while (n2 < n4) {
                        byArray[n3++] = 0;
                        ++n2;
                    }
                }
                break;
            }
            case 3: {
                n4 = this.width + (this.width & 1);
                byArray = new byte[n4 * this.height * 2];
                for (n = 0; n < this.height; ++n) {
                    for (n2 = 0; n2 < this.width; ++n2) {
                        int n5 = (this.colorImage[n][n2][0] & 0xF8) << 7;
                        int n6 = (this.colorImage[n][n2][1] & 0xF8) << 2;
                        int n7 = (this.colorImage[n][n2][2] & 0xF8) >> 3;
                        int n8 = (n5 | n6 | n7) & Short.MAX_VALUE;
                        byArray[n3++] = (byte)(n8 >> 8);
                        byArray[n3++] = (byte)n8;
                    }
                    while (n2 < n4) {
                        byArray[n3++] = 0;
                        byArray[n3++] = 0;
                        ++n2;
                    }
                }
                break;
            }
            case 4: {
                byArray = new byte[this.width * this.height * 4];
                for (n = 0; n < this.height; ++n) {
                    for (n2 = 0; n2 < this.width; ++n2) {
                        byArray[n3++] = -1;
                        byArray[n3++] = this.colorImage[n][n2][0];
                        byArray[n3++] = this.colorImage[n][n2][1];
                        byArray[n3++] = this.colorImage[n][n2][2];
                    }
                }
                break;
            }
            case 5: {
                byArray = new byte[this.width * this.height * 4];
                for (n = 0; n < this.height; ++n) {
                    for (n2 = 0; n2 < this.width; ++n2) {
                        int n9 = this.colorImage[n][n2][3] & 0xFF;
                        int n10 = (this.colorImage[n][n2][0] & 0xFF) * n9 / 255;
                        int n11 = (this.colorImage[n][n2][1] & 0xFF) * n9 / 255;
                        int n12 = (this.colorImage[n][n2][2] & 0xFF) * n9 / 255;
                        byArray[n3++] = (byte)n9;
                        byArray[n3++] = (byte)n10;
                        byArray[n3++] = (byte)n11;
                        byArray[n3++] = (byte)n12;
                    }
                }
                break;
            }
        }
        return byArray;
    }

    public FSDefineShape3 defineEnclosingShape(int n, int n2, int n3, int n4, FSSolidLine fSSolidLine) {
        int n5 = 0;
        if (fSSolidLine != null) {
            n5 = fSSolidLine.getWidth() / 2;
        }
        FSBounds fSBounds = new FSBounds(-n3 * 20 - n5, -n4 * 20 - n5, (this.width - n3) * 20 + n5, (this.height - n4) * 20 + n5);
        FSShape fSShape = new FSShape();
        fSShape.add(new FSShapeStyle(fSSolidLine != null ? 1 : 0, 1, 0, -n3 * 20, -n4 * 20));
        fSShape.add(new FSLine(this.width * 20, 0));
        fSShape.add(new FSLine(0, this.height * 20));
        fSShape.add(new FSLine(-this.width * 20, 0));
        fSShape.add(new FSLine(0, -this.height * 20));
        FSDefineShape3 fSDefineShape3 = new FSDefineShape3(n, fSBounds, new ArrayList(), new ArrayList(), fSShape);
        FSCoordTransform fSCoordTransform = new FSCoordTransform(-n3 * 20, -n4 * 20, 20.0, 20.0);
        if (fSSolidLine != null) {
            fSDefineShape3.add(fSSolidLine);
        }
        fSDefineShape3.add(new FSBitmapFill(65, n2, fSCoordTransform));
        return fSDefineShape3;
    }

    private boolean jpegInfo() {
        FSCoder fSCoder = new FSCoder(1, this.jpegImage);
        if (fSCoder.readWord(2, false) != 65496) {
            return false;
        }
        while (true) {
            int n = fSCoder.readWord(2, false);
            int n2 = fSCoder.readWord(2, false);
            if ((n & 0xFF00) != 65280) {
                return false;
            }
            if (n >= 65472 && n <= 65487 && n != 65476 && n != 65480) {
                fSCoder.readWord(1, false);
                this.height = fSCoder.readWord(2, false);
                this.width = fSCoder.readWord(2, false);
                return true;
            }
            fSCoder.adjustPointer(n2 - 2 << 3);
        }
    }

    private void decodeJPEG(byte[] byArray) throws DataFormatException {
        this.format = 0;
        this.jpegImage = byArray;
        if (!this.jpegInfo()) {
            throw new DataFormatException();
        }
    }

    private void decodeBMP(byte[] byArray) throws DataFormatException {
        int n;
        FSCoder fSCoder = new FSCoder(0, byArray);
        for (n = 0; n < 2; ++n) {
            if (fSCoder.readWord(1, false) == bmpSignature[n]) continue;
            throw new DataFormatException("Not a valid BMP file");
        }
        fSCoder.readWord(4, false);
        fSCoder.readWord(4, false);
        n = fSCoder.readWord(4, false);
        int n2 = fSCoder.readWord(4, false);
        int n3 = 0;
        int n4 = 0;
        switch (n2) {
            case 12: {
                this.width = fSCoder.readWord(2, false);
                this.height = fSCoder.readWord(2, false);
                fSCoder.readWord(2, false);
                n3 = fSCoder.readWord(2, false);
                break;
            }
            case 40: {
                this.width = fSCoder.readWord(4, false);
                this.height = fSCoder.readWord(4, false);
                fSCoder.readWord(2, false);
                n3 = fSCoder.readWord(2, false);
                this.attributes[2] = fSCoder.readWord(4, false);
                fSCoder.readWord(4, false);
                fSCoder.readWord(4, false);
                fSCoder.readWord(4, false);
                n4 = fSCoder.readWord(4, false);
                fSCoder.readWord(4, false);
                break;
            }
        }
        if (this.attributes[2] == 3) {
            this.attributes[4] = fSCoder.readWord(4, false);
            this.attributes[5] = fSCoder.readWord(4, false);
            this.attributes[6] = fSCoder.readWord(4, false);
        }
        switch (n3) {
            case 1: {
                this.format = 1;
                this.attributes[0] = 1;
                this.attributes[1] = 1;
                break;
            }
            case 2: {
                this.format = 1;
                this.attributes[0] = 2;
                this.attributes[1] = 1;
                break;
            }
            case 4: {
                this.format = 1;
                this.attributes[0] = 4;
                this.attributes[1] = 1;
                break;
            }
            case 8: {
                this.format = 1;
                this.attributes[0] = 8;
                this.attributes[1] = 1;
                break;
            }
            case 16: {
                this.format = 3;
                this.attributes[0] = 5;
                this.attributes[1] = 3;
                break;
            }
            case 24: {
                this.format = 4;
                this.attributes[0] = 8;
                this.attributes[1] = 3;
                break;
            }
            case 32: {
                this.format = 5;
                this.attributes[0] = 8;
                this.attributes[1] = 4;
            }
        }
        if (this.format == 1) {
            n4 = 1 << n3;
            this.colourTable = new byte[n4][4];
            this.indexedImage = new byte[this.height][this.width];
            if (n2 == 12) {
                for (int i = 0; i < n4; ++i) {
                    this.colourTable[i][3] = -1;
                    this.colourTable[i][2] = (byte)fSCoder.readWord(1, false);
                    this.colourTable[i][1] = (byte)fSCoder.readWord(1, false);
                    this.colourTable[i][0] = (byte)fSCoder.readWord(1, false);
                }
            } else {
                for (int i = 0; i < n4; ++i) {
                    this.colourTable[i][0] = (byte)fSCoder.readWord(1, false);
                    this.colourTable[i][1] = (byte)fSCoder.readWord(1, false);
                    this.colourTable[i][2] = (byte)fSCoder.readWord(1, false);
                    this.colourTable[i][3] = (byte)(fSCoder.readWord(1, false) | 0xFF);
                }
            }
            fSCoder.setPointer(n << 3);
            switch (this.attributes[2]) {
                case 0: {
                    this.decodeIDX8(fSCoder);
                    break;
                }
                case 1: {
                    this.decodeRLE8(fSCoder);
                    break;
                }
                case 2: {
                    this.decodeRLE4(fSCoder);
                }
            }
        } else {
            this.colorImage = new byte[this.height][this.width][4];
            fSCoder.setPointer(n << 3);
            switch (this.format) {
                case 3: {
                    this.decodeRGB5(fSCoder);
                    break;
                }
                case 4: {
                    this.decodeRGB8(fSCoder);
                    break;
                }
                case 5: {
                    this.decodeRGBA(fSCoder);
                }
            }
        }
    }

    private void decodeIDX8(FSCoder fSCoder) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (n = this.height - 1; n > 0; --n) {
            n3 = 0;
            for (n2 = 0; n2 < this.width; ++n2) {
                this.indexedImage[n][n2] = (byte)fSCoder.readBits(this.attributes[0], false);
                n3 += this.attributes[0];
            }
            if (n3 % 32 <= 0) continue;
            fSCoder.adjustPointer(32 - n3 % 32);
        }
    }

    private void decodeRLE4(FSCoder fSCoder) {
        int n = this.height - 1;
        int n2 = 0;
        boolean bl = true;
        block5: while (bl) {
            int n3;
            int n4;
            int n5 = fSCoder.readWord(1, false);
            if (n5 == 0) {
                n4 = fSCoder.readWord(1, false);
                switch (n4) {
                    case 0: {
                        n2 = 0;
                        --n;
                        break;
                    }
                    case 1: {
                        bl = false;
                        break;
                    }
                    case 2: {
                        n2 += fSCoder.readWord(2, false);
                        n -= fSCoder.readWord(2, false);
                    }
                    default: {
                        for (n3 = 0; n3 < n4; n3 += 2) {
                            this.indexedImage[n][n2++] = (byte)fSCoder.readBits(4, false);
                            this.indexedImage[n][n2++] = (byte)fSCoder.readBits(4, false);
                        }
                        if ((n4 & 2) != 2) continue block5;
                        fSCoder.readWord(1, false);
                        break;
                    }
                }
                continue;
            }
            n4 = (byte)fSCoder.readBits(4, false);
            n3 = (byte)fSCoder.readBits(4, false);
            for (int i = 0; i < n5 && n2 < this.width; ++i) {
                this.indexedImage[n][n2++] = i % 2 > 0 ? n3 : n4;
            }
        }
    }

    private void decodeRLE8(FSCoder fSCoder) {
        int n = this.height - 1;
        int n2 = 0;
        boolean bl = true;
        block5: while (bl) {
            int n3;
            int n4;
            int n5 = fSCoder.readWord(1, false);
            if (n5 == 0) {
                n4 = fSCoder.readWord(1, false);
                switch (n4) {
                    case 0: {
                        n2 = 0;
                        --n;
                        break;
                    }
                    case 1: {
                        bl = false;
                        break;
                    }
                    case 2: {
                        n2 += fSCoder.readWord(2, false);
                        n -= fSCoder.readWord(2, false);
                    }
                    default: {
                        for (n3 = 0; n3 < n4; ++n3) {
                            this.indexedImage[n][n2++] = (byte)fSCoder.readWord(1, false);
                        }
                        if ((n4 & 1) != 1) continue block5;
                        fSCoder.readWord(1, false);
                        break;
                    }
                }
                continue;
            }
            n4 = (byte)fSCoder.readWord(1, false);
            for (n3 = 0; n3 < n5; ++n3) {
                this.indexedImage[n][n2++] = n4;
            }
        }
    }

    private void decodeRGB5(FSCoder fSCoder) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (this.attributes[2] == 0) {
            for (n = this.height - 1; n > 0; --n) {
                n3 = 0;
                for (n2 = 0; n2 < this.width; ++n2) {
                    int n4 = fSCoder.readWord(2, false) & 0xFFFF;
                    this.colorImage[n][n2][0] = (byte)((n4 & 0x7C00) >> 7);
                    this.colorImage[n][n2][1] = (byte)((n4 & 0x3E0) >> 2);
                    this.colorImage[n][n2][2] = (byte)((n4 & 0x1F) << 3);
                    this.colorImage[n][n2][3] = -1;
                    n3 += 16;
                }
                if (n3 % 32 <= 0) continue;
                fSCoder.adjustPointer(32 - n3 % 32);
            }
        } else {
            for (n = this.height - 1; n > 0; --n) {
                n3 = 0;
                for (n2 = 0; n2 < this.width; ++n2) {
                    int n5 = fSCoder.readWord(2, false) & 0xFFFF;
                    if (this.attributes[4] == 31744 && this.attributes[5] == 992 && this.attributes[6] == 31) {
                        this.colorImage[n][n2][0] = (byte)((n5 & 0x7C00) >> 7);
                        this.colorImage[n][n2][1] = (byte)((n5 & 0x3E0) >> 2);
                        this.colorImage[n][n2][2] = (byte)((n5 & 0x1F) << 3);
                        this.colorImage[n][n2][3] = -1;
                    } else if (this.attributes[4] == 63488 && this.attributes[5] == 2016 && this.attributes[6] == 31) {
                        this.colorImage[n][n2][0] = (byte)((n5 & 0xF800) >> 8);
                        this.colorImage[n][n2][1] = (byte)((n5 & 0x7E0) >> 3);
                        this.colorImage[n][n2][2] = (byte)((n5 & 0x1F) << 3);
                        this.colorImage[n][n2][3] = -1;
                    }
                    n3 += 16;
                }
                if (n3 % 32 <= 0) continue;
                fSCoder.adjustPointer(32 - n3 % 32);
            }
        }
    }

    private void decodeRGB8(FSCoder fSCoder) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (n = this.height - 1; n > 0; --n) {
            n3 = 0;
            for (n2 = 0; n2 < this.width; ++n2) {
                this.colorImage[n][n2][0] = (byte)fSCoder.readBits(this.attributes[0], false);
                this.colorImage[n][n2][1] = (byte)fSCoder.readBits(this.attributes[0], false);
                this.colorImage[n][n2][2] = (byte)fSCoder.readBits(this.attributes[0], false);
                this.colorImage[n][n2][3] = -1;
                n3 += 24;
            }
            if (n3 % 32 <= 0) continue;
            fSCoder.adjustPointer(32 - n3 % 32);
        }
    }

    private void decodeRGBA(FSCoder fSCoder) {
        int n = 0;
        int n2 = 0;
        for (n = this.height - 1; n > 0; --n) {
            for (n2 = 0; n2 < this.width; ++n2) {
                this.colorImage[n][n2][2] = (byte)fSCoder.readWord(1, false);
                this.colorImage[n][n2][1] = (byte)fSCoder.readWord(1, false);
                this.colorImage[n][n2][0] = (byte)fSCoder.readWord(1, false);
                this.colorImage[n][n2][3] = (byte)fSCoder.readWord(1, false);
                this.colorImage[n][n2][3] = -1;
            }
        }
    }

    private void decodePNG(byte[] byArray) throws DataFormatException {
        int n;
        FSCoder fSCoder = new FSCoder(1, byArray);
        int n2 = 0;
        int n3 = 0;
        boolean bl = true;
        for (n = 0; n < 8; ++n) {
            if (fSCoder.readWord(1, false) == pngSignature[n]) continue;
            throw new DataFormatException("Not a valid PNG file");
        }
        while (bl) {
            n2 = fSCoder.readWord(4, false);
            n3 = fSCoder.readWord(4, false);
            n = fSCoder.getPointer();
            int n4 = n + (n2 + 4 << 3);
            switch (n3) {
                case 1229472850: {
                    this.decodeIHDR(fSCoder, n2);
                    break;
                }
                case 1347179589: {
                    this.decodePLTE(fSCoder, n2);
                    break;
                }
                case 1951551059: {
                    this.decodeTRNS(fSCoder, n2);
                    break;
                }
                case 1229209940: {
                    this.decodeIDAT(fSCoder, n2);
                    break;
                }
                case 1229278788: {
                    bl = false;
                    fSCoder.adjustPointer(32);
                    break;
                }
                default: {
                    fSCoder.adjustPointer(n2 + 4 << 3);
                }
            }
            n2 += 4;
            fSCoder.setPointer(n4);
            if (!fSCoder.eof()) continue;
            bl = false;
        }
        this.decodeImage();
    }

    private void decodeIHDR(FSCoder fSCoder, int n) {
        this.width = fSCoder.readWord(4, false);
        this.height = fSCoder.readWord(4, false);
        this.attributes[0] = fSCoder.readWord(1, false);
        this.attributes[4] = fSCoder.readWord(1, false);
        this.attributes[2] = fSCoder.readWord(1, false);
        this.attributes[5] = fSCoder.readWord(1, false);
        this.attributes[6] = fSCoder.readWord(1, false);
        fSCoder.readWord(4, false);
        switch (this.attributes[4]) {
            case 0: {
                this.format = this.attributes[7] != -1 ? 5 : 4;
                this.attributes[1] = 1;
                break;
            }
            case 2: {
                this.format = this.attributes[8] != -1 ? 5 : 4;
                this.attributes[1] = 3;
                break;
            }
            case 3: {
                this.format = 1;
                this.attributes[1] = 1;
                break;
            }
            case 4: {
                this.format = 5;
                this.attributes[1] = 2;
                break;
            }
            case 6: {
                this.format = 5;
                this.attributes[1] = 4;
            }
        }
    }

    private void decodePLTE(FSCoder fSCoder, int n) {
        if (this.attributes[4] == 3) {
            int n2 = n / 3;
            this.colourTable = new byte[n2][4];
            for (int i = 0; i < n2; ++i) {
                this.colourTable[i][3] = -1;
                this.colourTable[i][2] = (byte)fSCoder.readWord(1, false);
                this.colourTable[i][1] = (byte)fSCoder.readWord(1, false);
                this.colourTable[i][0] = (byte)fSCoder.readWord(1, false);
            }
        } else {
            fSCoder.adjustPointer(n << 3);
        }
        fSCoder.readWord(4, false);
    }

    private void decodeTRNS(FSCoder fSCoder, int n) {
        switch (this.attributes[4]) {
            case 0: {
                this.attributes[7] = fSCoder.readWord(2, false);
                break;
            }
            case 2: {
                this.attributes[8] = fSCoder.readWord(2, false);
                this.attributes[9] = fSCoder.readWord(2, false);
                this.attributes[10] = fSCoder.readWord(2, false);
                break;
            }
            case 3: {
                this.format = 2;
                for (int i = 0; i < n; ++i) {
                    this.colourTable[i][3] = (byte)fSCoder.readWord(1, false);
                    if (this.colourTable[i][3] != 0) continue;
                    this.colourTable[i][0] = 0;
                    this.colourTable[i][1] = 0;
                    this.colourTable[i][2] = 0;
                }
                break;
            }
        }
        fSCoder.readWord(4, false);
    }

    private void decodeIDAT(FSCoder fSCoder, int n) {
        int n2 = this.chunkData.length;
        int n3 = n2 + n;
        byte[] byArray = new byte[n3];
        System.arraycopy(this.chunkData, 0, byArray, 0, n2);
        for (int i = n2; i < n3; ++i) {
            byArray[i] = (byte)fSCoder.readWord(1, false);
        }
        this.chunkData = byArray;
        fSCoder.readWord(4, false);
    }

    private void decodeImage() throws DataFormatException {
        int n;
        if (this.format == 4 && this.attributes[0] <= 5) {
            this.format = 3;
        }
        if (this.format == 3 || this.format == 4 || this.format == 5) {
            this.colorImage = new byte[this.height][this.width][4];
        }
        if (this.format == 1 || this.format == 2) {
            this.indexedImage = new byte[this.height][this.width];
        }
        byte[] byArray = this.unzip(this.chunkData);
        int n2 = this.attributes[0] * this.attributes[1];
        int n3 = this.width * n2;
        int n4 = n3 % 8 > 0 ? n3 / 8 + 1 : n3 / 8;
        int n5 = n2 < 8 ? 1 : n2 / 8;
        byte[] byArray2 = new byte[n4];
        byte[] byArray3 = new byte[n4];
        for (n = 0; n < n4; ++n) {
            byArray3[n] = 0;
        }
        n = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        byte by = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = this.attributes[6] == 1 ? 7 : 1;
        int n16 = 0;
        int n17 = 0;
        for (int i = 0; i < n15; ++i) {
            n = this.attributes[6] == 1 ? startRow[i] : 0;
            n6 = this.attributes[6] == 1 ? rowIncrement[i] : 1;
            n7 = this.attributes[6] == 1 ? startColumn[i] : 0;
            n8 = this.attributes[6] == 1 ? columnIncrement[i] : 1;
            for (n11 = n; n11 < this.height && n9 < byArray.length; n11 += n6) {
                n12 = n7;
                n10 = 0;
                n13 = 0;
                while (n12 < this.width) {
                    ++n10;
                    n12 += n8;
                    n13 += n2;
                }
                n14 = n13 % 8 > 0 ? n13 / 8 + 1 : n13 / 8;
                by = byArray[n9++];
                int n18 = 0;
                while (n18 < n14) {
                    byArray2[n18] = n9 < byArray.length ? byArray[n9] : byArray3[n18];
                    ++n18;
                    ++n9;
                }
                switch (by) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        n16 = n5;
                        n17 = 0;
                        while (n16 < n14) {
                            byArray2[n16] = (byte)(byArray2[n16] + byArray2[n17]);
                            ++n16;
                            ++n17;
                        }
                        break;
                    }
                    case 2: {
                        for (n16 = 0; n16 < n14; ++n16) {
                            byArray2[n16] = (byte)(byArray2[n16] + byArray3[n16]);
                        }
                        break;
                    }
                    case 3: {
                        for (n16 = 0; n16 < n5; ++n16) {
                            byArray2[n16] = (byte)(byArray2[n16] + (0 + (0xFF & byArray3[n16])) / 2);
                        }
                        n16 = n5;
                        n17 = 0;
                        while (n16 < n14) {
                            byArray2[n16] = (byte)(byArray2[n16] + ((0xFF & byArray2[n17]) + (0xFF & byArray3[n16])) / 2);
                            ++n16;
                            ++n17;
                        }
                        break;
                    }
                    case 4: {
                        for (n16 = 0; n16 < n5; ++n16) {
                            byArray2[n16] = (byte)(byArray2[n16] + this.Paeth((byte)0, byArray3[n16], (byte)0));
                        }
                        n16 = n5;
                        n17 = 0;
                        while (n16 < n14) {
                            byArray2[n16] = (byte)(byArray2[n16] + this.Paeth(byArray2[n17], byArray3[n16], byArray3[n17]));
                            ++n16;
                            ++n17;
                        }
                        break;
                    }
                }
                System.arraycopy(byArray2, 0, byArray3, 0, n14);
                FSCoder fSCoder = new FSCoder(1, byArray2);
                block25: for (n12 = n7; n12 < this.width; n12 += n8) {
                    switch (this.attributes[4]) {
                        case 0: {
                            this.decodeGreyscale(fSCoder, n11, n12);
                            continue block25;
                        }
                        case 2: {
                            this.decodeTrueColour(fSCoder, n11, n12);
                            continue block25;
                        }
                        case 3: {
                            this.decodeIndexedColour(fSCoder, n11, n12);
                            continue block25;
                        }
                        case 4: {
                            this.decodeAlphaGreyscale(fSCoder, n11, n12);
                            continue block25;
                        }
                        case 6: {
                            this.decodeAlphaTrueColour(fSCoder, n11, n12);
                        }
                    }
                }
            }
        }
    }

    private int Paeth(byte by, byte by2, byte by3) {
        int n;
        int n2;
        int n3 = 0xFF & by;
        int n4 = 0xFF & by2;
        int n5 = 0xFF & by3;
        int n6 = n3 + n4 - n5;
        int n7 = n6 - n3;
        if (n7 < 0) {
            n7 = -n7;
        }
        if ((n2 = n6 - n4) < 0) {
            n2 = -n2;
        }
        if ((n = n6 - n5) < 0) {
            n = -n;
        }
        if (n7 <= n2 && n7 <= n) {
            return n3;
        }
        if (n2 <= n) {
            return n4;
        }
        return n5;
    }

    private void decodeGreyscale(FSCoder fSCoder, int n, int n2) {
        int n3 = 0;
        byte by = 0;
        switch (this.attributes[0]) {
            case 1: {
                n3 = fSCoder.readBits(1, false);
                by = (byte)monochrome[n3];
                break;
            }
            case 2: {
                n3 = fSCoder.readBits(2, false);
                by = (byte)greyscale2[n3];
                break;
            }
            case 4: {
                n3 = fSCoder.readBits(4, false);
                by = (byte)greyscale4[n3];
                break;
            }
            case 8: {
                n3 = fSCoder.readWord(1, false);
                by = (byte)n3;
                break;
            }
            case 16: {
                n3 = fSCoder.readWord(2, false);
                by = (byte)(n3 >> 8);
            }
        }
        this.colorImage[n][n2][0] = by;
        this.colorImage[n][n2][1] = by;
        this.colorImage[n][n2][2] = by;
        this.colorImage[n][n2][3] = (byte)this.attributes[7];
    }

    private void decodeTrueColour(FSCoder fSCoder, int n, int n2) {
        int n3 = 0;
        byte by = 0;
        for (int i = 0; i < this.attributes[1]; ++i) {
            switch (this.attributes[0]) {
                case 8: {
                    n3 = fSCoder.readWord(1, false);
                    by = (byte)n3;
                    break;
                }
                case 16: {
                    n3 = fSCoder.readWord(2, false);
                    by = (byte)(n3 >> 8);
                }
            }
            this.colorImage[n][n2][i] = by;
        }
        this.colorImage[n][n2][3] = (byte)this.attributes[8];
    }

    private void decodeIndexedColour(FSCoder fSCoder, int n, int n2) {
        int n3 = 0;
        switch (this.attributes[0]) {
            case 1: {
                n3 = fSCoder.readBits(1, false);
                break;
            }
            case 2: {
                n3 = fSCoder.readBits(2, false);
                break;
            }
            case 4: {
                n3 = fSCoder.readBits(4, false);
                break;
            }
            case 8: {
                n3 = fSCoder.readWord(1, false);
                break;
            }
            case 16: {
                n3 = fSCoder.readWord(2, false);
            }
        }
        this.indexedImage[n][n2] = (byte)n3;
    }

    private void decodeAlphaGreyscale(FSCoder fSCoder, int n, int n2) {
        int n3 = 0;
        byte by = 0;
        int n4 = 0;
        switch (this.attributes[0]) {
            case 1: {
                n3 = fSCoder.readBits(1, false);
                by = (byte)monochrome[n3];
                n4 = fSCoder.readBits(1, false);
                break;
            }
            case 2: {
                n3 = fSCoder.readBits(2, false);
                by = (byte)greyscale2[n3];
                n4 = fSCoder.readBits(2, false);
                break;
            }
            case 4: {
                n3 = fSCoder.readBits(4, false);
                by = (byte)greyscale4[n3];
                n4 = fSCoder.readBits(4, false);
                break;
            }
            case 8: {
                n3 = fSCoder.readWord(1, false);
                by = (byte)n3;
                n4 = fSCoder.readWord(1, false);
                break;
            }
            case 16: {
                n3 = fSCoder.readWord(2, false);
                by = (byte)(n3 >> 8);
                n4 = fSCoder.readWord(2, false) >> 8;
            }
        }
        this.colorImage[n][n2][0] = by;
        this.colorImage[n][n2][1] = by;
        this.colorImage[n][n2][2] = by;
        this.colorImage[n][n2][3] = (byte)n4;
    }

    private void decodeAlphaTrueColour(FSCoder fSCoder, int n, int n2) {
        int n3 = 0;
        byte by = 0;
        for (int i = 0; i < this.attributes[1]; ++i) {
            switch (this.attributes[0]) {
                case 8: {
                    n3 = fSCoder.readWord(1, false);
                    by = (byte)n3;
                    break;
                }
                case 16: {
                    n3 = fSCoder.readWord(2, false);
                    by = (byte)(n3 >> 8);
                }
            }
            this.colorImage[n][n2][i] = by;
        }
    }

    private byte[] dataFromFile(String string) throws FileNotFoundException, IOException {
        File file = new File(string);
        FileInputStream fileInputStream = null;
        byte[] byArray = new byte[(int)file.length()];
        fileInputStream = new FileInputStream(file);
        fileInputStream.read(byArray);
        fileInputStream.close();
        return byArray;
    }

    private byte[] unzip(byte[] byArray) throws DataFormatException {
        byte[] byArray2 = new byte[this.width * this.height * 8];
        int n = 0;
        Inflater inflater = new Inflater();
        inflater.setInput(byArray);
        n = inflater.inflate(byArray2);
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray2, 0, byArray3, 0, n);
        return byArray3;
    }

    private byte[] zip(byte[] byArray, byte[][] byArray2, boolean bl) {
        int n;
        int n2 = bl ? 4 : 3;
        byte[] byArray3 = new byte[byArray2.length * n2 + byArray.length];
        int n3 = 0;
        for (n = 0; n < byArray2.length; ++n) {
            byArray3[n3++] = byArray2[n][2];
            byArray3[n3++] = byArray2[n][1];
            byArray3[n3++] = byArray2[n][0];
            if (!bl) continue;
            byArray3[n3++] = byArray2[n][3];
        }
        for (n = 0; n < byArray.length; ++n) {
            byArray3[n3++] = byArray[n];
        }
        return this.zip(byArray3);
    }

    private byte[] zip(byte[] byArray) {
        Deflater deflater = new Deflater();
        deflater.setInput(byArray);
        deflater.finish();
        byte[] byArray2 = new byte[byArray.length];
        int n = deflater.deflate(byArray2);
        byte[] byArray3 = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray3[i] = byArray2[i];
        }
        return byArray3;
    }
}

