/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor;

import javax.servlet.http.HttpServletRequest;
import net.fckeditor.FCKeditorConfig;
import net.fckeditor.handlers.PropertiesLoader;
import net.fckeditor.tool.Compatibility;
import net.fckeditor.tool.Utils;
import net.fckeditor.tool.XHtmlTagTool;

public class FCKeditor {
    private FCKeditorConfig fckConfig = new FCKeditorConfig();
    private String instanceName;
    private HttpServletRequest request;
    private String value = "";
    private String toolbarSet = PropertiesLoader.getEditorToolbarSet();
    private String width = PropertiesLoader.getEditorWidth();
    private String height = PropertiesLoader.getEditorHeight();
    private String basePath = PropertiesLoader.getEditorBasePath();

    public FCKeditor(HttpServletRequest request, String instanceName, String width, String height, String toolbarSet, String value, String basePath) {
        this(request, instanceName);
        this.width = width;
        this.height = height;
        this.toolbarSet = toolbarSet;
        this.value = value;
        this.basePath = basePath;
    }

    public FCKeditor(HttpServletRequest request, String instanceName) {
        if (request == null) {
            throw new NullPointerException("the request cannot be null");
        }
        this.request = request;
        this.setInstanceName(instanceName);
    }

    public void setInstanceName(String instanceName) {
        if (Utils.isEmpty(instanceName)) {
            throw new IllegalArgumentException("instanceName cannot be empty");
        }
        if (!instanceName.matches("\\p{Alpha}[\\p{Alnum}:_.-]*")) {
            throw new IllegalArgumentException("instanceName must be a valid XHTML id containing only \"\\p{Alpha}[\\p{Alnum}:_.-]*\"");
        }
        this.instanceName = instanceName;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setToolbarSet(String toolbarSet) {
        this.toolbarSet = toolbarSet;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    @Deprecated
    public FCKeditorConfig getConfig() {
        return this.fckConfig;
    }

    public String getConfig(String name) {
        return (String)this.fckConfig.get(name);
    }

    public void setConfig(String name, String value) {
        if (value != null) {
            this.fckConfig.put(name, value);
        }
    }

    @Deprecated
    public void setConfig(FCKeditorConfig config) {
        this.fckConfig = config;
    }

    private String escapeXml(String str) {
        if (Utils.isEmpty(str)) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        int len = str.length();
        block7: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&#39;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer strEditor = new StringBuffer();
        strEditor.append("<div>");
        String encodedValue = this.escapeXml(this.value);
        if (Compatibility.isCompatibleBrowser(this.request)) {
            strEditor.append(this.createInputForVariable(this.instanceName, this.instanceName, encodedValue));
            String configStr = this.fckConfig.getUrlParams();
            if (Utils.isNotEmpty(configStr)) {
                strEditor.append(this.createInputForVariable(null, this.instanceName.concat("___Config"), configStr));
            }
            StringBuffer editorLink = new StringBuffer(this.request.getContextPath());
            editorLink.append(this.basePath);
            editorLink.append("/editor/fckeditor.html?InstanceName=").append(this.instanceName);
            if (Utils.isNotEmpty(this.toolbarSet)) {
                editorLink.append("&amp;Toolbar=").append(this.toolbarSet);
            }
            XHtmlTagTool iframeTag = new XHtmlTagTool("iframe", " ");
            iframeTag.addAttribute("id", this.instanceName.concat("___Frame"));
            iframeTag.addAttribute("src", editorLink.toString());
            iframeTag.addAttribute("width", this.width);
            iframeTag.addAttribute("height", this.height);
            iframeTag.addAttribute("frameborder", "0");
            iframeTag.addAttribute("scrolling", "no");
            strEditor.append(iframeTag);
        } else {
            XHtmlTagTool textareaTag = new XHtmlTagTool("textarea", encodedValue);
            textareaTag.addAttribute("name", this.instanceName);
            textareaTag.addAttribute("rows", "4");
            textareaTag.addAttribute("cols", "40");
            textareaTag.addAttribute("wrap", "virtual");
            textareaTag.addAttribute("style", "width: ".concat(this.width).concat("; height: ").concat(this.height));
        }
        strEditor.append("</div>");
        return strEditor.toString();
    }

    public String createHtml() {
        return this.toString();
    }

    private String createInputForVariable(String name, String id, String value) {
        XHtmlTagTool tag = new XHtmlTagTool("input");
        if (Utils.isNotEmpty(id)) {
            tag.addAttribute("id", id);
        }
        if (Utils.isNotEmpty(name)) {
            tag.addAttribute("name", name);
        }
        tag.addAttribute("value", value);
        tag.addAttribute("type", "hidden");
        return tag.toString();
    }
}

