/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.requestcycle;

import javax.servlet.http.HttpServletRequest;
import net.fckeditor.requestcycle.Context;

public class ThreadLocalData {
    private static ThreadLocal<HttpServletRequest> request = new ThreadLocal();
    private static ThreadLocal<Context> context = new ThreadLocal();

    public static void beginRequest(HttpServletRequest request) {
        if (request == null) {
            throw new NullPointerException("the request cannot be null");
        }
        ThreadLocalData.request.set(request);
        context.set(new Context(request));
    }

    public static HttpServletRequest getRequest() {
        return request.get();
    }

    public static Context getContext() {
        return context.get();
    }

    public static void endRequest() {
        request.set(null);
        context.set(null);
    }
}

