/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldsWriter;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.StoredFieldsWriterPerThread;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.ArrayUtil;

final class StoredFieldsWriter {
    FieldsWriter fieldsWriter;
    final DocumentsWriter docWriter;
    final FieldInfos fieldInfos;
    int lastDocID;
    PerDoc[] docFreeList = new PerDoc[1];
    int freeCount;
    int allocCount;
    static final /* synthetic */ boolean $assertionsDisabled;

    public StoredFieldsWriter(DocumentsWriter docWriter, FieldInfos fieldInfos) {
        this.docWriter = docWriter;
        this.fieldInfos = fieldInfos;
    }

    public StoredFieldsWriterPerThread addThread(DocumentsWriter.DocState docState) throws IOException {
        return new StoredFieldsWriterPerThread(docState, this);
    }

    public synchronized void flush(SegmentWriteState state) throws IOException {
        if (state.numDocsInStore > 0) {
            this.initFieldsWriter();
            this.fill(state.numDocsInStore - this.docWriter.getDocStoreOffset());
        }
        if (this.fieldsWriter != null) {
            this.fieldsWriter.flush();
        }
    }

    private void initFieldsWriter() throws IOException {
        String docStoreSegment;
        if (this.fieldsWriter == null && (docStoreSegment = this.docWriter.getDocStoreSegment()) != null) {
            if (!$assertionsDisabled && docStoreSegment == null) {
                throw new AssertionError();
            }
            this.fieldsWriter = new FieldsWriter(this.docWriter.directory, docStoreSegment, this.fieldInfos);
            this.docWriter.addOpenFile(docStoreSegment + "." + "fdt");
            this.docWriter.addOpenFile(docStoreSegment + "." + "fdx");
            this.lastDocID = 0;
        }
    }

    public synchronized void closeDocStore(SegmentWriteState state) throws IOException {
        int inc = state.numDocsInStore - this.lastDocID;
        if (inc > 0) {
            this.initFieldsWriter();
            this.fill(state.numDocsInStore - this.docWriter.getDocStoreOffset());
        }
        if (this.fieldsWriter != null) {
            this.fieldsWriter.close();
            this.fieldsWriter = null;
            this.lastDocID = 0;
            if (!$assertionsDisabled && state.docStoreSegmentName == null) {
                throw new AssertionError();
            }
            state.flushedFiles.add(state.docStoreSegmentName + "." + "fdt");
            state.flushedFiles.add(state.docStoreSegmentName + "." + "fdx");
            state.docWriter.removeOpenFile(state.docStoreSegmentName + "." + "fdt");
            state.docWriter.removeOpenFile(state.docStoreSegmentName + "." + "fdx");
            String fileName = state.docStoreSegmentName + "." + "fdx";
            if (4L + (long)state.numDocsInStore * 8L != state.directory.fileLength(fileName)) {
                throw new RuntimeException("after flush: fdx size mismatch: " + state.numDocsInStore + " docs vs " + state.directory.fileLength(fileName) + " length in bytes of " + fileName + " file exists?=" + state.directory.fileExists(fileName));
            }
        }
    }

    synchronized PerDoc getPerDoc() {
        if (this.freeCount == 0) {
            ++this.allocCount;
            if (this.allocCount > this.docFreeList.length) {
                if (!$assertionsDisabled && this.allocCount != 1 + this.docFreeList.length) {
                    throw new AssertionError();
                }
                this.docFreeList = new PerDoc[ArrayUtil.getNextSize(this.allocCount)];
            }
            return new PerDoc();
        }
        return this.docFreeList[--this.freeCount];
    }

    synchronized void abort() {
        if (this.fieldsWriter != null) {
            try {
                this.fieldsWriter.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.fieldsWriter = null;
            this.lastDocID = 0;
        }
    }

    void fill(int docID) throws IOException {
        int docStoreOffset = this.docWriter.getDocStoreOffset();
        int end = docID + docStoreOffset;
        while (this.lastDocID < end) {
            this.fieldsWriter.skipDocument();
            ++this.lastDocID;
        }
    }

    synchronized void finishDocument(PerDoc perDoc) throws IOException {
        if (!$assertionsDisabled && !this.docWriter.writer.testPoint("StoredFieldsWriter.finishDocument start")) {
            throw new AssertionError();
        }
        this.initFieldsWriter();
        this.fill(perDoc.docID);
        this.fieldsWriter.flushDocument(perDoc.numStoredFields, perDoc.fdt);
        ++this.lastDocID;
        perDoc.reset();
        this.free(perDoc);
        if (!$assertionsDisabled && !this.docWriter.writer.testPoint("StoredFieldsWriter.finishDocument end")) {
            throw new AssertionError();
        }
    }

    public boolean freeRAM() {
        return false;
    }

    synchronized void free(PerDoc perDoc) {
        if (!$assertionsDisabled && this.freeCount >= this.docFreeList.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && 0 != perDoc.numStoredFields) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && 0L != perDoc.fdt.length()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && 0L != perDoc.fdt.getFilePointer()) {
            throw new AssertionError();
        }
        this.docFreeList[this.freeCount++] = perDoc;
    }

    static {
        $assertionsDisabled = !StoredFieldsWriter.class.desiredAssertionStatus();
    }

    class PerDoc
    extends DocumentsWriter.DocWriter {
        RAMOutputStream fdt = new RAMOutputStream();
        int numStoredFields;

        PerDoc() {
        }

        void reset() {
            this.fdt.reset();
            this.numStoredFields = 0;
        }

        void abort() {
            this.reset();
            StoredFieldsWriter.this.free(this);
        }

        public long sizeInBytes() {
            return this.fdt.sizeInBytes();
        }

        public void finish() throws IOException {
            StoredFieldsWriter.this.finishDocument(this);
        }
    }
}

