/*
 * Decompiled with CFR 0.152.
 */
package cz.rtnext.rs.service;

import java.util.HashMap;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Lazy
public class RestDataService {
    @Autowired
    SessionFactory sessionFactory;

    @Transactional
    public HashMap<String, Object> find(Class<?> trida, int startIndex, int pageSize, String sortBy) {
        Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(trida);
        criteria.setProjection(Projections.rowCount());
        long count = (Long)criteria.uniqueResult();
        criteria.setProjection(null);
        if (sortBy != null) {
            if (sortBy.startsWith("-")) {
                criteria.addOrder(Order.desc((String)sortBy));
            } else {
                criteria.addOrder(Order.asc((String)sortBy));
            }
        }
        if (startIndex > -1 && pageSize > -1) {
            criteria.setFirstResult(startIndex);
            criteria.setMaxResults(pageSize);
        }
        List resultList = criteria.list();
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        vysledek.put("list", resultList);
        vysledek.put("range", "items " + startIndex + "-" + (startIndex + resultList.size() - 1) + "/" + count);
        return vysledek;
    }
}

