/*
 * Decompiled with CFR 0.152.
 */
package cz.triangle.domy.www;

import cz.triangle.domy.Dum;
import cz.triangle.domy.Jazyk;
import cz.triangle.domy.Lokalita;
import cz.triangle.domy.LokalitaJaz;
import cz.triangle.domy.Podlazi;
import cz.triangle.domy.PolozkaMenu;
import cz.triangle.domy.SkupinaFotogalerie;
import cz.triangle.domy.TypOblasti;
import cz.triangle.domy.TypPodlaziJaz;
import cz.triangle.domy.TypStavuLokality;
import cz.triangle.domy.form.AdminLokalitaForm;
import cz.triangle.domy.www.ClankyDelegate;
import cz.triangle.util.ConvertService;
import cz.triangle.util.FileIO;
import cz.triangle.util.Obrazek;
import fr.improve.struts.taglib.layout.menu.MenuComponent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.apache.struts.util.MessageResources;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class LokalitaDelegate
implements Serializable {
    private MessageResources res;
    private MenuComponent vybraneMenuComponent = null;
    private String localeId;
    public static final String TYP_LOKALITA = "lokalita";
    public static final String TYP_DUM = "dum";
    public static final String TYP_PODLAZI = "podlazi";
    public static final String TYP_BLOK = "blok";
    public static final String TYP_BLOK_RD = "blok_rd";
    public static final String TYP_BYT = "byt";
    public static final String TYP_NEBYTOVA_PROSTORA = "nebytova_prostora";
    public static final String TYP_RD = "rd";

    public LokalitaDelegate(MessageResources res, String localeId, Session hsess) {
        this.res = res;
        Jazyk jazyk = (Jazyk)hsess.load(Jazyk.class, (Serializable)((Object)localeId));
        this.localeId = localeId;
    }

    public Map nactiMenu(String kod, String kod2, String typ, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        List polozky = hsess.createQuery("from Lokalita lokalita order by lokalita.razeni").list();
        MenuComponent treeData = new MenuComponent();
        treeData.setTitle("root");
        treeData.setDescription("root");
        treeData.setName("root");
        if (polozky.size() > 0) {
            this.vytvorLokality(polozky, treeData, kod, kod2, typ, hsess);
        }
        vysledek.put("strom", treeData);
        if (kod != null && this.vybraneMenuComponent == null) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.vybrano_neexistujici_id"));
        }
        return vysledek;
    }

    private void vytvorLokality(List polozky, MenuComponent rodic, String vybranyKod, String vybranyKod2, String typ, Session hsess) {
        for (Lokalita lokalita : polozky) {
            MenuComponent node = new MenuComponent();
            node.setTitle(((LokalitaJaz)lokalita.getLokalitaJazs().get(this.localeId)).getNazev() + " (" + lokalita.getRazeni() + ")");
            node.setDescription(lokalita.getId().toString());
            node.setToolTip(TYP_LOKALITA);
            node.setImage("lokalita.png");
            node.setLocation("admin_lokalita.do?akce=editace_polozky&typ=lokalita&id=" + lokalita.getId());
            Integer vybranyKodi = null;
            try {
                vybranyKodi = new Integer(vybranyKod);
            }
            catch (NumberFormatException e) {
                vybranyKodi = null;
            }
            if (typ != null && typ.equalsIgnoreCase(TYP_LOKALITA) && vybranyKodi != null && vybranyKodi.equals(lokalita.getId())) {
                node.setStyle("font-weight: bold;");
                this.vybraneMenuComponent = node;
            }
            rodic.addMenuComponent(node);
            List typyBloku = hsess.createSQLQuery("select distinct a.id as id, a.nazev, a.razeni, c.id as lokalita_id from typ_bloku a left join rd b on (b.id_typ_bloku = a.id) left join lokalita c on (b.id_lokalita = c.id and c.id=?) where b.id is not null order by a.razeni").setInteger(0, lokalita.getId().intValue()).list();
            this.vytvorBlokyProRD(typyBloku, node, vybranyKod, vybranyKod2, typ);
            List domy = hsess.createQuery("from Dum dum where dum.lokalita = ? order by dum.razeni").setEntity(0, (Object)lokalita).list();
            this.vytvorDomy(domy, node, vybranyKod, vybranyKod2, typ, hsess);
        }
    }

    private void vytvorDomy(List polozky, MenuComponent rodic, String vybranyKod, String vybranyKod2, String typ, Session hsess) {
        for (Dum dum : polozky) {
            MenuComponent node = new MenuComponent();
            node.setTitle(dum.getNazev() + " (" + dum.getRazeni() + ")");
            node.setDescription(dum.getId().toString());
            node.setToolTip(TYP_DUM);
            node.setImage("dum.png");
            node.setLocation("admin_dum.do?akce=editace_polozky&typ=dum&id=" + dum.getId());
            Integer vybranyKodi = null;
            try {
                vybranyKodi = new Integer(vybranyKod);
            }
            catch (NumberFormatException e) {
                vybranyKodi = null;
            }
            if (typ != null && typ.equalsIgnoreCase(TYP_DUM) && vybranyKodi != null && vybranyKodi.equals(dum.getId())) {
                node.setStyle("font-weight: bold;");
                this.vybraneMenuComponent = node;
            }
            rodic.addMenuComponent(node);
            String nezs = this.res.getMessage("admin.nezobrazovat_bloky");
            if (nezs == null || !nezs.equalsIgnoreCase("ano")) {
                List typyBloku = hsess.createQuery("select distinct typBloku.id, typBloku.nazev, typBloku.razeni, byt.podlazi.dum from TypBloku typBloku join typBloku.byts byt where byt.podlazi.dum = ? order by typBloku.razeni").setEntity(0, (Object)dum).list();
                this.vytvorBloky(typyBloku, node, vybranyKod, vybranyKod2, typ);
            }
            List podlazi = hsess.createQuery("from Podlazi podlazi where podlazi.dum = ? order by podlazi.typPodlazi.razeni").setEntity(0, (Object)dum).list();
            this.vytvorPodlazi(podlazi, node, vybranyKod, vybranyKod2, typ);
        }
    }

    private void vytvorPodlazi(List polozky, MenuComponent rodic, String vybranyKod, String vybranyKod2, String typ) {
        for (Podlazi podlazi : polozky) {
            MenuComponent node = new MenuComponent();
            node.setTitle(((TypPodlaziJaz)podlazi.getTypPodlazi().getTypPodlaziJazs().get(this.localeId)).getNazev());
            node.setDescription(podlazi.getId().toString());
            node.setToolTip(TYP_PODLAZI);
            node.setImage("ObsahTabulkaNemovitosti.png");
            node.setLocation("admin_podlazi.do?akce=editace_polozky&typ=podlazi&id=" + podlazi.getId());
            Integer vybranyKodi = null;
            try {
                vybranyKodi = new Integer(vybranyKod);
            }
            catch (NumberFormatException e) {
                vybranyKodi = null;
            }
            Integer vybranyKodi2 = null;
            try {
                vybranyKodi2 = new Integer(vybranyKod2);
            }
            catch (NumberFormatException e) {
                vybranyKodi2 = null;
            }
            if (typ != null && typ.equalsIgnoreCase(TYP_PODLAZI) && vybranyKodi != null && vybranyKodi.equals(podlazi.getId()) && vybranyKodi2 == null) {
                node.setStyle("font-weight: bold;");
                this.vybraneMenuComponent = node;
            }
            rodic.addMenuComponent(node);
        }
    }

    private void vytvorBloky(List polozky, MenuComponent rodic, String vybranyKod, String vybranyKod2, String typ) {
        if (polozky.size() < 2) {
            return;
        }
        for (Object[] obj : polozky) {
            MenuComponent node = new MenuComponent();
            Integer idBloku = (Integer)obj[0];
            String nazevBloku = (String)obj[1];
            Dum dum = (Dum)obj[3];
            node.setTitle(dum.getNazev() + nazevBloku);
            node.setDescription(idBloku.toString());
            node.setToolTip(TYP_BLOK);
            node.setImage("yellow-folder-closed.png");
            node.setLocation("admin_blok.do?akce=editace_polozky&typ=blok&id=" + idBloku + "&id2=" + dum.getId());
            Integer vybranyKodi = null;
            try {
                vybranyKodi = new Integer(vybranyKod);
            }
            catch (NumberFormatException e) {
                vybranyKodi = null;
            }
            Integer vybranyKodi2 = null;
            try {
                vybranyKodi2 = new Integer(vybranyKod2);
            }
            catch (NumberFormatException e) {
                vybranyKodi2 = null;
            }
            if (typ != null && typ.equalsIgnoreCase(TYP_BLOK) && vybranyKodi != null && vybranyKodi.equals(idBloku) && vybranyKodi2 != null && vybranyKodi2.equals(dum.getId())) {
                node.setStyle("font-weight: bold;");
                this.vybraneMenuComponent = node;
            }
            rodic.addMenuComponent(node);
        }
    }

    private void vytvorBlokyProRD(List polozky, MenuComponent rodic, String vybranyKod, String vybranyKod2, String typ) {
        for (Object[] obj : polozky) {
            MenuComponent node = new MenuComponent();
            Integer idBloku = (Integer)obj[0];
            String nazevBloku = (String)obj[1];
            Integer lokalita_id = (Integer)obj[3];
            if (lokalita_id == null) continue;
            node.setTitle("RD " + nazevBloku);
            node.setDescription(idBloku.toString());
            node.setToolTip(TYP_BLOK_RD);
            node.setImage("rd.png");
            node.setLocation("admin_blok_rd.do?akce=editace_polozky&typ=blok_rd&id=" + idBloku + "&id2=" + lokalita_id);
            Integer vybranyKodi = null;
            try {
                vybranyKodi = new Integer(vybranyKod);
            }
            catch (NumberFormatException e) {
                vybranyKodi = null;
            }
            Integer vybranyKodi2 = null;
            try {
                vybranyKodi2 = new Integer(vybranyKod2);
            }
            catch (NumberFormatException e) {
                vybranyKodi2 = null;
            }
            if (typ != null && typ.equalsIgnoreCase(TYP_BLOK_RD) && vybranyKodi != null && vybranyKodi.equals(idBloku) && vybranyKodi2 != null && vybranyKodi2.equals(lokalita_id)) {
                node.setStyle("font-weight: bold;");
                this.vybraneMenuComponent = node;
            }
            rodic.addMenuComponent(node);
        }
    }

    public void otevriVybrany() {
        if (this.vybraneMenuComponent != null) {
            for (MenuComponent tmp = this.vybraneMenuComponent.getParent(); tmp != null; tmp = tmp.getParent()) {
                tmp.setOpen(true);
            }
        }
    }

    public Map novaPolozka(AdminLokalitaForm f, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            AdminLokalitaForm form = f;
            if (form == null) {
                form = new AdminLokalitaForm();
                List jazyky = LokalitaDelegate.getSeznamJazyku(hsess);
                for (Jazyk jazyk : jazyky) {
                    form.setNazev(jazyk.getId(), "");
                }
            }
            DateFormat dateFormat = DateFormat.getDateInstance(2, new Locale("cs", "CZ"));
            Calendar cal = Calendar.getInstance();
            cal.add(5, 7);
            form.setZverejneniOd(dateFormat.format(cal.getTime()));
            vysledek.put("adminLokalitaForm", (Object)form);
            vysledek.put("seznamTypuOblasti", LokalitaDelegate.getSeznamTypuOblasti(hsess));
            vysledek.put("seznamTypuStavuLokality", LokalitaDelegate.getSeznamTypuStavuLokality(hsess));
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.editace_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map editacePolozky(String id, AdminLokalitaForm f, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            Lokalita polozka = (Lokalita)hsess.get(Lokalita.class, (Serializable)new Integer(id));
            AdminLokalitaForm form = f;
            if (form == null) {
                form = new AdminLokalitaForm();
                ConvertService.registrujCeske();
                BeanUtils.copyProperties((Object)((Object)form), (Object)polozka);
                form.setObrazekNazev(polozka.getObrazek());
                form.setSymbol3dNazev(polozka.getSymbol3d());
                form.setSymbolNazev(polozka.getSymbol());
                form.setObrazekNahledNazev(polozka.getObrazekNahled());
                ConvertService.odregistrujCeske();
                List jazyky = LokalitaDelegate.getSeznamJazyku(hsess);
                for (Jazyk jazyk : jazyky) {
                    LokalitaJaz lokalitaJaz = (LokalitaJaz)polozka.getLokalitaJazs().get(jazyk.getId());
                    if (lokalitaJaz != null) {
                        form.setNazev(jazyk.getId(), lokalitaJaz.getNazev());
                        form.setPopis(jazyk.getId(), lokalitaJaz.getPopis());
                        form.setPrefixNazev(jazyk.getId(), lokalitaJaz.getPrefixNazev());
                        form.setMisto(jazyk.getId(), lokalitaJaz.getMisto());
                        form.setMesto(jazyk.getId(), lokalitaJaz.getMesto());
                        form.setNapis(jazyk.getId(), lokalitaJaz.getNapis());
                        form.setNapis2(jazyk.getId(), lokalitaJaz.getNapis2());
                        form.setNapis3(jazyk.getId(), lokalitaJaz.getNapis3());
                        form.setNapis4(jazyk.getId(), lokalitaJaz.getNapis4());
                        continue;
                    }
                    form.setNazev(jazyk.getId(), "");
                    form.setPopis(jazyk.getId(), "");
                    form.setPrefixNazev(jazyk.getId(), "");
                    form.setMisto(jazyk.getId(), "");
                    form.setMesto(jazyk.getId(), "");
                    form.setNapis(jazyk.getId(), "");
                    form.setNapis2(jazyk.getId(), "");
                    form.setNapis3(jazyk.getId(), "");
                    form.setNapis4(jazyk.getId(), "");
                }
                if (polozka.getTypOblasti() != null) {
                    form.setTypOblastiId(polozka.getTypOblasti().getId());
                }
                if (polozka.getTypStavuLokality() != null) {
                    form.setTypStavuLokalityId(polozka.getTypStavuLokality().getId());
                }
                if (polozka.getSkupinaFotogalerie() != null) {
                    form.setSkupinaFotogalerieId(polozka.getSkupinaFotogalerie().getId().toString());
                }
            }
            vysledek.put("id", polozka.getId());
            vysledek.put("adminLokalitaForm", (Object)form);
            vysledek.put("seznamTypuOblasti", LokalitaDelegate.getSeznamTypuOblasti(hsess));
            vysledek.put("seznamTypuStavuLokality", LokalitaDelegate.getSeznamTypuStavuLokality(hsess));
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.editace_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    private String validacniChyba(ActionMessages messages) {
        if (messages != null && !messages.isEmpty()) {
            Iterator iter = messages.get();
            ActionMessage message = (ActionMessage)iter.next();
            return this.res.getMessage(message.getKey(), message.getValues());
        }
        return null;
    }

    public Map zapsatNovouPolozku(AdminLokalitaForm form, ActionMapping mapping, HttpServletRequest request, String cesta, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            String nazevSouboru;
            ActionErrors errors = form.validate(mapping, request);
            if (errors != null && !errors.isEmpty()) {
                vysledek.put("validacni_chyba", this.validacniChyba((ActionMessages)errors));
                vysledek.put("adminLokalitaForm", (Object)form);
                return vysledek;
            }
            Lokalita novaPolozka = new Lokalita();
            ConvertService.registrujCeske();
            BeanUtils.copyProperties((Object)novaPolozka, (Object)((Object)form));
            ConvertService.odregistrujCeske();
            vysledek.put("adminLokalitaForm", (Object)form);
            if (form.getTypOblastiId() == null || form.getTypOblastiId().equals("-1")) {
                novaPolozka.setTypOblasti(null);
            } else {
                novaPolozka.setTypOblasti((TypOblasti)hsess.load(TypOblasti.class, (Serializable)((Object)form.getTypOblastiId())));
            }
            TypStavuLokality novyTyp = (TypStavuLokality)hsess.load(TypStavuLokality.class, (Serializable)((Object)form.getTypStavuLokalityId()));
            novaPolozka.setTypStavuLokality(novyTyp);
            if (form.getSkupinaFotogalerieId() != null && !form.getSkupinaFotogalerieId().equalsIgnoreCase("-1")) {
                try {
                    SkupinaFotogalerie skupinaFotogalerie = (SkupinaFotogalerie)hsess.get(SkupinaFotogalerie.class, (Serializable)new Integer(form.getSkupinaFotogalerieId()));
                    novaPolozka.setSkupinaFotogalerie(skupinaFotogalerie);
                }
                catch (Exception skupinaFotogalerie) {
                    // empty catch block
                }
            }
            hsess.save((Object)novaPolozka);
            List jazyky = LokalitaDelegate.getSeznamJazyku(hsess);
            for (Jazyk jazyk : jazyky) {
                String nazev = (String)form.getNazev(jazyk.getId());
                LokalitaJaz lokalitaJaz = new LokalitaJaz();
                lokalitaJaz.setJazyk(jazyk);
                novaPolozka.getLokalitaJazs().put(jazyk.getId(), lokalitaJaz);
                lokalitaJaz.setLokalita(novaPolozka);
                if (nazev != null) {
                    lokalitaJaz.setNazev(nazev);
                } else {
                    lokalitaJaz.setNazev("");
                }
                String popis = (String)form.getPopis(jazyk.getId());
                if (popis != null) {
                    lokalitaJaz.setPopis(popis);
                } else {
                    lokalitaJaz.setPopis("");
                }
                String prefixNazev = (String)form.getPrefixNazev(jazyk.getId());
                if (prefixNazev != null) {
                    lokalitaJaz.setPrefixNazev(prefixNazev);
                } else {
                    lokalitaJaz.setPrefixNazev("");
                }
                String misto = (String)form.getMisto(jazyk.getId());
                if (misto != null) {
                    lokalitaJaz.setMisto(misto);
                } else {
                    lokalitaJaz.setMisto("");
                }
                String mesto = (String)form.getMesto(jazyk.getId());
                if (mesto != null) {
                    lokalitaJaz.setMesto(mesto);
                } else {
                    lokalitaJaz.setMesto("");
                }
                String napis = (String)form.getNapis(jazyk.getId());
                if (napis != null) {
                    lokalitaJaz.setNapis(napis);
                } else {
                    lokalitaJaz.setNapis("");
                }
                String napis2 = (String)form.getNapis2(jazyk.getId());
                if (napis2 != null) {
                    lokalitaJaz.setNapis2(napis2);
                } else {
                    lokalitaJaz.setNapis2("");
                }
                String napis3 = (String)form.getNapis3(jazyk.getId());
                if (napis3 != null) {
                    lokalitaJaz.setNapis3(napis3);
                } else {
                    lokalitaJaz.setNapis3("");
                }
                String napis4 = (String)form.getNapis4(jazyk.getId());
                if (napis4 != null) {
                    lokalitaJaz.setNapis4(napis4);
                } else {
                    lokalitaJaz.setNapis4("");
                }
                hsess.save((Object)lokalitaJaz);
            }
            this.vytvorAdresare(cesta, novaPolozka.getId());
            long privesek = Math.round(Math.random() * 1000.0);
            FormFile file = form.getObrazekFile();
            if (file != null && file.getFileName().length() > 0) {
                novaPolozka.setObrazek(LokalitaDelegate.ulozSoubor(cesta, novaPolozka, privesek, file, "lokalita_obrazek"));
            }
            if ((file = form.getSymbolFile()) != null && file.getFileName().length() > 0) {
                novaPolozka.setSymbol(LokalitaDelegate.ulozSoubor(cesta, novaPolozka, privesek, file, "lokalita_symbol"));
            }
            if ((file = form.getSymbol3dFile()) != null && file.getFileName().length() > 0) {
                novaPolozka.setSymbol3d(LokalitaDelegate.ulozSoubor(cesta, novaPolozka, privesek, file, "lokalita_symbol3d"));
            }
            if ((file = form.getObrazekNahledFile()) != null && file.getFileName().length() > 0 && (nazevSouboru = this.zapisObrazek(cesta + "dbimg" + File.separator, file, novaPolozka.getObrazekNahled(), novaPolozka.getId(), Integer.parseInt(this.res.getMessage("obrazek.lokalita.x")), Integer.parseInt(this.res.getMessage("obrazek.lokalita.y")))) != null) {
                novaPolozka.setObrazekNahled(nazevSouboru);
            }
            if (form.getVytvorStranky() != null && form.getVytvorStranky().booleanValue()) {
                ClankyDelegate cd = new ClankyDelegate(null, null, this.res);
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document doc = builder.parse(cesta + "pages" + File.separator + "admin.xml");
                Node node = doc.getFirstChild();
                cd.vlozPolozkuXML(novaPolozka, node, null, hsess);
            }
            vysledek.put("id", novaPolozka.getId());
            hsess.flush();
        }
        catch (HibernateException e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
            if (hsess.getTransaction().isActive()) {
                hsess.getTransaction().rollback();
            }
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public static String ulozSoubor(String cesta, Lokalita novaPolozka, long privesek, FormFile file, String prefix) {
        if (file != null && !file.getFileName().equalsIgnoreCase("")) {
            String koncovka = file.getFileName().substring(file.getFileName().lastIndexOf("."));
            LokalitaDelegate.zapisSoubor(file, LokalitaDelegate.getCestaLokalitaSwf(cesta, novaPolozka.getId()), prefix + "_" + novaPolozka.getId() + "_" + privesek + koncovka);
            return prefix + "_" + novaPolozka.getId() + "_" + privesek + koncovka;
        }
        return null;
    }

    public static String ulozSoubor(String cesta, Lokalita novaPolozka, long privesek, FormFile file, String sekce, String prefix) {
        if (file != null && !file.getFileName().equalsIgnoreCase("")) {
            String koncovka = file.getFileName().substring(file.getFileName().lastIndexOf("."));
            LokalitaDelegate.zapisSoubor(file, LokalitaDelegate.getCestaLokalita(cesta, novaPolozka.getId()) + File.separator + sekce, prefix + "_" + novaPolozka.getId() + "_" + privesek + koncovka);
            return prefix + "_" + novaPolozka.getId() + "_" + privesek + koncovka;
        }
        return null;
    }

    public Map zapsatPolozku(AdminLokalitaForm form, String id, ActionMapping mapping, HttpServletRequest request, String cesta, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            String nazevSouboru;
            ActionErrors errors = form.validate(mapping, request);
            if (errors != null && !errors.isEmpty()) {
                vysledek.put("validacni_chyba", this.validacniChyba((ActionMessages)errors));
                vysledek.put("adminLokalitaForm", (Object)form);
                return vysledek;
            }
            Lokalita polozka = (Lokalita)hsess.load(Lokalita.class, (Serializable)new Integer(id));
            ConvertService.registrujCeske();
            List jazyky = LokalitaDelegate.getSeznamJazyku(hsess);
            for (Jazyk jazyk : jazyky) {
                String nazev;
                LokalitaJaz lokalitaJaz = (LokalitaJaz)polozka.getLokalitaJazs().get(jazyk.getId());
                if (lokalitaJaz == null) {
                    lokalitaJaz = new LokalitaJaz();
                    lokalitaJaz.setJazyk(jazyk);
                    lokalitaJaz.setLokalita(polozka);
                    hsess.save((Object)lokalitaJaz);
                }
                if ((nazev = (String)form.getNazev(jazyk.getId())) != null) {
                    lokalitaJaz.setNazev(nazev);
                } else {
                    lokalitaJaz.setNazev("");
                }
                String popis = (String)form.getPopis(jazyk.getId());
                if (popis != null) {
                    lokalitaJaz.setPopis(popis);
                } else {
                    lokalitaJaz.setPopis("");
                }
                String prefixNazev = (String)form.getPrefixNazev(jazyk.getId());
                if (prefixNazev != null) {
                    lokalitaJaz.setPrefixNazev(prefixNazev);
                } else {
                    lokalitaJaz.setPrefixNazev("");
                }
                String misto = (String)form.getMisto(jazyk.getId());
                if (misto != null) {
                    lokalitaJaz.setMisto(misto);
                } else {
                    lokalitaJaz.setMisto("");
                }
                String mesto = (String)form.getMesto(jazyk.getId());
                if (mesto != null) {
                    lokalitaJaz.setMesto(mesto);
                } else {
                    lokalitaJaz.setMesto("");
                }
                String napis = (String)form.getNapis(jazyk.getId());
                if (napis != null) {
                    lokalitaJaz.setNapis(napis);
                } else {
                    lokalitaJaz.setNapis("");
                }
                String napis2 = (String)form.getNapis2(jazyk.getId());
                if (napis2 != null) {
                    lokalitaJaz.setNapis2(napis2);
                } else {
                    lokalitaJaz.setNapis2("");
                }
                String napis3 = (String)form.getNapis3(jazyk.getId());
                if (napis3 != null) {
                    lokalitaJaz.setNapis3(napis3);
                } else {
                    lokalitaJaz.setNapis3("");
                }
                String napis4 = (String)form.getNapis4(jazyk.getId());
                if (napis4 != null) {
                    lokalitaJaz.setNapis4(napis4);
                } else {
                    lokalitaJaz.setNapis4("");
                }
                hsess.save((Object)lokalitaJaz);
            }
            long privesek = Math.round(Math.random() * 1000.0);
            FormFile file = form.getObrazekFile();
            if (file != null && file.getFileName().length() > 0) {
                polozka.setObrazek(LokalitaDelegate.prepisSoubor(cesta, polozka, privesek, file, polozka.getObrazek(), "lokalita_obrazek"));
            }
            if ((file = form.getSymbolFile()) != null && file.getFileName().length() > 0) {
                polozka.setSymbol(LokalitaDelegate.prepisSoubor(cesta, polozka, privesek, file, polozka.getSymbol(), "lokalita_symbol"));
            }
            if ((file = form.getSymbol3dFile()) != null && file.getFileName().length() > 0) {
                polozka.setSymbol3d(LokalitaDelegate.prepisSoubor(cesta, polozka, privesek, file, polozka.getSymbol3d(), "lokalita_symbol3d"));
            }
            if ((file = form.getObrazekNahledFile()) != null && file.getFileName().length() > 0 && (nazevSouboru = this.zapisObrazek(cesta + "dbimg" + File.separator, file, polozka.getObrazekNahled(), polozka.getId(), Integer.parseInt(this.res.getMessage("obrazek.lokalita.x")), Integer.parseInt(this.res.getMessage("obrazek.lokalita.y")))) != null) {
                polozka.setObrazekNahled(nazevSouboru);
            }
            BeanUtils.copyProperties((Object)polozka, (Object)((Object)form));
            ConvertService.odregistrujCeske();
            if (form.getTypOblastiId() == null || form.getTypOblastiId().equals("-1")) {
                polozka.setTypOblasti(null);
            } else {
                polozka.setTypOblasti((TypOblasti)hsess.load(TypOblasti.class, (Serializable)((Object)form.getTypOblastiId())));
            }
            TypStavuLokality novyTyp = (TypStavuLokality)hsess.load(TypStavuLokality.class, (Serializable)((Object)form.getTypStavuLokalityId()));
            if (polozka.getTypStavuLokality() != novyTyp) {
                ClankyDelegate cd = new ClankyDelegate(null, null, this.res);
                PolozkaMenu rozcestnikLokality = null;
                Iterator iter = hsess.createQuery("from PolozkaMenu polozka where polozka.lokalita=?").setEntity(0, (Object)polozka).iterate();
                while (iter.hasNext()) {
                    rozcestnikLokality = (PolozkaMenu)iter.next();
                    if (!rozcestnikLokality.getStranka().equalsIgnoreCase("rozcestnik_lokality.jsp")) continue;
                    String podminka = null;
                    if (novyTyp.getId().equalsIgnoreCase("aktualni")) {
                        podminka = "vypis_lokalit.jsp";
                    }
                    if (novyTyp.getId().equalsIgnoreCase("dokoncene")) {
                        podminka = "vypis_lokalit_dokoncene.jsp";
                    }
                    if (novyTyp.getId().equalsIgnoreCase("pripravovane")) {
                        podminka = "vypis_lokalit_pripravovane.jsp";
                    }
                    if (podminka == null) continue;
                    PolozkaMenu novyRodic = null;
                    if (podminka.equalsIgnoreCase("vypis_lokalit.jsp")) {
                        rozcestnikLokality.setKodRodic(null);
                    } else {
                        Iterator iter2 = hsess.createQuery("from PolozkaMenu polozka where polozka.stranka=? and polozka.idJazyk=?").setString(0, podminka).setString(1, rozcestnikLokality.getIdJazyk()).iterate();
                        if (iter2.hasNext()) {
                            novyRodic = (PolozkaMenu)iter2.next();
                            rozcestnikLokality.setKodRodic(novyRodic.getKod());
                        }
                    }
                    String razeni = rozcestnikLokality.getRazeni();
                    Integer razenii = null;
                    if (razeni == null) {
                        razeni = "0";
                    } else {
                        try {
                            razenii = new Integer(razeni.substring(razeni.length() - 2, razeni.length()));
                        }
                        catch (NumberFormatException e) {
                            razenii = new Integer(0);
                        }
                    }
                    String retezRazeni = cd.vytvorRazeni(rozcestnikLokality, novyRodic, new Integer(razenii));
                    rozcestnikLokality.setRazeni(retezRazeni);
                    cd.upravRazeniDetem(rozcestnikLokality, razenii, hsess);
                }
            }
            polozka.setTypStavuLokality(novyTyp);
            if (form.getSkupinaFotogalerieId() != null && !form.getSkupinaFotogalerieId().equalsIgnoreCase("-1")) {
                try {
                    SkupinaFotogalerie skupinaFotogalerie = (SkupinaFotogalerie)hsess.get(SkupinaFotogalerie.class, (Serializable)new Integer(form.getSkupinaFotogalerieId()));
                    polozka.setSkupinaFotogalerie(skupinaFotogalerie);
                }
                catch (Exception exception) {}
            } else {
                polozka.setSkupinaFotogalerie(null);
            }
            vysledek.put("adminLokalitaForm", (Object)form);
            vysledek.put("id", polozka.getId());
            hsess.flush();
        }
        catch (HibernateException e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
            if (hsess.getTransaction().isActive()) {
                hsess.getTransaction().rollback();
            }
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public static String prepisSoubor(String cesta, Lokalita polozka, long privesek, FormFile file, String staryNazev, String prefix) {
        if (file != null && !file.getFileName().equalsIgnoreCase("")) {
            if (staryNazev != null && staryNazev.length() > 0) {
                LokalitaDelegate.smazatSwf(cesta, polozka.getId(), staryNazev);
            }
            String koncovka = file.getFileName().substring(file.getFileName().lastIndexOf("."));
            LokalitaDelegate.zapisSoubor(file, LokalitaDelegate.getCestaLokalitaSwf(cesta, polozka.getId()), prefix + "_" + polozka.getId() + "_" + privesek + koncovka);
            return prefix + "_" + polozka.getId() + "_" + privesek + koncovka;
        }
        return null;
    }

    public Map smazatPolozku(String id, String cesta, Session hsess) {
        HashMap<String, String> vysledek = new HashMap<String, String>();
        try {
            Lokalita staraPolozka = (Lokalita)hsess.load(Lokalita.class, (Serializable)new Integer(id));
            if (staraPolozka.getDums() != null && staraPolozka.getDums().size() > 0) {
                vysledek.put("chyba", this.res.getMessage("admin.chyba.smazani_polozky", (Object)this.res.getMessage("admin.chyba.smazani_polozky.existuji_domy")));
                return vysledek;
            }
            if (staraPolozka.getRds() != null && staraPolozka.getRds().size() > 0) {
                vysledek.put("chyba", this.res.getMessage("admin.chyba.smazani_polozky", (Object)this.res.getMessage("admin.chyba.smazani_polozky.existuji_rd")));
                return vysledek;
            }
            if (staraPolozka.getObrazek() != null && staraPolozka.getObrazek().length() > 0) {
                LokalitaDelegate.smazatSwf(cesta, staraPolozka.getId(), staraPolozka.getObrazek());
            }
            if (staraPolozka.getSymbol() != null && staraPolozka.getSymbol().length() > 0) {
                LokalitaDelegate.smazatSwf(cesta, staraPolozka.getId(), staraPolozka.getSymbol());
            }
            if (staraPolozka.getSymbol3d() != null && staraPolozka.getSymbol3d().length() > 0) {
                LokalitaDelegate.smazatSwf(cesta, staraPolozka.getId(), staraPolozka.getSymbol3d());
            }
            this.smazAdresare(cesta, staraPolozka.getId());
            hsess.delete((Object)staraPolozka);
            hsess.flush();
        }
        catch (HibernateException e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.smazani_polozky", (Object)e.getMessage()));
            if (hsess.getTransaction().isActive()) {
                hsess.getTransaction().rollback();
            }
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.smazani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public MenuComponent getVybraneMenuComponent() {
        return this.vybraneMenuComponent;
    }

    public static List getSeznamJazyku(Session hsess) {
        return hsess.createQuery("from Jazyk jazyk order by jazyk.id").list();
    }

    public static List getSeznamTypuOblasti(Session hsess) {
        return hsess.createQuery("from TypOblasti typOblasti order by typOblasti.id").list();
    }

    public static List getSeznamTypuStavuLokality(Session hsess) {
        return hsess.createQuery("from TypStavuLokality typStavuLokality order by typStavuLokality.id").list();
    }

    public List getSeznamRd(String id, Session hsess) {
        Lokalita lokalita = (Lokalita)hsess.load(Lokalita.class, (Serializable)new Integer(id));
        return hsess.createQuery("from Rd rd where rd.lokalita = ? order by rd.cisloBytu").setEntity(0, (Object)lokalita).list();
    }

    public static String getPrvniJazyk(Session hsess) {
        Iterator iter = hsess.createQuery("from Jazyk jazyk order by jazyk.id").iterate();
        if (iter.hasNext()) {
            Jazyk jazyk = (Jazyk)iter.next();
            return jazyk.getId();
        }
        return null;
    }

    private static String getCestaLokalita(String cesta, Integer id) {
        return cesta + "dbimg" + File.separator + "lokalita_" + id;
    }

    public static String getCestaLokalitaSwf(String cesta, Integer id) {
        return LokalitaDelegate.getCestaLokalita(cesta, id) + File.separator + "swf";
    }

    public static boolean smazatSwf(String cesta, Integer id, String soubor) {
        File file = new File(LokalitaDelegate.getCestaLokalitaSwf(cesta, id) + File.separator + soubor);
        return file.delete();
    }

    public static boolean smazatSoubor(String cesta, Integer id, String sekce, String soubor) {
        File file = new File(LokalitaDelegate.getCestaLokalita(cesta, id) + File.separator + sekce + File.separator + soubor);
        return file.delete();
    }

    private void vytvorAdresare(String cesta, Integer id) {
        new File(LokalitaDelegate.getCestaLokalita(cesta, id)).mkdir();
        new File(LokalitaDelegate.getCestaLokalitaSwf(cesta, id)).mkdir();
        new File(LokalitaDelegate.getCestaLokalita(cesta, id) + File.separator + "pdf").mkdir();
    }

    private void smazAdresare(String cesta, Integer id) {
        new File(LokalitaDelegate.getCestaLokalitaSwf(cesta, id)).delete();
        new File(LokalitaDelegate.getCestaLokalita(cesta, id)).delete();
        new File(LokalitaDelegate.getCestaLokalita(cesta, id) + File.separator + "pdf").delete();
    }

    public static boolean zapisSoubor(FormFile file, String umisteni, String soubor) {
        boolean vysledek = true;
        try {
            File f = new File(umisteni);
            if (!f.exists()) {
                f.mkdirs();
            }
            FileOutputStream bos = new FileOutputStream(umisteni + File.separator + soubor);
            InputStream stream = file.getInputStream();
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = stream.read(buffer, 0, 8192)) != -1) {
                ((OutputStream)bos).write(buffer, 0, bytesRead);
            }
            ((OutputStream)bos).close();
        }
        catch (IOException e) {
            return false;
        }
        return vysledek;
    }

    public static void kopirujSwf(String cesta, String in, String out, Integer stareId, Integer noveId) throws FileNotFoundException, IOException {
        FileIO.copyFile(LokalitaDelegate.getCestaLokalitaSwf(cesta, stareId) + File.separator + in, LokalitaDelegate.getCestaLokalitaSwf(cesta, noveId) + File.separator + out);
    }

    private String zapisObrazek(String cesta, FormFile file, String staryObrazek, Integer noveId, int x, int y) {
        if (staryObrazek != null && staryObrazek != null && !staryObrazek.equalsIgnoreCase("")) {
            this.smazObrazek(cesta, staryObrazek);
        }
        long privesek = Math.round(Math.random() * 1000.0);
        String koncovka = file.getFileName().substring(file.getFileName().lastIndexOf("."));
        String nazevSouboru = TYP_LOKALITA + noveId + "_" + privesek + koncovka;
        int w = x;
        int h = y;
        try {
            Obrazek.zapisSoubor(file, cesta + nazevSouboru);
            String watermark = null;
            watermark = this.res.getMessage("watermark");
            Obrazek.resize5(cesta + nazevSouboru, cesta + nazevSouboru, w, h, "both", 80);
            if (watermark != null && watermark.trim().length() > 0) {
                Obrazek.addImageWatermark(cesta + File.separator + watermark, cesta + nazevSouboru, cesta + nazevSouboru);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nazevSouboru;
    }

    private void smazObrazek(String cesta, String soubor) {
        if (soubor != null && !soubor.equalsIgnoreCase("")) {
            File file = new File(cesta + soubor);
            file.delete();
        }
    }
}

