/*
 * Decompiled with CFR 0.152.
 */
package cz.triangle.domy.www;

import cz.rtnext.rs.data.Obsah;
import cz.rtnext.rs.service.annotation.AdministracePolozky;
import cz.rtnext.rs.service.annotation.AdministraceTridy;
import cz.triangle.domy.PolozkaMenu;
import cz.triangle.domy.StromMenu;
import cz.triangle.domy.form.AdminObsahForm;
import cz.triangle.domy.www.ClankyDelegate;
import cz.triangle.elementy.Historie;
import cz.triangle.elementy.Objekt;
import cz.triangle.elementy.PolozkaObjektu;
import cz.triangle.util.ConvertService;
import cz.triangle.util.UpravaRetezce;
import fr.improve.struts.taglib.layout.menu.MenuComponent;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.apache.struts.util.MessageResources;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.proxy.HibernateProxy;

public class ObsahDelegate
implements Serializable {
    private DateFormat dateFormat = DateFormat.getDateInstance(2, new Locale("CS", "cz"));
    private MenuComponent vybraneMenuComponent = null;
    private MessageResources res;
    private String idLang;
    public static final String TYP_DOKUMENT = "dokument";

    public ObsahDelegate(String idLang, MessageResources res) {
        this.res = res;
        this.idLang = idLang;
    }

    public Map novaPolozka(String kodPolozka, AdminObsahForm f, Session hsess, String trida) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            Class<?> t = Class.forName("cz.rtnext.rs.data." + trida);
            AdminObsahForm form = f;
            if (form == null) {
                form = new AdminObsahForm();
                form.setAtribut("kodPolozka", kodPolozka);
            }
            DateFormat dateFormat = DateFormat.getDateInstance(2, new Locale("cs", "CZ"));
            Calendar cal = Calendar.getInstance();
            form.setAtribut("zverejneniOd", dateFormat.format(cal.getTime()));
            cal.add(1, 40);
            form.setAtribut("zverejneniDo", dateFormat.format(cal.getTime()));
            form.setAtribut("trida", trida);
            vysledek.put("adminObsahForm", (Object)form);
            List polozky = hsess.createQuery("from PolozkaMenu polozka order by polozka.razeni").list();
            StromMenu strom = new StromMenu(polozky);
            ClankyDelegate cd = new ClankyDelegate(this.idLang, "", this.res);
            vysledek.put("seznamPolozek", cd.getSeznamPolozek(strom, "-1", false));
            vysledek.put("metadata", this.getMetadata((Obsah)t.newInstance()));
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.editace_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map editacePolozky(String id, AdminObsahForm f, Session hsess) {
        HashMap<String, Object> vysledek;
        block5: {
            vysledek = new HashMap<String, Object>();
            try {
                Obsah polozka = (Obsah)hsess.get(Obsah.class, (Serializable)new Integer(id));
                polozka = this.skutecnyObjekt(polozka);
                AdminObsahForm form = f;
                if (form == null) {
                    form = new AdminObsahForm();
                    ConvertService.registrujCeske();
                    this.copyProperties(form.getAtributy(), polozka);
                    ConvertService.odregistrujCeske();
                    form.setAtribut("kodPolozka", polozka.getPolozkaMenu().getKod());
                }
                vysledek.put("id", polozka.getId());
                vysledek.put("adminObsahForm", (Object)form);
                List polozky = hsess.createQuery("from PolozkaMenu polozka where polozka.idJazyk = ? order by polozka.razeni").setString(0, this.idLang).list();
                StromMenu strom = new StromMenu(polozky);
                ClankyDelegate cd = new ClankyDelegate(this.idLang, "", this.res);
                vysledek.put("seznamPolozek", cd.getSeznamPolozek(strom, "-1", false));
                vysledek.put("metadata", this.getMetadata(polozka));
            }
            catch (Exception e) {
                String zprava;
                String string = zprava = e.getMessage() != null ? e.getMessage() : "";
                if (e.getCause() != null && e.getCause().getMessage() != null) {
                    zprava = zprava + ", " + e.getCause().getMessage();
                    if (e.getCause().getCause() != null && e.getCause().getCause().getMessage() != null) {
                        zprava = zprava + ", " + e.getCause().getCause().getMessage();
                    }
                }
                vysledek.put("chyba", this.res.getMessage("admin.chyba.editace_polozky", (Object)zprava));
                if (!hsess.getTransaction().isActive()) break block5;
                hsess.getTransaction().rollback();
            }
        }
        return vysledek;
    }

    static boolean isStandardProperty(Class clazz) {
        return clazz.isPrimitive() || clazz.isAssignableFrom(Byte.class) || clazz.isAssignableFrom(Short.class) || clazz.isAssignableFrom(Integer.class) || clazz.isAssignableFrom(Long.class) || clazz.isAssignableFrom(Float.class) || clazz.isAssignableFrom(Double.class) || clazz.isAssignableFrom(Character.class) || clazz.isAssignableFrom(String.class) || clazz.isAssignableFrom(Boolean.class);
    }

    private void copyProperties(Map<String, String> cil, Obsah zdroj) throws Exception {
        Map fields = BeanUtils.describe((Object)zdroj);
        Iterator iterator = fields.keySet().iterator();
        while (iterator.hasNext()) {
            Object result = null;
            String klic = (String)iterator.next();
            String hodnota = null;
            hodnota = BeanUtils.getProperty((Object)zdroj, (String)klic);
            Class<?> trida = zdroj.getClass();
            PropertyDescriptor propertyDescriptor = null;
            result = PropertyUtils.getProperty((Object)zdroj, (String)klic);
            result = this.skutecnyObjekt(result);
            propertyDescriptor = PropertyUtils.getPropertyDescriptor((Object)zdroj, (String)klic);
            if (propertyDescriptor.getPropertyType().getName().startsWith("cz.triangle") && propertyDescriptor.getPropertyType() != PolozkaMenu.class) {
                cil.put("id_" + klic, result.getClass().getMethod("getId", null).invoke(result, null).toString());
                continue;
            }
            cil.put(klic, hodnota);
        }
    }

    protected Serializable pripravId(Class trida, Serializable id) throws InstantiationException, IllegalAccessException, NoSuchFieldException, SecurityException, NoSuchMethodException {
        Class<?> idClass = trida.getMethod("getId", new Class[0]).getReturnType();
        if (idClass == Integer.class || idClass == Integer.TYPE) {
            id = new Integer((String)((Object)id));
        }
        return id;
    }

    protected Class getNavazanaTrida(Class trida, String podklic) throws ClassNotFoundException {
        String podtrida = podklic.substring(0, 1).toUpperCase() + podklic.substring(1);
        int iby = podtrida.indexOf("By");
        if (iby > 0) {
            podtrida = podtrida.substring(0, iby);
        }
        Class<?> navazanaTrida = Class.forName("cz.triangle.domy." + podtrida);
        return navazanaTrida;
    }

    private Serializable vratKonvertovanouHodnotu(Class trida, String metoda, String hodnota) throws InstantiationException, IllegalAccessException, NoSuchFieldException, SecurityException, NoSuchMethodException, ClassNotFoundException {
        Class navazanaTrida = this.getNavazanaTrida(trida, this.nazevAtributu(metoda.substring(3)));
        Class<?> idClass = navazanaTrida.getMethod("getId", new Class[0]).getReturnType();
        Object vysledek = hodnota;
        if (idClass == Integer.class || idClass == Integer.TYPE) {
            vysledek = new Integer(hodnota);
        }
        return vysledek;
    }

    private void copyProperties(Obsah cil, Map<String, String> zdroj, Session session) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, SecurityException, NoSuchFieldException, InstantiationException {
        for (String klic : zdroj.keySet()) {
            String hodnota = zdroj.get(klic);
            Class<?> trida = cil.getClass();
            if (klic.startsWith("id_")) {
                String podklic = this.nazevAtributu(klic.substring(3));
                if (hodnota.equalsIgnoreCase("null") || hodnota.equalsIgnoreCase("-1")) {
                    try {
                        PropertyUtils.setProperty((Object)cil, (String)podklic, null);
                    }
                    catch (Exception e) {}
                    continue;
                }
                try {
                    Class navazanaTrida = this.getNavazanaTrida(trida, podklic);
                    Serializable idZavisleho = this.vratKonvertovanouHodnotu(trida, klic, hodnota);
                    Object podpolozka = session.load(navazanaTrida, idZavisleho);
                    PropertyUtils.setProperty((Object)cil, (String)podklic, (Object)podpolozka);
                }
                catch (Exception e) {}
                continue;
            }
            try {
                if (hodnota.equalsIgnoreCase("null")) {
                    PropertyUtils.setProperty((Object)cil, (String)klic, null);
                    continue;
                }
                BeanUtils.copyProperty((Object)cil, (String)klic, (Object)hodnota);
            }
            catch (Exception e) {}
        }
    }

    private String validacniChyba(ActionMessages messages, MessageResources res) {
        if (messages != null && !messages.isEmpty()) {
            Iterator iter = messages.get();
            ActionMessage message = (ActionMessage)iter.next();
            return res.getMessage(message.getKey(), message.getValues());
        }
        return null;
    }

    public Map zapsatNovouPolozku(AdminObsahForm form, ActionMapping mapping, HttpServletRequest request, Session hsess, String cesta, String user) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            String trida = form.getAtribut("trida");
            Class<?> t = Class.forName("cz.rtnext.rs.data." + trida);
            String hlaska = this.validuj(t, form, this.res);
            if (hlaska != null) {
                vysledek.put("validacni_chyba", hlaska);
                vysledek.put("adminObsahForm", (Object)form);
                return vysledek;
            }
            Obsah novaPolozka = (Obsah)t.newInstance();
            ConvertService.registrujCeske();
            this.copyProperties(novaPolozka, form.getAtributy(), hsess);
            ConvertService.odregistrujCeske();
            PolozkaMenu rodic = (PolozkaMenu)hsess.load(PolozkaMenu.class, (Serializable)((Object)form.getAtribut("kodPolozka")));
            novaPolozka.setPolozkaMenu(rodic);
            rodic.setObsah(Boolean.TRUE);
            this.zapisSoubory(form, cesta, hsess, t, novaPolozka);
            vysledek.put("adminObsahForm", (Object)form);
            Integer noveId = (Integer)hsess.save((Object)novaPolozka);
            vysledek.put("id", noveId);
            if (user != null && user.length() > 0) {
                Historie historie = new Historie();
                historie.setCas(new Date());
                historie.setIdObjekt(noveId);
                historie.setJmeno(user);
                historie.setPredmet(trida);
                hsess.save((Object)historie);
            }
            hsess.flush();
            String zasilat = form.getAtribut("zasilat");
            if (zasilat != null && zasilat.equalsIgnoreCase("ano")) {
                String zakladAdresy = request.getRequestURL().substring(0, request.getRequestURL().indexOf(request.getServletPath()) + 1);
                this.rozesliMail(novaPolozka, t, this.res, cesta, zakladAdresy, hsess);
            }
        }
        catch (HibernateException e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
            if (hsess.getTransaction().isActive()) {
                hsess.getTransaction().rollback();
            }
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    private void rozesliMail(Object novaPolozka, Class t, MessageResources res, String cesta, String zakladAdresy, Session hsess) throws AddressException, MessagingException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
    }

    private void zapisSoubory(AdminObsahForm form, String cesta, Session hsess, Class t, Object polozka) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
    }

    private void smazatSoubory(String cesta, Session hsess, Obsah obsah) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
    }

    public Map zapsatPolozku(AdminObsahForm form, String id, ActionMapping mapping, HttpServletRequest request, Session hsess, String cesta, String user) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            Obsah polozka = (Obsah)hsess.load(Obsah.class, (Serializable)new Integer(id));
            polozka = this.skutecnyObjekt(polozka);
            Class<?> t = polozka.getClass();
            String hlaska = this.validuj(t, form, this.res);
            if (hlaska != null) {
                vysledek.put("validacni_chyba", hlaska);
                vysledek.put("adminObsahForm", (Object)form);
                return vysledek;
            }
            PolozkaMenu staryRodic = polozka.getPolozkaMenu();
            ConvertService.registrujCeske();
            this.copyProperties(polozka, form.getAtributy(), hsess);
            ConvertService.odregistrujCeske();
            PolozkaMenu rodic = (PolozkaMenu)hsess.load(PolozkaMenu.class, (Serializable)((Object)form.getAtribut("kodPolozka")));
            polozka.setPolozkaMenu(rodic);
            this.prenastavObsah(staryRodic, hsess);
            rodic.setObsah(Boolean.TRUE);
            this.zapisSoubory(form, cesta, hsess, t, polozka);
            vysledek.put("adminObsahForm", (Object)form);
            vysledek.put("id", new Integer(id));
            if (user != null && user.length() > 0) {
                Historie historie = new Historie();
                historie.setCas(new Date());
                historie.setIdObjekt(new Integer(id));
                historie.setJmeno(user);
                historie.setPredmet(polozka.getTrida());
                hsess.save((Object)historie);
            }
            hsess.flush();
            String zasilat = form.getAtribut("zasilat");
            if (zasilat != null && zasilat.equalsIgnoreCase("ano")) {
                String zakladAdresy = request.getRequestURL().substring(0, request.getRequestURL().indexOf(request.getServletPath()) + 1);
                this.rozesliMail(polozka, t, this.res, cesta, zakladAdresy, hsess);
            }
        }
        catch (HibernateException e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
            if (hsess.getTransaction().isActive()) {
                hsess.getTransaction().rollback();
            }
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map smazatPolozku(String id, Session hsess, String cesta, String user) {
        HashMap<String, String> vysledek = new HashMap<String, String>();
        try {
            Obsah obsah = (Obsah)hsess.load(Obsah.class, (Serializable)new Integer(id));
            PolozkaMenu staryRodic = obsah.getPolozkaMenu();
            this.smazatSoubory(cesta, hsess, obsah);
            hsess.delete((Object)obsah);
            this.prenastavObsah(staryRodic, hsess);
            if (user != null && user.length() > 0) {
                Historie historie = new Historie();
                historie.setCas(new Date());
                historie.setIdObjekt(new Integer(id));
                historie.setJmeno(user);
                historie.setPredmet(obsah.getTrida());
                hsess.save((Object)historie);
            }
            hsess.flush();
        }
        catch (HibernateException e) {
            e.printStackTrace();
            vysledek.put("chyba", this.res.getMessage("admin.chyba.smazani_polozky", (Object)e.getMessage()));
            if (hsess.getTransaction().isActive()) {
                hsess.getTransaction().rollback();
            }
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.smazani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public void otevriVybrany() {
        if (this.vybraneMenuComponent != null) {
            for (MenuComponent tmp = this.vybraneMenuComponent.getParent(); tmp != null; tmp = tmp.getParent()) {
                tmp.setOpen(true);
            }
        }
    }

    private String prepisSoubor(String cesta, long privesek, FormFile file, String staryNazev) {
        if (file != null && !file.getFileName().equalsIgnoreCase("")) {
            if (staryNazev != null && staryNazev.length() > 0) {
                this.smazatSoubor(cesta, staryNazev);
            }
            String koncovka = file.getFileName().substring(file.getFileName().lastIndexOf("."));
            String predek = file.getFileName().substring(0, file.getFileName().lastIndexOf("."));
            String novyNazev = this.vytvorNazevSouboru(predek, cesta, koncovka);
            this.zapisSoubor(file, cesta, novyNazev + koncovka);
            return novyNazev + koncovka;
        }
        return null;
    }

    private void smazatSoubor(String cesta, String staryNazev) {
        new File(cesta + File.separator + staryNazev).delete();
    }

    private String vytvorNazevSouboru(String soubor, String umisteni, String koncovka) {
        String vysledek = UpravaRetezce.odstranVse(soubor);
        int i = 1;
        while (new File(umisteni + File.separator + vysledek + koncovka).exists()) {
            vysledek = vysledek + i;
        }
        return vysledek;
    }

    private boolean zapisSoubor(FormFile file, String umisteni, String soubor) {
        boolean vysledek = true;
        try {
            FileOutputStream bos = new FileOutputStream(umisteni + File.separator + soubor);
            InputStream stream = file.getInputStream();
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = stream.read(buffer, 0, 8192)) != -1) {
                ((OutputStream)bos).write(buffer, 0, bytesRead);
            }
            ((OutputStream)bos).close();
        }
        catch (IOException e) {
            return false;
        }
        return vysledek;
    }

    public String velkePrvniPismeno(String vstup) {
        return vstup.substring(0, 1).toUpperCase() + vstup.substring(1);
    }

    public String nazevObjektu(String vstup) {
        StringBuffer sb = new StringBuffer("Objekt");
        for (int i = 0; i < vstup.length(); ++i) {
            char znak = vstup.charAt(i);
            if (i == 0) {
                sb.append(vstup.substring(0, 1).toUpperCase());
                continue;
            }
            if (znak == '_' && vstup.length() > i + 1) {
                sb.append(vstup.substring(++i, i + 1).toUpperCase());
                continue;
            }
            sb.append(vstup.charAt(i));
        }
        return sb.toString();
    }

    public String nazevObjektuSMalym(String vstup) {
        StringBuffer sb = new StringBuffer("objekt");
        for (int i = 0; i < vstup.length(); ++i) {
            char znak = vstup.charAt(i);
            if (i == 0) {
                sb.append(vstup.substring(0, 1).toUpperCase());
                continue;
            }
            if (znak == '_' && vstup.length() > i + 1) {
                sb.append(vstup.substring(++i, i + 1).toUpperCase());
                continue;
            }
            sb.append(vstup.charAt(i));
        }
        return sb.toString();
    }

    public String nazevAtributu(String vstup) {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < vstup.length(); ++i) {
            char znak = vstup.charAt(i);
            if (znak == '_' && vstup.length() > i + 1) {
                sb.append(vstup.substring(++i, i + 1).toUpperCase());
                continue;
            }
            sb.append(vstup.charAt(i));
        }
        return sb.toString();
    }

    public String seznamPolozek(Set set) {
        int i = 0;
        StringBuffer sb = new StringBuffer();
        for (PolozkaObjektu polozka : set) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.nazevAtributu(polozka.getKod()));
            ++i;
        }
        return sb.toString();
    }

    public String seznamPolozekRazeni(Set set) {
        int i = 0;
        StringBuffer sb = new StringBuffer();
        for (PolozkaObjektu polozka : set) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.nazevAtributu(polozka.getKod()));
            if (polozka.getSeznamRazeniSmer() != null && polozka.getSeznamRazeniSmer().equalsIgnoreCase("desc")) {
                sb.append(" desc");
            }
            ++i;
        }
        return sb.toString();
    }

    public String SqlCreateObjekt(Objekt objekt) {
        StringBuffer sb = new StringBuffer("create table objekt_");
        sb.append(objekt.getId());
        sb.append("\n(\n");
        sb.append("\tid serial not null,\n");
        sb.append("\tid_objekt character varying(40),\n");
        for (PolozkaObjektu polozka : objekt.getPolozkaObjektus()) {
            sb.append("\t");
            sb.append(polozka.getKod());
            sb.append(" ");
            sb.append(polozka.getTypDatabaze());
            if (polozka.getTypDatabaze().equalsIgnoreCase("character varying")) {
                sb.append("(" + polozka.getPocetZnaku() + ")");
            }
            sb.append(",\n");
        }
        if (objekt.getObjekt() != null) {
            sb.append("\tid_objekt_" + objekt.getObjekt().getId() + " integer,\n");
            sb.append("\tCONSTRAINT fk_objekt_" + objekt.getId() + "_objekt_" + objekt.getObjekt().getId() + " FOREIGN KEY " + "(id_objekt_" + objekt.getObjekt().getId() + ") REFERENCES objekt_" + objekt.getObjekt().getId() + " (id) MATCH SIMPLE " + "ON UPDATE CASCADE ON DELETE CASCADE,\n");
        }
        sb.append("\tCONSTRAINT fk_objekt_" + objekt.getId() + "_objekt FOREIGN KEY " + "(id_objekt) REFERENCES objekt (id) MATCH SIMPLE " + "ON UPDATE CASCADE ON DELETE CASCADE,\n");
        sb.append("\tconstraint objekt_" + objekt.getId() + "_pkey primary key (id)\n");
        sb.append(");");
        return sb.toString();
    }

    private String validuj(Class t, AdminObsahForm f, MessageResources res) {
        String hlaska = null;
        return hlaska;
    }

    public String getPodminkaFiltr(Objekt objekt, Map parametryZeStranky) {
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        Iterator iterator = objekt.getFiltry().keySet().iterator();
        while (iterator.hasNext()) {
            String klic = this.nazevAtributu((String)iterator.next());
            String[] parametrPole = (String[])parametryZeStranky.get(objekt.getId() + "_" + klic);
            String hodnota = null;
            if (parametrPole != null) {
                hodnota = parametrPole[0];
            }
            if (hodnota == null || hodnota.trim().length() <= 0 || hodnota.equalsIgnoreCase("-1")) continue;
            if (i > 0) {
                sb.append(" and ");
            }
            sb.append(klic);
            sb.append("='");
            sb.append(hodnota);
            sb.append("'");
            ++i;
        }
        return sb.toString();
    }

    private void prenastavObsah(PolozkaMenu polozka, Session hsess) {
        try {
            if (polozka.getStranka().equalsIgnoreCase("clanky.jsp")) {
                Iterator iter = hsess.createQuery("from Obsah obsah where obsah.polozkaMenu = ?").setEntity(0, (Object)polozka).iterate();
                if (iter.hasNext()) {
                    polozka.setObsah(Boolean.TRUE);
                } else {
                    polozka.setObsah(Boolean.FALSE);
                }
            } else {
                polozka.setObsah(Boolean.TRUE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private HashMap<String, Object> getMetadata(Obsah obsah) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, IntrospectionException {
        PropertyDescriptor[] props;
        obsah = this.skutecnyObjekt(obsah);
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        ArrayList atributy = new ArrayList();
        metadata.put("atributy", atributy);
        Class<?> trida = obsah.getClass();
        HashMap<String, Method> methodsMap = new HashMap<String, Method>();
        BeanInfo info = Introspector.getBeanInfo(trida);
        for (PropertyDescriptor pd : props = info.getPropertyDescriptors()) {
            Method readMethod = pd.getReadMethod();
            if (readMethod == null || !Modifier.isPublic(readMethod.getModifiers())) continue;
            methodsMap.put(pd.getName(), readMethod);
        }
        AdministraceTridy administraceTridy = trida.getAnnotation(AdministraceTridy.class);
        metadata.put("nazev", administraceTridy.nazev());
        for (String poleAdministrace : administraceTridy.polozkyAdministrace()) {
            if (!methodsMap.containsKey(poleAdministrace)) continue;
            Method method = (Method)methodsMap.get(poleAdministrace);
            AdministracePolozky administracePolozky = method.getAnnotation(AdministracePolozky.class);
            HashMap<String, String> popisAtributu = new HashMap<String, String>();
            atributy.add(popisAtributu);
            PropertyDescriptor propertyDescriptor = PropertyUtils.getPropertyDescriptor((Object)obsah, (String)poleAdministrace);
            if (propertyDescriptor.getPropertyType().getName().startsWith("cz.triangle") && propertyDescriptor.getPropertyType() != PolozkaMenu.class) {
                popisAtributu.put("nazev", "id_" + poleAdministrace);
            } else {
                popisAtributu.put("nazev", poleAdministrace);
            }
            if (administracePolozky != null && administracePolozky.napis() != null) {
                popisAtributu.put("napis", administracePolozky.napis());
            } else {
                popisAtributu.put("napis", poleAdministrace);
            }
            if (administracePolozky != null && administracePolozky.typBoxu() != null) {
                popisAtributu.put("typBoxu", administracePolozky.typBoxu());
            } else {
                popisAtributu.put("typBoxu", "text");
            }
            if (administracePolozky == null || administracePolozky.selectJson() == null) continue;
            popisAtributu.put("selectJson", administracePolozky.selectJson());
        }
        return metadata;
    }

    private Obsah skutecnyObjekt(Obsah obsah) {
        Hibernate.initialize((Object)obsah);
        if (obsah instanceof HibernateProxy) {
            obsah = (Obsah)((HibernateProxy)obsah).getHibernateLazyInitializer().getImplementation();
        }
        return obsah;
    }

    private Object skutecnyObjekt(Object obsah) {
        Hibernate.initialize((Object)obsah);
        if (obsah instanceof HibernateProxy) {
            obsah = ((HibernateProxy)obsah).getHibernateLazyInitializer().getImplementation();
        }
        return obsah;
    }

    public boolean isGetter(Method method) {
        if (Modifier.isPublic(method.getModifiers()) && method.getParameterTypes().length == 0) {
            if (method.getName().matches("^get[A-Z].*") && !method.getReturnType().equals(Void.TYPE)) {
                return true;
            }
            if (method.getName().matches("^is[A-Z].*") && method.getReturnType().equals(Boolean.TYPE)) {
                return true;
            }
        }
        return false;
    }
}

