/*
 * Decompiled with CFR 0.152.
 */
package cz.triangle.domy.www;

import cz.triangle.domy.PolozkaMenu;
import cz.triangle.domy.Upoutavka;
import cz.triangle.domy.form.AdminUpoutavkaForm;
import cz.triangle.util.ConvertService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.apache.struts.util.MessageResources;
import org.hibernate.HibernateException;
import org.hibernate.Session;

public class UpoutavkaDelegate
implements Serializable {
    private MessageResources res;
    private String localeId;

    public UpoutavkaDelegate(MessageResources res, String localeId, Session hsess) {
        this.res = res;
        this.localeId = localeId;
    }

    private String validacniChyba(ActionMessages messages) {
        if (messages != null && !messages.isEmpty()) {
            Iterator iter = messages.get();
            ActionMessage message = (ActionMessage)iter.next();
            return this.res.getMessage(message.getKey(), message.getValues());
        }
        return null;
    }

    public Map zapsatNovouPolozku(AdminUpoutavkaForm form, ActionMapping mapping, HttpServletRequest request, String cesta, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            Integer nejvyssiRazeni;
            ActionErrors errors = form.validate(mapping, request);
            if (errors != null && !errors.isEmpty()) {
                vysledek.put("validacni_chyba", this.validacniChyba((ActionMessages)errors));
                vysledek.put("adminUpoutavkaForm", (Object)form);
                return vysledek;
            }
            Upoutavka novaPolozka = new Upoutavka();
            ConvertService.registrujCeske();
            BeanUtils.copyProperties((Object)novaPolozka, (Object)((Object)form));
            ConvertService.odregistrujCeske();
            vysledek.put("adminUpoutavkaForm", (Object)form);
            PolozkaMenu polozkaMenu = (PolozkaMenu)hsess.load(PolozkaMenu.class, (Serializable)((Object)form.getPolozkaMenuKod()));
            novaPolozka.setPolozkaMenu(polozkaMenu);
            novaPolozka.setJazykId(this.localeId);
            hsess.save((Object)novaPolozka);
            FormFile file = form.getSouborFile();
            if (file != null && file.getFileName().length() > 0) {
                novaPolozka.setSoubor(UpoutavkaDelegate.ulozSoubor(cesta, novaPolozka, file));
            }
            if ((nejvyssiRazeni = this.getNoveRazeni(polozkaMenu, novaPolozka, hsess)) != null) {
                novaPolozka.setRazeni(nejvyssiRazeni + 1);
            } else {
                novaPolozka.setRazeni(0);
            }
            vysledek.put("id", novaPolozka.getId());
            hsess.flush();
        }
        catch (HibernateException e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
            if (hsess.getTransaction().isActive()) {
                hsess.getTransaction().rollback();
            }
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    Integer getNoveRazeni(PolozkaMenu polozkaMenu, Upoutavka novaPolozka, Session hsess) {
        Iterator iter = hsess.createQuery("from Upoutavka upoutavka where upoutavka.polozkaMenu=? and upoutavka<>? order by upoutavka.razeni desc").setEntity(0, (Object)polozkaMenu).setMaxResults(1).setEntity(1, (Object)novaPolozka).iterate();
        if (iter.hasNext()) {
            Upoutavka upoutavka = (Upoutavka)iter.next();
            return upoutavka.getRazeni();
        }
        return null;
    }

    public Map posunNahoru(String id, Session hsess) {
        HashMap<String, String> vysledek = new HashMap<String, String>();
        try {
            Upoutavka upoutavka = (Upoutavka)hsess.load(Upoutavka.class, (Serializable)new Integer(id));
            List seznam = hsess.createQuery("from Upoutavka upoutavka where upoutavka.polozkaMenu=? order by upoutavka.razeni").setEntity(0, (Object)upoutavka.getPolozkaMenu()).list();
            int indexVybrane = seznam.lastIndexOf(upoutavka);
            if (indexVybrane > 0) {
                seznam.remove(indexVybrane);
                seznam.add(indexVybrane - 1, upoutavka);
            }
            int i = 0;
            for (Upoutavka u : seznam) {
                u.setRazeni(i);
                ++i;
            }
            hsess.flush();
        }
        catch (HibernateException e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
            if (hsess.getTransaction().isActive()) {
                hsess.getTransaction().rollback();
            }
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map posunDolu(String id, Session hsess) {
        HashMap<String, String> vysledek = new HashMap<String, String>();
        try {
            Upoutavka upoutavka = (Upoutavka)hsess.load(Upoutavka.class, (Serializable)new Integer(id));
            List seznam = hsess.createQuery("from Upoutavka upoutavka where upoutavka.polozkaMenu=? order by upoutavka.razeni").setEntity(0, (Object)upoutavka.getPolozkaMenu()).list();
            int indexVybrane = seznam.lastIndexOf(upoutavka);
            if (indexVybrane < seznam.size() - 1) {
                seznam.remove(indexVybrane);
                seznam.add(indexVybrane + 1, upoutavka);
            }
            int i = 0;
            for (Upoutavka u : seznam) {
                u.setRazeni(i);
                ++i;
            }
            hsess.flush();
        }
        catch (HibernateException e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
            if (hsess.getTransaction().isActive()) {
                hsess.getTransaction().rollback();
            }
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public static String ulozSoubor(String cesta, Upoutavka novaPolozka, FormFile file) {
        if (file != null && !file.getFileName().equalsIgnoreCase("")) {
            String koncovka = file.getFileName().substring(file.getFileName().lastIndexOf("."));
            String zacatek = file.getFileName().substring(0, file.getFileName().lastIndexOf("."));
            UpoutavkaDelegate.zapisSoubor(file, cesta + "dbimg", zacatek + "_" + novaPolozka.getId() + koncovka);
            return zacatek + "_" + novaPolozka.getId() + koncovka;
        }
        return null;
    }

    public static boolean zapisSoubor(FormFile file, String umisteni, String soubor) {
        boolean vysledek = true;
        try {
            FileOutputStream bos = new FileOutputStream(umisteni + File.separator + soubor);
            InputStream stream = file.getInputStream();
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = stream.read(buffer, 0, 8192)) != -1) {
                ((OutputStream)bos).write(buffer, 0, bytesRead);
            }
            ((OutputStream)bos).close();
        }
        catch (IOException e) {
            return false;
        }
        return vysledek;
    }

    public Map smazatPolozku(String id, String cesta, Session hsess) {
        HashMap<String, String> vysledek = new HashMap<String, String>();
        try {
            Upoutavka staraPolozka = (Upoutavka)hsess.load(Upoutavka.class, (Serializable)new Integer(id));
            if (staraPolozka.getSoubor() != null && staraPolozka.getSoubor().length() > 0) {
                this.smazObrazek(cesta + "dbimg" + File.separator, staraPolozka.getSoubor());
            }
            hsess.delete((Object)staraPolozka);
            hsess.flush();
        }
        catch (HibernateException e) {
            e.printStackTrace();
            vysledek.put("chyba", this.res.getMessage("admin.chyba.smazani_polozky", (Object)e.getMessage()));
            if (hsess.getTransaction().isActive()) {
                hsess.getTransaction().rollback();
            }
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.smazani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    private void smazObrazek(String cesta, String soubor) {
        if (soubor != null && !soubor.equalsIgnoreCase("")) {
            File file = new File(cesta + soubor);
            file.delete();
        }
    }
}

