/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.concurrent;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentMapCache
implements Cache {
    private static final Object NULL_HOLDER = new NullHolder();
    private final String name;
    private final ConcurrentMap<Object, Object> store;
    private final boolean allowNullValues;

    public ConcurrentMapCache(String name) {
        this(name, new ConcurrentHashMap<Object, Object>(256), true);
    }

    public ConcurrentMapCache(String name, boolean allowNullValues) {
        this(name, new ConcurrentHashMap<Object, Object>(256), allowNullValues);
    }

    public ConcurrentMapCache(String name, ConcurrentMap<Object, Object> store, boolean allowNullValues) {
        this.name = name;
        this.store = store;
        this.allowNullValues = allowNullValues;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ConcurrentMap getNativeCache() {
        return this.store;
    }

    public boolean isAllowNullValues() {
        return this.allowNullValues;
    }

    @Override
    public Cache.ValueWrapper get(Object key) {
        Object value = this.store.get(key);
        return value != null ? new SimpleValueWrapper(this.fromStoreValue(value)) : null;
    }

    @Override
    public void put(Object key, Object value) {
        this.store.put(key, this.toStoreValue(value));
    }

    @Override
    public void evict(Object key) {
        this.store.remove(key);
    }

    @Override
    public void clear() {
        this.store.clear();
    }

    protected Object fromStoreValue(Object storeValue) {
        if (this.allowNullValues && storeValue == NULL_HOLDER) {
            return null;
        }
        return storeValue;
    }

    protected Object toStoreValue(Object userValue) {
        if (this.allowNullValues && userValue == null) {
            return NULL_HOLDER;
        }
        return userValue;
    }

    private static class NullHolder
    implements Serializable {
        private NullHolder() {
        }
    }
}

