/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSBitmapFill;
import com.flagstone.transform.FSBounds;
import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSDefineObject;
import com.flagstone.transform.FSFillStyle;
import com.flagstone.transform.FSLineStyle;
import com.flagstone.transform.FSMorphBitmapFill;
import com.flagstone.transform.FSMorphGradientFill;
import com.flagstone.transform.FSMorphSolidFill;
import com.flagstone.transform.FSMorphSolidLine;
import com.flagstone.transform.FSShape;
import com.flagstone.transform.FSTransformObject;
import com.flagstone.transform.Transform;
import java.util.ArrayList;
import java.util.Iterator;

public class FSDefineMorphShape
extends FSDefineObject {
    private FSBounds startBounds = null;
    private FSBounds endBounds = null;
    private ArrayList fillStyles = null;
    private ArrayList lineStyles = null;
    private FSShape startShape = null;
    private FSShape endShape = null;

    public FSDefineMorphShape(FSCoder fSCoder) {
        super(46, 0);
        this.decode(fSCoder);
    }

    public FSDefineMorphShape(int n, FSBounds fSBounds, FSBounds fSBounds2, ArrayList arrayList, ArrayList arrayList2, FSShape fSShape, FSShape fSShape2) {
        super(46, n);
        this.setStartBounds(fSBounds);
        this.setEndBounds(fSBounds2);
        this.setFillStyles(arrayList);
        this.setLineStyles(arrayList2);
        this.setStartShape(fSShape);
        this.setEndShape(fSShape2);
    }

    public FSDefineMorphShape(FSDefineMorphShape fSDefineMorphShape) {
        super(fSDefineMorphShape);
        this.startBounds = new FSBounds(fSDefineMorphShape.startBounds);
        this.endBounds = new FSBounds(fSDefineMorphShape.endBounds);
        this.fillStyles = new ArrayList();
        Iterator iterator = fSDefineMorphShape.fillStyles.iterator();
        while (iterator.hasNext()) {
            this.fillStyles.add(((FSFillStyle)iterator.next()).clone());
        }
        this.lineStyles = new ArrayList();
        iterator = fSDefineMorphShape.lineStyles.iterator();
        while (iterator.hasNext()) {
            this.lineStyles.add(((FSLineStyle)iterator.next()).clone());
        }
        this.startShape = new FSShape(fSDefineMorphShape.startShape);
        this.endShape = new FSShape(fSDefineMorphShape.endShape);
    }

    public void add(FSLineStyle fSLineStyle) {
        this.lineStyles.add(fSLineStyle);
    }

    public void add(FSFillStyle fSFillStyle) {
        this.fillStyles.add(fSFillStyle);
    }

    public FSBounds getStartBounds() {
        return this.startBounds;
    }

    public FSBounds getEndBounds() {
        return this.endBounds;
    }

    public ArrayList getFillStyles() {
        return this.fillStyles;
    }

    public ArrayList getLineStyles() {
        return this.lineStyles;
    }

    public FSShape getStartShape() {
        return this.startShape;
    }

    public FSShape getEndShape() {
        return this.endShape;
    }

    public void setStartBounds(FSBounds fSBounds) {
        this.startBounds = fSBounds;
    }

    public void setEndBounds(FSBounds fSBounds) {
        this.endBounds = fSBounds;
    }

    public void setFillStyles(ArrayList arrayList) {
        this.fillStyles = arrayList;
    }

    public void setLineStyles(ArrayList arrayList) {
        this.lineStyles = arrayList;
    }

    public void setStartShape(FSShape fSShape) {
        this.startShape = fSShape;
    }

    public void setEndShape(FSShape fSShape) {
        this.endShape = fSShape;
    }

    public Object clone() {
        FSDefineMorphShape fSDefineMorphShape = (FSDefineMorphShape)super.clone();
        fSDefineMorphShape.startBounds = this.startBounds != null ? (FSBounds)this.startBounds.clone() : null;
        fSDefineMorphShape.endBounds = this.endBounds != null ? (FSBounds)this.endBounds.clone() : null;
        fSDefineMorphShape.fillStyles = new ArrayList();
        Iterator iterator = this.fillStyles.iterator();
        while (iterator.hasNext()) {
            fSDefineMorphShape.fillStyles.add(((FSFillStyle)iterator.next()).clone());
        }
        fSDefineMorphShape.lineStyles = new ArrayList();
        iterator = this.lineStyles.iterator();
        while (iterator.hasNext()) {
            fSDefineMorphShape.lineStyles.add(((FSLineStyle)iterator.next()).clone());
        }
        fSDefineMorphShape.startShape = this.startShape != null ? (FSShape)this.startShape.clone() : null;
        fSDefineMorphShape.endShape = this.endShape != null ? (FSShape)this.endShape.clone() : null;
        return fSDefineMorphShape;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSDefineMorphShape fSDefineMorphShape = (FSDefineMorphShape)object;
            if (this.startBounds != null) {
                bl = this.startBounds.equals(fSDefineMorphShape.startBounds);
            } else {
                boolean bl2 = bl = this.startBounds == fSDefineMorphShape.startBounds;
            }
            if (this.endBounds != null) {
                bl = bl && this.endBounds.equals(fSDefineMorphShape.endBounds);
            } else {
                boolean bl3 = bl = bl && this.endBounds == fSDefineMorphShape.endBounds;
            }
            if (this.fillStyles != null) {
                bl = bl && this.fillStyles.equals(fSDefineMorphShape.fillStyles);
            } else {
                boolean bl4 = bl = bl && this.fillStyles == fSDefineMorphShape.fillStyles;
            }
            if (this.lineStyles != null) {
                bl = bl && this.lineStyles.equals(fSDefineMorphShape.lineStyles);
            } else {
                boolean bl5 = bl = bl && this.lineStyles == fSDefineMorphShape.lineStyles;
            }
            if (this.startShape != null) {
                bl = bl && this.startShape.equals(fSDefineMorphShape.startShape);
            } else {
                boolean bl6 = bl = bl && this.startShape == fSDefineMorphShape.startShape;
            }
            bl = this.endShape != null ? bl && this.endShape.equals(fSDefineMorphShape.endShape) : bl && this.endShape == fSDefineMorphShape.endShape;
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "startBounds", this.startBounds, n);
            Transform.append(stringBuffer, "endBounds", this.endBounds, n);
            Transform.append(stringBuffer, "fillStyles", this.fillStyles, n);
            Transform.append(stringBuffer, "lineStyles", this.lineStyles, n);
            Transform.append(stringBuffer, "startShape", this.startShape, n);
            Transform.append(stringBuffer, "endShape", this.endShape, n);
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        int n = FSCoder.size(this.fillStyles.size(), false);
        int n2 = FSCoder.size(this.lineStyles.size(), false);
        super.length(fSCoder);
        fSCoder.context[0] = 1;
        this.length += this.startBounds.length(fSCoder);
        this.length += this.endBounds.length(fSCoder);
        this.length += 4;
        this.length += this.fillStyles.size() >= 255 ? 3 : 1;
        Iterator iterator = this.fillStyles.iterator();
        while (iterator.hasNext()) {
            this.length += ((FSTransformObject)iterator.next()).length(fSCoder);
        }
        this.length += this.lineStyles.size() >= 255 ? 3 : 1;
        iterator = this.lineStyles.iterator();
        while (iterator.hasNext()) {
            this.length += ((FSTransformObject)iterator.next()).length(fSCoder);
        }
        fSCoder.context[11] = 1;
        fSCoder.context[6] = n;
        fSCoder.context[7] = n2;
        this.length += this.startShape.length(fSCoder);
        fSCoder.context[6] = 0;
        fSCoder.context[7] = 0;
        this.length += this.endShape.length(fSCoder);
        fSCoder.context[11] = 0;
        fSCoder.context[0] = 0;
        return this.length;
    }

    public void encode(FSCoder fSCoder) {
        int n = FSCoder.size(this.fillStyles.size(), false);
        int n2 = FSCoder.size(this.lineStyles.size(), false);
        super.encode(fSCoder);
        fSCoder.context[0] = 1;
        this.startBounds.encode(fSCoder);
        this.endBounds.encode(fSCoder);
        int n3 = fSCoder.getPointer();
        fSCoder.writeWord(0, 4);
        if (this.fillStyles.size() >= 255) {
            fSCoder.writeWord(255, 1);
            fSCoder.writeWord(this.fillStyles.size(), 2);
        } else {
            fSCoder.writeWord(this.fillStyles.size(), 1);
        }
        Iterator iterator = this.fillStyles.iterator();
        while (iterator.hasNext()) {
            ((FSTransformObject)iterator.next()).encode(fSCoder);
        }
        if (this.lineStyles.size() >= 255) {
            fSCoder.writeWord(255, 1);
            fSCoder.writeWord(this.lineStyles.size(), 2);
        } else {
            fSCoder.writeWord(this.lineStyles.size(), 1);
        }
        iterator = this.lineStyles.iterator();
        while (iterator.hasNext()) {
            ((FSTransformObject)iterator.next()).encode(fSCoder);
        }
        fSCoder.context[11] = 1;
        fSCoder.context[6] = n;
        fSCoder.context[7] = n2;
        this.startShape.encode(fSCoder);
        int n4 = fSCoder.getPointer() - n3 >> 3;
        int n5 = fSCoder.getPointer();
        fSCoder.setPointer(n3);
        fSCoder.writeWord(n4 - 4, 4);
        fSCoder.setPointer(n5);
        fSCoder.context[6] = 0;
        fSCoder.context[7] = 0;
        this.endShape.encode(fSCoder);
        fSCoder.context[11] = 0;
        fSCoder.context[0] = 0;
        fSCoder.endObject(this.name());
    }

    public void decode(FSCoder fSCoder) {
        int n;
        int n2 = 0;
        int n3 = 0;
        super.decode(fSCoder);
        fSCoder.context[0] = 1;
        fSCoder.context[11] = 1;
        int n4 = fSCoder.getPointer() - 16;
        this.startBounds = new FSBounds(fSCoder);
        this.endBounds = new FSBounds(fSCoder);
        int n5 = fSCoder.readWord(4, false);
        int n6 = fSCoder.getPointer();
        n2 = fSCoder.readWord(1, false);
        if (fSCoder.context[11] != 0 && n2 == 255) {
            n2 = fSCoder.readWord(2, false);
        }
        this.fillStyles = new ArrayList(n2);
        block9: for (n = 0; n < n2; ++n) {
            switch (fSCoder.scanWord(1, false)) {
                case 0: {
                    this.fillStyles.add(new FSMorphSolidFill(fSCoder));
                    continue block9;
                }
                case 16: {
                    this.fillStyles.add(new FSMorphGradientFill(fSCoder));
                    continue block9;
                }
                case 18: {
                    this.fillStyles.add(new FSMorphGradientFill(fSCoder));
                    continue block9;
                }
                case 64: {
                    this.fillStyles.add(new FSMorphBitmapFill(fSCoder));
                    continue block9;
                }
                case 65: {
                    this.fillStyles.add(new FSMorphBitmapFill(fSCoder));
                    continue block9;
                }
                case 66: {
                    this.fillStyles.add(new FSBitmapFill(fSCoder));
                    continue block9;
                }
                case 67: {
                    this.fillStyles.add(new FSBitmapFill(fSCoder));
                    continue block9;
                }
            }
        }
        n3 = fSCoder.readWord(1, false);
        if (fSCoder.context[11] != 0 && n3 == 255) {
            n3 = fSCoder.readWord(2, false);
        }
        this.lineStyles = new ArrayList(n3);
        for (n = 0; n < n3; ++n) {
            this.lineStyles.add(new FSMorphSolidLine(fSCoder));
        }
        n = fSCoder.getPointer() - n6 >> 3;
        this.startShape = new FSShape(fSCoder, n5 - n);
        n = fSCoder.getPointer() - n4 >> 3;
        this.endShape = new FSShape(fSCoder, this.length - n);
        fSCoder.context[0] = 0;
        fSCoder.context[11] = 0;
        fSCoder.endObject(this.name());
    }
}

