/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSBounds;
import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSCoordTransform;
import com.flagstone.transform.FSDefineObject;
import com.flagstone.transform.FSText;
import com.flagstone.transform.FSTransformObject;
import com.flagstone.transform.Transform;
import java.util.ArrayList;
import java.util.Iterator;

public class FSDefineText
extends FSDefineObject {
    private FSBounds bounds = null;
    private FSCoordTransform transform = null;
    private ArrayList objects = null;

    public FSDefineText(FSCoder fSCoder) {
        super(11, 0);
        this.decode(fSCoder);
    }

    public FSDefineText(int n, FSBounds fSBounds, FSCoordTransform fSCoordTransform, ArrayList arrayList) {
        super(11, n);
        this.setBounds(fSBounds);
        this.setTransform(fSCoordTransform);
        this.setObjects(arrayList);
    }

    public FSDefineText(FSDefineText fSDefineText) {
        super(fSDefineText);
        this.bounds = new FSBounds(fSDefineText.bounds);
        this.transform = new FSCoordTransform(fSDefineText.transform);
        this.objects = new ArrayList(fSDefineText.objects.size());
        Iterator iterator = fSDefineText.objects.iterator();
        while (iterator.hasNext()) {
            this.objects.add(((FSText)iterator.next()).clone());
        }
    }

    public void add(FSText fSText) {
        this.objects.add(fSText);
    }

    public FSBounds getBounds() {
        return this.bounds;
    }

    public FSCoordTransform getTransform() {
        return this.transform;
    }

    public ArrayList getObjects() {
        return this.objects;
    }

    public void setBounds(FSBounds fSBounds) {
        this.bounds = fSBounds;
    }

    public void setTransform(FSCoordTransform fSCoordTransform) {
        this.transform = fSCoordTransform;
    }

    public void setObjects(ArrayList arrayList) {
        this.objects = arrayList;
    }

    public Object clone() {
        FSDefineText fSDefineText = (FSDefineText)super.clone();
        fSDefineText.bounds = this.bounds != null ? (FSBounds)this.bounds.clone() : null;
        fSDefineText.transform = this.transform != null ? (FSCoordTransform)this.transform.clone() : null;
        fSDefineText.objects = new ArrayList(this.objects.size());
        Iterator iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            fSDefineText.objects.add(((FSText)iterator.next()).clone());
        }
        return fSDefineText;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSDefineText fSDefineText = (FSDefineText)object;
            if (this.bounds != null) {
                bl = this.bounds.equals(fSDefineText.bounds);
            } else {
                boolean bl2 = bl = this.bounds == fSDefineText.bounds;
            }
            if (this.transform != null) {
                bl = bl && this.transform.equals(fSDefineText.transform);
            } else {
                boolean bl3 = bl = bl && this.transform == fSDefineText.transform;
            }
            bl = this.objects != null ? bl && this.objects.equals(fSDefineText.objects) : bl && this.objects == fSDefineText.objects;
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "identifier", this.identifier);
            Transform.append(stringBuffer, "bounds", this.bounds, n);
            Transform.append(stringBuffer, "transform", this.transform, n);
            Transform.append(stringBuffer, "objects", this.objects, n);
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        super.length(fSCoder);
        fSCoder.context[9] = this.glyphBits();
        fSCoder.context[8] = this.advanceBits();
        this.length += this.bounds.length(fSCoder);
        this.length += this.transform.length(fSCoder);
        this.length += 2;
        Iterator iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            this.length += ((FSTransformObject)iterator.next()).length(fSCoder);
        }
        ++this.length;
        fSCoder.context[9] = 0;
        fSCoder.context[8] = 0;
        return this.length;
    }

    public void encode(FSCoder fSCoder) {
        super.encode(fSCoder);
        fSCoder.context[9] = this.glyphBits();
        fSCoder.context[8] = this.advanceBits();
        this.bounds.encode(fSCoder);
        this.transform.encode(fSCoder);
        fSCoder.writeWord(fSCoder.context[9], 1);
        fSCoder.writeWord(fSCoder.context[8], 1);
        Iterator iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            ((FSTransformObject)iterator.next()).encode(fSCoder);
        }
        fSCoder.writeWord(0, 1);
        fSCoder.context[9] = 0;
        fSCoder.context[8] = 0;
        fSCoder.endObject(this.name());
    }

    public void decode(FSCoder fSCoder) {
        int n;
        int n2 = 0;
        int n3 = 0;
        super.decode(fSCoder);
        fSCoder.getPointer();
        this.bounds = new FSBounds(fSCoder);
        boolean bl = true;
        int n4 = fSCoder.getPointer();
        for (n = 0; n < 16; ++n) {
            if (fSCoder.scanWord(1, false) != 0) {
                bl = false;
            }
            fSCoder.adjustPointer(8);
        }
        fSCoder.setPointer(n4);
        if (bl) {
            for (n = 0; n < 16; ++n) {
                fSCoder.scanWord(1, false);
                fSCoder.adjustPointer(8);
            }
        }
        this.transform = new FSCoordTransform(fSCoder);
        n2 = fSCoder.readWord(1, false);
        n3 = fSCoder.readWord(1, false);
        fSCoder.context[9] = n2;
        fSCoder.context[8] = n3;
        this.objects = new ArrayList();
        while (fSCoder.scanBits(8, false) != 0) {
            this.objects.add(new FSText(fSCoder));
        }
        fSCoder.readBits(8, false);
        fSCoder.context[9] = 0;
        fSCoder.context[8] = 0;
        fSCoder.endObject(this.name());
    }

    private int glyphBits() {
        int n = 0;
        Iterator iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            n = Math.max(n, ((FSText)iterator.next()).glyphBits());
        }
        return n;
    }

    private int advanceBits() {
        int n = 1;
        Iterator iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            n = Math.max(n, ((FSText)iterator.next()).advanceBits());
        }
        return n;
    }
}

