/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSMovieObject;
import com.flagstone.transform.Transform;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

public class FSExport
extends FSMovieObject {
    private Hashtable objects = new Hashtable();

    FSExport() {
        super(56);
    }

    public FSExport(FSCoder fSCoder) {
        super(56);
        this.decode(fSCoder);
    }

    public FSExport(int n, String string) {
        super(56);
        this.add(n, string);
    }

    public FSExport(FSExport fSExport) {
        super(fSExport);
        this.objects = new Hashtable(fSExport.objects.size());
        Iterator iterator = fSExport.objects.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            this.objects.put(k, new String((String)this.objects.get(k)));
        }
    }

    public void add(int n, String string) {
        this.objects.put(new Integer(n), string);
    }

    public Hashtable getObjects() {
        return this.objects;
    }

    public void setObjects(Hashtable hashtable) {
        this.objects = hashtable;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            bl = this.objects.equals(((FSExport)object).getObjects());
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "objects", this.objects, n);
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        super.length(fSCoder);
        this.length += 2;
        Enumeration enumeration = this.objects.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)this.objects.get(enumeration.nextElement());
            this.length += 2;
            this.length += FSCoder.strlen(string, true);
        }
        return this.length;
    }

    public void encode(FSCoder fSCoder) {
        super.encode(fSCoder);
        fSCoder.writeWord(this.objects.size(), 2);
        Enumeration enumeration = this.objects.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            String string = (String)this.objects.get(n);
            fSCoder.writeWord(n, 2);
            fSCoder.writeString(string);
            fSCoder.writeWord(0, 1);
        }
        fSCoder.endObject(this.name());
    }

    public void decode(FSCoder fSCoder) {
        super.decode(fSCoder);
        int n = fSCoder.readWord(2, false);
        for (int i = 0; i < n; ++i) {
            int n2 = fSCoder.readWord(2, false);
            String string = fSCoder.readString();
            this.add(n2, string);
        }
        fSCoder.endObject(this.name());
    }
}

