/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSActionObject;
import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSMovie;
import com.flagstone.transform.Transform;
import java.util.ArrayList;
import java.util.Iterator;

public class FSWith
extends FSActionObject {
    private ArrayList actions = null;
    private int actionsLength = 0;

    public FSWith(FSCoder fSCoder) {
        super(148);
        this.decode(fSCoder);
    }

    public FSWith(ArrayList arrayList) {
        super(148);
        this.setActions(arrayList);
    }

    public FSWith(FSWith fSWith) {
        super(fSWith);
        this.actions = new ArrayList(fSWith.actions.size());
        Iterator iterator = fSWith.actions.iterator();
        while (iterator.hasNext()) {
            this.actions.add(((FSActionObject)iterator.next()).clone());
        }
    }

    public void add(FSActionObject fSActionObject) {
        this.actions.add(fSActionObject);
    }

    public ArrayList getActions() {
        return this.actions;
    }

    public void setActions(ArrayList arrayList) {
        this.actions = arrayList;
    }

    public Object clone() {
        FSWith fSWith = (FSWith)super.clone();
        fSWith.actions = new ArrayList();
        Iterator iterator = this.actions.iterator();
        while (iterator.hasNext()) {
            fSWith.actions.add(((FSActionObject)iterator.next()).clone());
        }
        return fSWith;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            bl = this.actions.equals(((FSWith)object).getActions());
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "actions", this.actions, n);
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        super.length(fSCoder);
        this.length += 2;
        this.actionsLength = 0;
        Iterator iterator = this.actions.iterator();
        while (iterator.hasNext()) {
            FSActionObject fSActionObject = (FSActionObject)iterator.next();
            this.actionsLength += fSActionObject.length(fSCoder);
            this.actionsLength += fSActionObject.getType() > 128 ? 3 : 1;
        }
        this.length += this.actionsLength;
        return this.length;
    }

    public void encode(FSCoder fSCoder) {
        fSCoder.beginObject(this.name());
        fSCoder.writeWord(this.type, 1);
        fSCoder.writeWord(this.length - this.actionsLength, 2);
        fSCoder.writeWord(this.actionsLength, 2);
        Iterator iterator = this.actions.iterator();
        while (iterator.hasNext()) {
            FSActionObject fSActionObject = (FSActionObject)iterator.next();
            int n = fSCoder.getPointer();
            int n2 = fSCoder.getPointer() + (fSActionObject.getType() > 128 ? 24 : 8);
            int n3 = n2 + (fSActionObject.getLength() << 3);
            fSActionObject.encode(fSCoder);
            fSCoder.setPointer(n3);
            int n4 = fSCoder.getPointer() - n3 >> 3;
            if (n4 == 0) continue;
            fSCoder.context[14] = 1;
            fSCoder.context[15] = fSActionObject.getType();
            fSCoder.context[16] = n >>> 3;
            fSCoder.context[17] = n3 - n >>> 3;
            fSCoder.context[13] = n4;
        }
        fSCoder.endObject(this.name());
    }

    public void decode(FSCoder fSCoder) {
        FSActionObject fSActionObject;
        super.decode(fSCoder);
        this.actionsLength = fSCoder.readWord(2, false);
        this.length += this.actionsLength;
        this.actions = new ArrayList();
        for (int i = 0; i < this.actionsLength; i += fSActionObject.getLength() + (fSActionObject.getType() >= 128 ? 3 : 1)) {
            fSActionObject = FSMovie.decodeAction(fSCoder);
            this.actions.add(fSActionObject);
        }
        fSCoder.endObject(this.name());
    }
}

