/*
 * Decompiled with CFR 0.152.
 */
package magick.util;

import java.lang.reflect.Field;
import magick.ClassType;
import magick.ColorspaceType;
import magick.CompositeOperator;
import magick.CompressionType;
import magick.DecorationType;
import magick.DrawInfo;
import magick.ExceptionType;
import magick.FilterType;
import magick.GeometryFlags;
import magick.GravityType;
import magick.ImageInfo;
import magick.ImageType;
import magick.InterlaceType;
import magick.MagickImage;
import magick.NoiseType;
import magick.PreviewType;
import magick.PrimitiveType;

public class DisplayImageMetaData {
    public static String nameOfpublicstaticintField(Class clazz, int value) {
        Field[] f = clazz.getFields();
        for (int i = 0; i < f.length; ++i) {
            try {
                if (f[i].getType() != Integer.TYPE || f[i].getInt(null) != value) continue;
                return f[i].getName();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return value + "(unknown)";
    }

    private static String nameAndValueOfpublicstaticintField(Class clazz, int value) {
        return value + "(" + DisplayImageMetaData.nameOfpublicstaticintField(clazz, value) + ")";
    }

    public static String colorspaceTypeAsString(int value) {
        return DisplayImageMetaData.nameAndValueOfpublicstaticintField(ColorspaceType.class, value);
    }

    public static String classTypeAsString(int value) {
        return DisplayImageMetaData.nameAndValueOfpublicstaticintField(ClassType.class, value);
    }

    public static String compositeOperatorAsString(int value) {
        return DisplayImageMetaData.nameAndValueOfpublicstaticintField(CompositeOperator.class, value);
    }

    public static String compressionTypeAsString(int value) {
        return DisplayImageMetaData.nameAndValueOfpublicstaticintField(CompressionType.class, value);
    }

    public static String decorationTypeAsString(int value) {
        return DisplayImageMetaData.nameAndValueOfpublicstaticintField(DecorationType.class, value);
    }

    public static String drawInfoAsString(int value) {
        return DisplayImageMetaData.nameAndValueOfpublicstaticintField(DrawInfo.class, value);
    }

    public static String exceptionTypeAsString(int value) {
        return DisplayImageMetaData.nameAndValueOfpublicstaticintField(ExceptionType.class, value);
    }

    public static String filterTypeAsString(int value) {
        return DisplayImageMetaData.nameAndValueOfpublicstaticintField(FilterType.class, value);
    }

    public static String geometryFlagsAsString(int value) {
        return DisplayImageMetaData.nameAndValueOfpublicstaticintField(GeometryFlags.class, value);
    }

    public static String gravityTypeAsString(int value) {
        return DisplayImageMetaData.nameAndValueOfpublicstaticintField(GravityType.class, value);
    }

    public static String imageTypeAsString(int value) {
        return DisplayImageMetaData.nameAndValueOfpublicstaticintField(ImageType.class, value);
    }

    public static String interlaceTypeAsString(int value) {
        return DisplayImageMetaData.nameAndValueOfpublicstaticintField(InterlaceType.class, value);
    }

    public static String noiseTypeAsString(int value) {
        return DisplayImageMetaData.nameAndValueOfpublicstaticintField(NoiseType.class, value);
    }

    public static String previewTypeAsString(int value) {
        return DisplayImageMetaData.nameAndValueOfpublicstaticintField(PreviewType.class, value);
    }

    public static String primitiveTypeAsString(int value) {
        return DisplayImageMetaData.nameAndValueOfpublicstaticintField(PrimitiveType.class, value);
    }

    public static void displayImageInfo(ImageInfo info) {
        try {
            System.out.println("Info PreviewType is " + DisplayImageMetaData.previewTypeAsString(info.getPreviewType()));
            System.out.println("Info Monochrome is " + info.getMonochrome());
            System.out.println("Info Colorspace is " + DisplayImageMetaData.colorspaceTypeAsString(info.getColorspace()));
            System.out.println("Info Resolution units is " + info.getUnits());
            System.out.println("Info Compression is " + DisplayImageMetaData.compressionTypeAsString(info.getCompression()));
            System.out.println("Info Density is " + info.getDensity());
            System.out.println("Info magick is " + info.getMagick());
            System.out.println("Info filename is " + info.getFileName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void displayMagickImage(MagickImage image) {
        try {
            System.out.println("ImageName is " + image.getFileName());
            System.out.println("ImageFormat is " + image.getImageFormat());
            System.out.println("Imagetype is " + DisplayImageMetaData.imageTypeAsString(image.getImageType()));
            System.out.println("Compression is " + DisplayImageMetaData.compressionTypeAsString(image.getCompression()));
            System.out.println("Colorspace is " + DisplayImageMetaData.colorspaceTypeAsString(image.getColorspace()));
            System.out.println("Resolution units is " + image.getUnits());
            System.out.println("Depth is " + image.getDepth());
            System.out.println("X resolution is " + image.getXResolution());
            System.out.println("Y resolution is " + image.getYResolution());
            System.out.println("Size blob is " + image.sizeBlob());
            System.out.println("Colors " + image.getColors());
            System.out.println("Total colors " + image.getTotalColors());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

