/*
 * Decompiled with CFR 0.152.
 */
package cn.bluejoe.elfinder.localfs;

import cn.bluejoe.elfinder.localfs.LocalFsItem;
import cn.bluejoe.elfinder.service.FsItem;
import cn.bluejoe.elfinder.service.FsVolume;
import cn.bluejoe.elfinder.util.MimeTypesUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.codehaus.plexus.util.FileUtils;

public class LocalFsVolume
implements FsVolume {
    String _name;
    File _rootDir;

    private File asFile(FsItem fsi) {
        return ((LocalFsItem)fsi).getFile();
    }

    @Override
    public void createFile(FsItem fsi) throws IOException {
        this.asFile(fsi).createNewFile();
    }

    @Override
    public void createFolder(FsItem fsi) throws IOException {
        this.asFile(fsi).mkdirs();
    }

    @Override
    public void deleteFile(FsItem fsi) throws IOException {
        File file = this.asFile(fsi);
        if (!file.isDirectory()) {
            file.delete();
        }
    }

    @Override
    public void deleteFolder(FsItem fsi) throws IOException {
        File file = this.asFile(fsi);
        if (file.isDirectory()) {
            FileUtils.deleteDirectory((File)file);
        }
    }

    @Override
    public boolean exists(FsItem newFile) {
        return this.asFile(newFile).exists();
    }

    private LocalFsItem fromFile(File file) {
        return new LocalFsItem(this, file);
    }

    @Override
    public FsItem fromPath(String relativePath) {
        return this.fromFile(new File(this._rootDir, relativePath));
    }

    @Override
    public String getDimensions(FsItem fsi) {
        return null;
    }

    @Override
    public long getLastModified(FsItem fsi) {
        return this.asFile(fsi).lastModified();
    }

    @Override
    public String getMimeType(FsItem fsi) {
        File file = this.asFile(fsi);
        if (file.isDirectory()) {
            return "directory";
        }
        String ext = FileUtils.getExtension((String)file.getName());
        if (ext != null && !ext.isEmpty()) {
            String mimeType = MimeTypesUtils.getMimeType(ext);
            return mimeType == null ? "application/oct-stream" : mimeType;
        }
        return "application/oct-stream";
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getName(FsItem fsi) {
        return this.asFile(fsi).getName();
    }

    @Override
    public FsItem getParent(FsItem fsi) {
        return this.fromFile(this.asFile(fsi).getParentFile());
    }

    @Override
    public String getPath(FsItem fsi) throws IOException {
        String fullPath = this.asFile(fsi).getCanonicalPath();
        String rootPath = this._rootDir.getCanonicalPath();
        String relativePath = fullPath.substring(rootPath.length());
        return relativePath.replace('\\', '/');
    }

    @Override
    public FsItem getRoot() {
        return this.fromFile(this._rootDir);
    }

    public File getRootDir() {
        return this._rootDir;
    }

    @Override
    public long getSize(FsItem fsi) {
        return this.asFile(fsi).length();
    }

    @Override
    public String getThumbnailFileName(FsItem fsi) {
        return null;
    }

    @Override
    public boolean hasChildFolder(FsItem fsi) {
        return this.asFile(fsi).isDirectory() && this.asFile(fsi).listFiles(new FileFilter(){

            @Override
            public boolean accept(File arg0) {
                return arg0.isDirectory();
            }
        }).length > 0;
    }

    @Override
    public boolean isFolder(FsItem fsi) {
        return this.asFile(fsi).isDirectory();
    }

    @Override
    public boolean isRoot(FsItem fsi) {
        return this._rootDir == this.asFile(fsi);
    }

    @Override
    public FsItem[] listChildren(FsItem fsi) {
        ArrayList<LocalFsItem> list = new ArrayList<LocalFsItem>();
        File[] cs = this.asFile(fsi).listFiles();
        if (cs == null) {
            return new FsItem[0];
        }
        File[] fileArray = cs;
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            File c = fileArray[n2];
            list.add(this.fromFile(c));
            ++n2;
        }
        return list.toArray(new FsItem[0]);
    }

    @Override
    public InputStream openInputStream(FsItem fsi) throws IOException {
        return new FileInputStream(this.asFile(fsi));
    }

    @Override
    public OutputStream openOutputStream(FsItem fsi) throws IOException {
        return new FileOutputStream(this.asFile(fsi));
    }

    @Override
    public void rename(FsItem src, FsItem dst) throws IOException {
        this.asFile(src).renameTo(this.asFile(dst));
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setRootDir(File rootDir) {
        if (!rootDir.exists()) {
            rootDir.mkdirs();
        }
        this._rootDir = rootDir;
    }
}

