/*
 * Decompiled with CFR 0.152.
 */
package cz.triangle.domy.www;

import cz.triangle.domy.Aktualita;
import cz.triangle.domy.Jazyk;
import cz.triangle.domy.Lokalita;
import cz.triangle.domy.TypAktuality;
import cz.triangle.domy.TypAktualityJaz;
import cz.triangle.domy.form.AdminAktualitaForm;
import cz.triangle.util.ConvertService;
import fr.improve.struts.taglib.layout.menu.MenuComponent;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.hibernate.HibernateException;
import org.hibernate.Session;

public class AktualitaDelegate
implements Serializable {
    private MessageResources res;
    private String localeId;
    private MenuComponent vybraneMenuComponent = null;
    DateFormat dateFormat;
    public static final String TYP_TYP_AKTUALITY = "typ_typ_aktuality";
    public static final String TYP_AKTUALITA = "typ_aktualita";

    public AktualitaDelegate(MessageResources res, String localeId, Session hsess) {
        this.res = res;
        Jazyk jazyk = (Jazyk)hsess.load(Jazyk.class, (Serializable)((Object)localeId));
        this.localeId = localeId;
        this.dateFormat = DateFormat.getDateInstance(2, new Locale("cs", "CZ"));
    }

    public Map nactiAktuality(String kod, String typ, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        List polozky = hsess.createQuery("from TypAktuality typAktuality left join fetch typAktuality.typAktualityJazs typAktualityJaz where typAktualityJaz.jazyk.id=? order by typAktuality.id").setString(0, this.localeId).list();
        MenuComponent treeData = new MenuComponent();
        treeData.setTitle("root");
        treeData.setDescription("root");
        treeData.setName("root");
        if (polozky.size() > 0) {
            this.vytvorTypyAktualit(polozky, kod, typ, treeData, hsess);
        }
        vysledek.put("strom", treeData);
        if (kod != null && this.vybraneMenuComponent == null) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.vybrano_neexistujici_id"));
        }
        return vysledek;
    }

    private void vytvorTypyAktualit(List polozky, String kod, String typ, MenuComponent rodic, Session hsess) {
        for (TypAktuality typAktuality : polozky) {
            MenuComponent node = new MenuComponent();
            node.setTitle(((TypAktualityJaz)typAktuality.getTypAktualityJazs().get(this.localeId)).getNazev());
            node.setDescription(typAktuality.getId().toString());
            node.setToolTip(TYP_TYP_AKTUALITY);
            node.setImage("yellow-folder-closed.png");
            node.setLocation("admin_aktualita.do?akce=vybrat_rodic&typ=typ_typ_aktuality&id=" + typAktuality.getId());
            Object vybranyKodi = null;
            if (typ != null && typ.equalsIgnoreCase(TYP_TYP_AKTUALITY) && kod != null && kod.equals(typAktuality.getId())) {
                node.setStyle("font-weight: bold;");
                this.vybraneMenuComponent = node;
            }
            rodic.addMenuComponent(node);
            List aktuality = hsess.createQuery("from Aktualita aktualita where aktualita.typAktuality.id = ? and aktualita.jazykId=?").setString(0, typAktuality.getId()).setString(1, this.localeId).list();
            this.vytvorAktuality(aktuality, node, kod, typ, hsess);
        }
    }

    private void vytvorAktuality(List polozky, MenuComponent rodic, String vybranyKod, String typ, Session hsess) {
        for (Aktualita aktualita : polozky) {
            MenuComponent node = new MenuComponent();
            node.setTitle(" " + this.dateFormat.format(aktualita.getDatum()));
            node.setDescription(aktualita.getId().toString());
            node.setToolTip(TYP_AKTUALITA);
            node.setImage("aktualita.gif");
            node.setLocation("admin_aktualita.do?akce=editace_polozky&typ=typ_aktualita&id=" + aktualita.getId());
            Integer vybranyKodi = null;
            try {
                vybranyKodi = new Integer(vybranyKod);
            }
            catch (NumberFormatException e) {
                vybranyKodi = null;
            }
            if (typ != null && typ.equalsIgnoreCase(TYP_AKTUALITA) && vybranyKodi != null && vybranyKodi.equals(aktualita.getId())) {
                node.setStyle("font-weight: bold;");
                this.vybraneMenuComponent = node;
            }
            rodic.addMenuComponent(node);
        }
    }

    public Map novaPolozka(AdminAktualitaForm f, String id, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            AdminAktualitaForm form = f;
            if (form == null) {
                form = new AdminAktualitaForm();
                form.setLokalitaId(id);
            }
            Calendar cal = Calendar.getInstance();
            form.setDatum(this.dateFormat.format(cal.getTime()));
            cal.add(1, 30);
            form.setDatumdo(this.dateFormat.format(cal.getTime()));
            form.setTypAktualityId(id);
            vysledek.put("adminAktualitaForm", (Object)form);
            vysledek.put("seznamLokalit", this.getSeznamLokalit(hsess));
            vysledek.put("seznamTypuAktualit", this.getSeznamTypuAktualit(hsess));
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.editace_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map editacePolozky(String id, AdminAktualitaForm f, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            Aktualita polozka = (Aktualita)hsess.load(Aktualita.class, (Serializable)new Integer(id));
            AdminAktualitaForm form = f;
            if (form == null) {
                form = new AdminAktualitaForm();
                ConvertService.registrujCeske();
                BeanUtils.copyProperties((Object)((Object)form), (Object)polozka);
                ConvertService.odregistrujCeske();
                form.setLokalitaId(polozka.getLokalita().getId().toString());
                form.setTypAktualityId(polozka.getTypAktuality().getId().toString());
            }
            vysledek.put("id", polozka.getId());
            vysledek.put("adminAktualitaForm", (Object)form);
            vysledek.put("seznamLokalit", this.getSeznamLokalit(hsess));
            vysledek.put("seznamTypuAktualit", this.getSeznamTypuAktualit(hsess));
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.editace_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    private String validacniChyba(ActionMessages messages) {
        if (messages != null && !messages.isEmpty()) {
            Iterator iter = messages.get();
            ActionMessage message = (ActionMessage)iter.next();
            return this.res.getMessage(message.getKey(), message.getValues());
        }
        return null;
    }

    public Map zapsatNovouPolozku(AdminAktualitaForm form, ActionMapping mapping, HttpServletRequest request, String cesta, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            ActionErrors errors = form.validate(mapping, request);
            if (errors != null && !errors.isEmpty()) {
                vysledek.put("validacni_chyba", this.validacniChyba((ActionMessages)errors));
                vysledek.put("adminAktualitaForm", (Object)form);
                return vysledek;
            }
            Aktualita novaPolozka = new Aktualita();
            ConvertService.registrujCeske();
            BeanUtils.copyProperties((Object)novaPolozka, (Object)((Object)form));
            ConvertService.odregistrujCeske();
            vysledek.put("adminAktualitaForm", (Object)form);
            Lokalita lokalita = (Lokalita)hsess.load(Lokalita.class, (Serializable)new Integer(form.getLokalitaId()));
            novaPolozka.setLokalita(lokalita);
            TypAktuality typ = (TypAktuality)hsess.load(TypAktuality.class, (Serializable)((Object)form.getTypAktualityId()));
            novaPolozka.setTypAktuality(typ);
            novaPolozka.setJazykId(this.localeId);
            hsess.save((Object)novaPolozka);
            vysledek.put("id", novaPolozka.getId());
            hsess.flush();
        }
        catch (HibernateException e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
            if (hsess.getTransaction().isActive()) {
                hsess.getTransaction().rollback();
            }
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map zapsatPolozku(AdminAktualitaForm form, String id, ActionMapping mapping, HttpServletRequest request, String cesta, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            ActionErrors errors = form.validate(mapping, request);
            if (errors != null && !errors.isEmpty()) {
                vysledek.put("validacni_chyba", this.validacniChyba((ActionMessages)errors));
                vysledek.put("adminAktualitaForm", (Object)form);
                return vysledek;
            }
            Aktualita polozka = (Aktualita)hsess.load(Aktualita.class, (Serializable)new Integer(id));
            ConvertService.registrujCeske();
            BeanUtils.copyProperties((Object)polozka, (Object)((Object)form));
            ConvertService.odregistrujCeske();
            Lokalita staraLokalita = polozka.getLokalita();
            Lokalita lokalita = (Lokalita)hsess.load(Lokalita.class, (Serializable)new Integer(form.getLokalitaId()));
            polozka.setLokalita(lokalita);
            TypAktuality typ = (TypAktuality)hsess.load(TypAktuality.class, (Serializable)((Object)form.getTypAktualityId()));
            polozka.setTypAktuality(typ);
            polozka.setJazykId(this.localeId);
            vysledek.put("adminAktualitaForm", (Object)form);
            vysledek.put("id", polozka.getId());
            hsess.flush();
        }
        catch (HibernateException e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
            if (hsess.getTransaction().isActive()) {
                hsess.getTransaction().rollback();
            }
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map smazatPolozku(String id, String cesta, Session hsess) {
        HashMap<String, String> vysledek = new HashMap<String, String>();
        try {
            Aktualita staraPolozka = (Aktualita)hsess.load(Aktualita.class, (Serializable)new Integer(id));
            hsess.delete((Object)staraPolozka);
            hsess.flush();
        }
        catch (HibernateException e) {
            e.printStackTrace();
            vysledek.put("chyba", this.res.getMessage("admin.chyba.smazani_polozky", (Object)e.getMessage()));
            if (hsess.getTransaction().isActive()) {
                hsess.getTransaction().rollback();
            }
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.smazani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public List getSeznamLokalit(Session hsess) {
        return hsess.createQuery("from Lokalita lokalita order by lokalita.razeni").list();
    }

    public List getSeznamTypuAktualit(Session hsess) {
        return hsess.createQuery("from TypAktuality typAktuality order by typAktuality.id").list();
    }

    public void otevriVybrany() {
        if (this.vybraneMenuComponent != null) {
            MenuComponent tmp = this.vybraneMenuComponent.getParent();
            while (tmp != null) {
                tmp.setOpen(true);
                tmp = tmp.getParent();
            }
        }
    }
}

