/*
 * Decompiled with CFR 0.152.
 */
package fr.improve.struts.taglib.layout;

import fr.improve.struts.taglib.layout.PanelTag;
import fr.improve.struts.taglib.layout.util.LayoutUtils;
import fr.improve.struts.taglib.layout.util.Menu;
import fr.improve.struts.taglib.layout.util.MenuItem;
import fr.improve.struts.taglib.layout.util.TagUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.jsp.JspException;

public class DynMenuTag
extends PanelTag {
    protected Menu menu;
    protected String config = "fr.improve.struts.taglib.layout.DefaultDynMenuConfig";

    public void addItem(MenuItem item) {
        if (this.menu == null) {
            this.menu = new Menu();
        }
        this.menu.addItem(item);
    }

    public int doEndLayoutTag() throws JspException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<script>\n");
        this.doPrintMenu(buffer, this.menu, "");
        buffer.append("</script>\n");
        buffer.append("<SCRIPT LANGUAGE=\"JavaScript1.2\" SRC=\"config/HM_Loader.js\" TYPE='text/javascript'></SCRIPT>");
        TagUtils.write(this.pageContext, buffer.toString());
        return 6;
    }

    public void doPrintMenu(StringBuffer buffer, Menu menu, String level) throws JspException {
        Menu subMenu;
        Object[] items = menu.getItems();
        HashMap<String, Menu> subMenus = new HashMap<String, Menu>();
        buffer.append("HM_Array1");
        buffer.append(level);
        buffer.append(" = [\n");
        if (level.equals("")) {
            this.doPrintMenuConfig(buffer);
        } else {
            buffer.append("[],\n");
        }
        int i = 0;
        while (i < items.length) {
            MenuItem item = (MenuItem)items[i];
            String link = item.getLink();
            String key = item.getKey();
            subMenu = item.getSubMenu();
            if (i != 0) {
                buffer.append(",");
            }
            buffer.append("[\"");
            buffer.append(this.getLabel());
            buffer.append("\",\"");
            if (link != null) {
                buffer.append(link);
            }
            buffer.append("\",1,0,");
            if (subMenu == null) {
                buffer.append("0]\n");
            } else {
                buffer.append("1]\n");
                subMenus.put(String.valueOf(level) + "_" + (i + 1), subMenu);
            }
            ++i;
        }
        buffer.append("]\n\n");
        Set set = subMenus.entrySet();
        for (Map.Entry entry : set) {
            String subLevel = (String)entry.getKey();
            subMenu = (Menu)entry.getValue();
            this.doPrintMenu(buffer, subMenu, subLevel);
        }
    }

    protected void doPrintMenuConfig(StringBuffer buffer) throws JspException {
        String skin = LayoutUtils.getSkin(this.pageContext.getSession()).getName();
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(this.config, new Locale(skin, ""));
            buffer.append("[");
            buffer.append(bundle.getString("width"));
            buffer.append(",");
            buffer.append(bundle.getString("left_position"));
            buffer.append(",");
            buffer.append(bundle.getString("top_position"));
            buffer.append(",");
            buffer.append(bundle.getString("font_color"));
            buffer.append(",");
            buffer.append(bundle.getString("mouseover_font_color"));
            buffer.append(",");
            buffer.append(bundle.getString("background_color"));
            buffer.append(",");
            buffer.append(bundle.getString("mouseover_background_color"));
            buffer.append(",");
            buffer.append(bundle.getString("border_color"));
            buffer.append(",");
            buffer.append(bundle.getString("separator_color"));
            buffer.append(",");
            buffer.append(bundle.getString("top_is_permanent"));
            buffer.append(",");
            buffer.append(bundle.getString("top_is_horizontal"));
            buffer.append(",");
            buffer.append(bundle.getString("tree_is_horizontal"));
            buffer.append(",");
            buffer.append(bundle.getString("position_under"));
            buffer.append(",");
            buffer.append(bundle.getString("top_more_images_visible"));
            buffer.append(",");
            buffer.append(bundle.getString("tree_more_images_visible"));
            buffer.append(",");
            buffer.append(bundle.getString("evaluate_upon_tree_show"));
            buffer.append(",");
            buffer.append(bundle.getString("evaluate_upon_tree_hide"));
            buffer.append("],\n");
        }
        catch (MissingResourceException e) {
            throw new JspException(e.getMessage());
        }
    }

    public int doStartLayoutTag() throws JspException {
        if (this.name != null) {
            try {
                this.menu = (Menu)LayoutUtils.getBeanFromPageContext(this.pageContext, this.name, this.property);
            }
            catch (ClassCastException e) {
                throw new JspException("MenuTag: :Object under name=" + this.name + " property=" + this.property + " is not of type Menu.");
            }
        }
        return 1;
    }

    public void release() {
        super.release();
        this.menu = null;
        this.config = "fr.improve.struts.taglib.layout.DefaultDynMenuConfig";
    }

    public void setConfig(String config) {
        this.config = config;
    }
}

